/* ============================================================
 *
 * This file is a part of digiKam project
 * https://www.digikam.org
 *
 * Date        : 2005-05-25
 * Description : Emboss threaded image filter.
 *
 * Copyright (C) 2005-2019 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright (C) 2006-2010 by Marcel Wiesweg <marcel dot wiesweg at gmx dot de>
 * Copyright (C) 2010      by Martin Klapetek <martin dot klapetek at gmail dot com>
 *
 * Original Emboss algorithm copyrighted 2004 by
 * Pieter Z. Voloshyn <pieter dot voloshyn at gmail dot com>.
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef DIGIKAM_EMBOSS_FILTER_H
#define DIGIKAM_EMBOSS_FILTER_H

// Local includes

#include "digikam_export.h"
#include "dimgthreadedfilter.h"
#include "digikam_globals.h"

namespace Digikam
{

class DIGIKAM_EXPORT EmbossFilter : public DImgThreadedFilter
{

public:

    explicit EmbossFilter(QObject* const parent = nullptr);
    explicit EmbossFilter(DImg* const orgImage, QObject* const parent=nullptr, int depth=30);
    ~EmbossFilter();

    static QString          FilterIdentifier()
    {
        return QLatin1String("digikam:EmbossFilter");
    }

    static QString          DisplayableName();

    static QList<int>       SupportedVersions()
    {
        return QList<int>() << 1;
    }

    static int              CurrentVersion()
    {
        return 1;
    }

    virtual QString         filterIdentifier() const override
    {
        return FilterIdentifier();
    }

    virtual FilterAction    filterAction() override;
    void                    readParameters(const FilterAction& action) override;

private:

    void filterImage() override;
    void embossMultithreaded(uint start, uint stop, uint h, double Depth);

    inline int Lim_Max (int Now, int Up, int Max);
    inline int getOffset(int Width, int X, int Y, int bytesDepth);

private:

    int m_depth;
};

} // namespace Digikam

#endif // DIGIKAM_EMBOSS_FILTER_H
