/***************************************************************************
                          optionsdialog.cpp  -  description
                             -------------------
    begin                : Fri Mar 16 2001
    copyright            : (C) 2001 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "options.h"
#include <stdio.h>
#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include <kiconloader.h>


OptionsDialog::OptionsDialog(KSteak *parent, const char *name, bool, WFlags)
  : KDialogBase(KDialogBase::IconList, i18n("Preferences"), Ok|Apply|Cancel, KDialogBase::Ok, parent, name, true, true)
{
  par = parent;

  f = addPage(i18n("Colors"), i18n("Colors"), DesktopIcon("colors"));

  QGridLayout *layout = new QGridLayout(f, 3, 2, 10);

  QLabel *Label1 = new QLabel(i18n("Text"), f);
  layout->addWidget(Label1, 1, 1);
  Button1 = new KColorButton(f);
  Button1->setColor(par->textColor);
  layout->addWidget(Button1, 1, 2, AlignLeft);

  QLabel *Label2 = new QLabel(i18n("Background"), f);
  layout->addWidget(Label2, 2, 1);
  Button2 = new KColorButton(f);
  Button2->setColor(par->bgColor);
  layout->addWidget(Button2, 2, 2, AlignLeft);

  layout->setColStretch( 1, 20 );
  layout->setColStretch( 2, 20 );

  layout->setRowStretch( 1, 20 );
  layout->setRowStretch( 2, 20 );

  // Font Dialog
  f2 = addPage(i18n("Fonts"), i18n("Fonts"), DesktopIcon("fonts"));
  QVBoxLayout *topLayout = new QVBoxLayout(f2, 0, spacingHint() );
  Fontchooser = new KFontChooser( f2, "font", false, QStringList(), false, 6 );
  Fontchooser->setFont(par->mFont);
  Fontchooser->setSampleText( i18n("KSteak Sample Text") );
  topLayout->addWidget(Fontchooser);

  f3 = addPage(i18n("Shortcut"), i18n("Shortcut"), DesktopIcon("keyboard"));
  QVBoxLayout *topLayout3 = new QVBoxLayout(f3, 0, spacingHint() );
  Keychooser = new KKeyChooser( par->ga, f3);
  topLayout3->addWidget(Keychooser);

  // Popup settings
  f4 = addPage(i18n("Popup Window"), i18n("Popup Window"), DesktopIcon("winprops"));

  QVBoxLayout *v = new QVBoxLayout(f4, 0, spacingHint() );
  bGroup = new QButtonGroup(2, Qt::Vertical, i18n("Always popup at:"), f4);
  v->addWidget(bGroup);

  rButton1 = new QRadioButton(i18n("current cursor position"), bGroup);
  rButton2 = new QRadioButton(i18n("kicker (docking area)"), bGroup);

  bGroup->insert(rButton1);
  bGroup->insert(rButton2);

  if (par->SteakDock->_fPopup)
  	rButton2->setChecked(true);
  else
	rButton1->setChecked(true);
}

void OptionsDialog::slotOk()
{
  slotApply();
  accept();
}

void OptionsDialog::slotApply()
{
  par->textColor = Button1->color();
  par->bgColor = Button2->color();
  par->mFont = Fontchooser->font();
  par->applyOptions();
  Keychooser->commitChanges();
  //Keychooser-save();
  par->ga->updateConnections();
  par->SteakDock->_fPopup = rButton2->isChecked();
}
