/***************************************************************************
                 dmc.h  -  data source plugin for planck DMC
                             -------------------
    begin                : Wed July 4 2007
    copyright            : (C) 2007 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DMC_H
#define DMC_H

#include <kstdatasource.h>
#include "dmcdata.h"
#include "dmcobj.h"


class DMCSource : public KstDataSource {
  public:
    DMCSource(KConfig *cfg, const QString& filename);
    ~DMCSource();

    KstObject::UpdateType update(int = -1);

    KstFrameSize      readFieldLarge(double *v, const QString &field, KstFrameSize s, KstFrameSize n);
    KstFrameSize      readFieldLargeSkip(double *v, const QString &field, KstFrameSize s, KstFrameSize n, int skip, KstFrameSize *lastFrameRead = 0L);
    bool              isValidField(const QString &field) const;
    int               samplesPerFrame(const QString &field);
    KstFrameSize      frameCountLarge(const QString& field = QString::null) const;
    QString           fileType() const;
    void              save(QTextStream &ts, const QString& indent = QString::null);
    bool              isEmpty() const;
    bool              supportsTimeConversions() const;
    KstFrameSize      sampleForTimeLarge(const KST::ExtDateTime& time, bool *ok = 0L);
    KstFrameSize      sampleForTimeLarge(double ms, bool *ok = 0L);
    KST::ExtDateTime  timeForSampleLarge(KstFrameSize sample, bool *ok = 0L);
    double            relativeTimeForSampleLarge(KstFrameSize sample, bool *ok = 0L); // in (ms)
    bool              reset();

  private:
    KstSharedPtr<DMC::Object> _dmcObject;
    QString _filename;
};


#endif
