/***************************************************************************
                               kstviewwindow.h
                             -------------------
    begin                : Tue Aug 22 13:46:13 CST 2000
    copyright            : (C) 2000 by Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTVIEWWINDOW_H
#define KSTVIEWWINDOW_H

#include <config.h>

// include files for KDE
#include <kaccel.h>
#include <kaction.h>
#include <kapplication.h>
#include <klineeditdlg.h>
#include <kmainwindow.h>
#include <kmdichildview.h>
#include <klocale.h>

#include "kst.h"
#include "kst2dplot.h"
#include "kstdatacollection.h"
#include "kstdefaultnames.h"
#include "kstdataobject.h"
#include "ksttoplevelview.h"
#include "testview.h"

class QLabel;

/** The base class for Kst application view windows.
  */
class KstViewWindow : public KMdiChildView {
  Q_OBJECT
  public:
    KstViewWindow(QWidget *parent=0, const char *name=0);
    KstViewWindow(QDomElement& e, QWidget *parent=0, const char *name=0);
    virtual ~KstViewWindow();

    /** pause the updating of data */
    void setPaused(bool paused);
    void togglePaused();
    void save(QTextStream& ts);
    KstTopLevelViewPtr view() const;

  protected:
    /** saves the window properties for each open window during session
     * end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KMainWindow#saveProperties */
    virtual void saveProperties(KConfig *cfg);

    /** reads the session config file and restores the application's
     * state including the last opened files and documents by reading
     * the temporary files saved by saveProperties()
     * @see KMainWindow#readProperties */
    virtual void readProperties(KConfig *cfg);

  private slots:
    // Hack to update KStdActions
    void updateActions();

    void slotActivated(KMdiChildView*);

  public slots:
    /** asks for saving if the file is modified, then closes the actual
      file and window*/
    void slotFileClose();

    /** print the actual file */
    void slotFilePrint();

    /** print without querying */
    void immediatePrintToFile(const QString& filename);

    /** export to png without querying */
    void immediatePrintToPng(QDataStream* dataStream, const QSize& size, const QString& format = "PNG");
    void immediatePrintToPng(const QString& filename, const QSize& size, const QString& format = "PNG");

  public:
    template<class T> QString createPlot(const QString& suggestedName = QString::null, bool prompt = false);

  private:
    void commonConstructor();
  
    /** the configuration object of the application */
    KConfig *config;
    KstTopLevelViewPtr _view;
};


template<class T>
QString KstViewWindow::createPlot(const QString& suggestedName, bool prompt) {

  KstApp *app = KstApp::inst();
  KMdiIterator<KMdiChildView*> *iter;

  QString name = suggestedName;
  bool duplicate = true;
  while (duplicate) {
    duplicate = false;
    KstViewObjectPtr rc;
    //check the name
    iter = app->createIterator();
    while (iter->currentItem() && !duplicate) {
      KMdiChildView *childview = iter->currentItem();
      KstViewWindow *viewwindow = dynamic_cast<KstViewWindow*>(childview);
      if (viewwindow) {
        rc = viewwindow->view()->findChild(name);
        if (rc) {
          duplicate = true;
          name = KST::suggestPlotName();
        }
      }
      iter->next();
    }
    app->deleteIterator(iter);
  }

  if (prompt) {
    bool ok = false;
    name = KLineEditDlg::getText(i18n("Enter a name for the new plot:"), name, &ok, 0L);
    if (!ok) {
      return QString();
    }
    //check the name
    duplicate = true;
    while (duplicate) {
      duplicate = false;
      KstViewObjectPtr rc;
      //check the name
      iter = app->createIterator();
      while (iter->currentItem() && !duplicate) {
        KMdiChildView *childview = iter->currentItem();
        KstViewWindow *viewwindow = dynamic_cast<KstViewWindow*>(childview);
        if (viewwindow) {
          rc = viewwindow->view()->findChild(name);
          if (rc) {
            duplicate = true;
            name = KLineEditDlg::getText(i18n("Enter a name for the new plot:"), name, &ok, 0L);
            if (!ok) {
              app->deleteIterator(iter);
              return QString();
            }
          }
        }
        iter->next();
      }
      app->deleteIterator(iter);
    }
  }
  //create the plot now
  _view->createPlot<T>(name);
  return name;
}


#endif
// vim: ts=2 sw=2 et
