/***************************************************************************
                              kstviewwindow.cpp
                             -------------------
    begin                : Tue Aug 22 13:46:13 CST 2000
    copyright            : (C) 2000 by Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <stdio.h>

// include files for Qt
#include <qevent.h>
#include <qdir.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qtimer.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qbuffer.h>

// include files for KDE
#include <kaccel.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kmessagebox.h>
#include <kprinter.h>
#include <kstandarddirs.h>
#include <kstatusbar.h>
#include <kstdaction.h>
#include <kmdimainfrm.h>

// application specific includes
#include "kstviewwindow.h"
#include "kstdebug.h"
#include "kstdoc.h"
#include "kstevents.h"
#include "kstextension.h"
#include "kstsettingsdlg.h"
#include "pluginmanager.h"
#include "ksttoplevelview.h"
#include "kst.h"

#define KST_STATUSBAR_FRAME 0
#define KST_STATUSBAR_DATA 1
#define KST_STATUSBAR_STATUS 2

KstViewWindow::KstViewWindow(QWidget *parent, const char* name)
: KMdiChildView(QString::null, parent, name) {
  commonConstructor();
  _view = new KstTopLevelView(this);
}


KstViewWindow::KstViewWindow(QDomElement& e, QWidget* parent, const char* name)
: KMdiChildView(QString::null, parent, name) {
  QString in_tag;
  QRect rectRestore;
  QRect rectInternal;

  commonConstructor();
  _view = new KstTopLevelView(e, this);

  QDomNode n = e.firstChild();
  while (!n.isNull()) {
    QDomElement e = n.toElement(); // try to convert the node to an element.
    if( !e.isNull()) { // the node was really an element.
      if (e.tagName() == "tag") {
        in_tag = e.text();
        setCaption(in_tag);
        setTabCaption(in_tag);
      } else if (e.tagName() == "restore") {
        rectRestore.setX( e.attribute( "x", "0" ).toInt() );
        rectRestore.setY( e.attribute( "y", "0" ).toInt() );
        rectRestore.setWidth( e.attribute( "w", "100" ).toInt() );
        rectRestore.setHeight( e.attribute( "h", "100" ).toInt() );
        setRestoreGeometry( rectRestore );
      } else if (e.tagName() == "internal") {
        rectInternal.setX( e.attribute( "x", "0" ).toInt() );
        rectInternal.setY( e.attribute( "y", "0" ).toInt() );
        rectInternal.setWidth( e.attribute( "w", "100" ).toInt() );
        rectInternal.setHeight( e.attribute( "h", "100" ).toInt() );
        setInternalGeometry( rectInternal );
      } else if (e.tagName() == "minimize") {
        minimize(false);
      } else if (e.tagName() == "maximize") {
        maximize(false);
      }
    }
    n = n.nextSibling();
  }
}


void KstViewWindow::commonConstructor() {
  config = kapp->config();

  connect(this, SIGNAL(focusInEventOccurs( KMdiChildView*)), this, SLOT(slotActivated(KMdiChildView*)));

  QTimer::singleShot(0, this, SLOT(updateActions()));

  QVBoxLayout *vb = new QVBoxLayout(this);
  vb->setAutoAdd(true);
}

void KstViewWindow::updateActions() {
}


KstViewWindow::~KstViewWindow() {
  _view->release();
  KstApp *app = KstApp::inst(); // Can be null on exit - but then why do
                                // we even need to be calling this function
                                // here?  It seems wrong to me.
  if (app) {
    app->updateDialogsForWindow();
  }
}


void KstViewWindow::saveProperties(KConfig *config) {
  Q_UNUSED(config)
}


void KstViewWindow::readProperties(KConfig* config) {
  Q_UNUSED(config)
}


void KstViewWindow::slotActivated(KMdiChildView*) {
  if (KstApp::inst()->getZoomRadio() == KstApp::LAYOUT) {
    if( view()->viewMode() == KstTopLevelView::DisplayMode ) {
      view()->setViewMode( KstTopLevelView::LayoutMode );
    }
  } else {
    if( view()->viewMode() == KstTopLevelView::LayoutMode ) {
      view()->setViewMode( KstTopLevelView::DisplayMode );
    }
  }
}


void KstViewWindow::slotFileClose() {
}


void KstViewWindow::slotFilePrint() {
  KPrinter printer;
  printer.setPageSize(KPrinter::Letter);
  printer.setOrientation(KPrinter::Landscape);
  printer.setFromTo(0, 0);
  printer.setMinMax(1, 1);

  if (printer.setup(this, i18n("Print"))) {
    QPainter paint(&printer);
    QPaintDeviceMetrics metrics(&printer);
    QSize size(metrics.width(), metrics.height());

    KstApp::inst()->slotUpdateStatusMsg(i18n("Printing..."));

    view()->resizeForPrint(size);
    view()->paint(P_PRINT, paint);
    view()->revertForPrint();

    KstApp::inst()->slotUpdateStatusMsg(i18n("Ready"));
  }
}


void KstViewWindow::immediatePrintToFile(const QString &filename) {
  KPrinter printer;
  printer.setPageSize(KPrinter::Letter);
  printer.setOrientation(KPrinter::Landscape);
  printer.setOutputToFile(true);
  printer.setOutputFileName(filename);

  QPainter paint(&printer);
  QPaintDeviceMetrics metrics(&printer);
  QSize size(metrics.width(), metrics.height());

  view()->resizeForPrint(size);
  view()->paint(P_PRINT, paint);
  view()->revertForPrint();
}


void KstViewWindow::immediatePrintToPng(QDataStream* dataStream, const QSize& size, const QString &format) {
  Q_UNUSED(format)

  QPixmap pixmap(size);
  QSize sizeOld;

  if (!view()->children().isEmpty()) {
    QPainter paint;

    if (paint.begin(&pixmap)) {
      sizeOld = view()->size();
      view()->resizeForPrint(size);
      view()->paint(P_EXPORT, paint);
      (*dataStream) << pixmap;
      view()->revertForPrint();
      paint.end();
    }
  }
}


void KstViewWindow::immediatePrintToPng(const QString &filename, const QSize& size, const QString &format) {
  if (!view()->children().isEmpty()) {
    QPainter paint;
    QPixmap pixmap(size);

    if (paint.begin(&pixmap)) {
      QString dotFormat = QString(".") + format;
      int iPos = filename.findRev(dotFormat, -1, FALSE);
      QString filenameNew;
      if (iPos != -1 && iPos == (int)(filename.length() - dotFormat.length())) {
        filenameNew = filename;
      } else {
        filenameNew = filename + "." + format.lower();
      }

      view()->resizeForPrint(size);
      view()->paint(P_EXPORT, paint);
      if (!pixmap.save(filenameNew, format.latin1())) {
        KstDebug::self()->log(i18n("Failed to save image to %1").arg(filename), KstDebug::Warning);
      }
      view()->revertForPrint();
      paint.end();
    }
  }
}


void KstViewWindow::save(QTextStream& ts) {
  QRect restoreGeom = restoreGeometry();
  QRect internalGeom = internalGeometry();

  ts << "  <tag>" << caption() << "</tag>" << endl;

  ts << "  <restore"  << " x=\"" << restoreGeom.x()
                    << "\" y=\"" << restoreGeom.y()
                    << "\" w=\"" << restoreGeom.width()
                    << "\" h=\"" << restoreGeom.height() << "\" />" << endl;

  ts << "  <internal" << " x=\"" << internalGeom.x()
                    << "\" y=\"" << internalGeom.y()
                    << "\" w=\"" << internalGeom.width()
                    << "\" h=\"" << internalGeom.height() << "\" />" << endl;

  if (isMinimized()) {
    ts << "  <minimized/>" << endl;
  }
  if (isMaximized()) {
    ts << "  <maximized/>" << endl;
  }

  view()->save(ts);
}


KstTopLevelViewPtr KstViewWindow::view() const {
  return _view;
}

#include "kstviewwindow.moc"
// vim: ts=2 sw=2 et
