/*
 *  Linear weighted fitting plugin for KST.
 *  Copyright 2004, The University of British Columbia
 *  Released under the terms of the GPL.
 */

#include <stdlib.h>
#include <math.h>
#include <gsl/gsl_fit.h>
#include "../common.h"

extern "C" int kstfit_linear_weighted(const double *const inArrays[], const int inArrayLens[],
		const double inScalars[],
		double *outArrays[], int outArrayLens[],
		double outScalars[]);

int kstfit_linear_weighted(const double *const inArrays[], const int inArrayLens[],
		const double inScalars[],
		double *outArrays[], int outArrayLens[],
		double outScalars[])
{
  int i = 0;
  int	iLength;
  int iReturn = -1;
  double c0 = 0.0;
  double c1 = 0.0;
  double cov00 = 0.0;
  double cov01 = 0.0;
  double cov11 = 0.0;
  double dSumSq = 0.0;
  double y;
  double yErr;

  if( precursor( inArrayLens, outArrays, outArrayLens, &iLength, false, true, 1 ) ) {
    if( !gsl_fit_wlinear( inArrays[XVALUES], 1, inArrays[WEIGHTS], 1, inArrays[YVALUES], 1, iLength, &c0, &c1, &cov00, &cov01, &cov11, &dSumSq ) ) {
        
      for( i=0; i<iLength; i++ ) {
        gsl_fit_linear_est( inArrays[XVALUES][i], c0, c1, cov00, cov01, cov11, &y, &yErr );
        outArrays[YFIT][i] = y;
        outArrays[YRESIDUALS][i] = inArrays[YVALUES][i] - y;
        outArrays[Y_LOW_VALS][i] = y - yErr;
        outArrays[Y_HGH_VALS][i] = y + yErr;
      }

      outArrays[PARAMETERS][0] = c0;
      outArrays[PARAMETERS][1] = c1;
      outArrays[COVARIANCE][0] = cov00;
      outArrays[COVARIANCE][1] = cov01;
      outArrays[COVARIANCE][2] = cov11;

      outScalars[CHI2NU]  = dSumSq / ( (double)iLength - 2.0 );
        
      iReturn = 0;
    } 
  }
  
  return iReturn;
}
