/***************************************************************************
                          common.h  -  description
                             -------------------
    begin                : Mon Apr 26 2004
    copyright            : (C) 2004 The University of British Columbia
  ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define XVALUES			0
#define YVALUES			1
#define WEIGHTS	    2

#define	YFIT				0
#define YRESIDUALS	1
#define PARAMETERS	2
#define COVARIANCE	3
#define Y_LOW_VALS  4
#define Y_HGH_VALS  5
#define MAX_OUT     6

#define CHI2NU      0

void assign( double* outArrays[], int outArrayLens[], double* pResult[], int iIndex, int iLength ) {
  outArrays[iIndex]    = pResult[iIndex];
  outArrayLens[iIndex] = iLength;
}

void alloc( double* outArrays[], int outArrayLens[], double* pResult[], int iIndex, int iLength ) {
  if( outArrayLens[iIndex] != iLength ) {
    pResult[iIndex] = (double*)realloc( outArrays[iIndex], iLength * sizeof( double ) );
  } else {
    pResult[iIndex] = outArrays[iIndex];
  }
}

bool precursor( const int inArrayLens[],
                double* outArrays[],
                int outArrayLens[],
                int*    piLength,
                bool    bWeighted,
                bool    bLowHigh,
                int     iNumParams ) {
  double* pResult[MAX_OUT];
  bool bRetVal = false;
  int  iNumCovar = ( iNumParams * ( iNumParams + 1 ) ) / 2;
  
  *piLength = inArrayLens[XVALUES];
  if( inArrayLens[YVALUES] < *piLength ) {
    *piLength = inArrayLens[YVALUES];
  }
  if( bWeighted && inArrayLens[WEIGHTS] < *piLength ) {
    *piLength = inArrayLens[WEIGHTS];
  }
  
  if( *piLength > iNumParams + 1 ) {
    alloc( outArrays, outArrayLens, pResult, YFIT, *piLength );
    alloc( outArrays, outArrayLens, pResult, YRESIDUALS, *piLength );
    alloc( outArrays, outArrayLens, pResult, PARAMETERS, iNumParams );
    alloc( outArrays, outArrayLens, pResult, COVARIANCE, iNumCovar );
    if( bLowHigh ) {
      alloc( outArrays, outArrayLens, pResult, Y_LOW_VALS, *piLength );
      alloc( outArrays, outArrayLens, pResult, Y_HGH_VALS, *piLength );
    }

    if( pResult[YFIT] != NULL &&
        pResult[YRESIDUALS] != NULL &&
        pResult[PARAMETERS] != NULL &&
        pResult[COVARIANCE] != NULL &&
        ( !bLowHigh || pResult[Y_LOW_VALS] != NULL ) &&
        ( !bLowHigh || pResult[Y_HGH_VALS] != NULL ) )
    {
      assign( outArrays, outArrayLens, pResult, YFIT, *piLength );
      assign( outArrays, outArrayLens, pResult, YRESIDUALS, *piLength );
      assign( outArrays, outArrayLens, pResult, PARAMETERS, iNumParams );
      assign( outArrays, outArrayLens, pResult, COVARIANCE, iNumCovar );
      if( bLowHigh ) {
        assign( outArrays, outArrayLens, pResult, Y_LOW_VALS, *piLength );
        assign( outArrays, outArrayLens, pResult, Y_HGH_VALS, *piLength );
      }

      bRetVal = true;
    }
  }

  return bRetVal;
}
