/***************************************************************************
                    kstviewfitsdialog_i.cpp  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2004 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qtable.h>
#include <qtimer.h>
#include <qwidget.h>

#include <kdebug.h>
#include <klocale.h>

#include "vectorselector.h"
#include "kstfitcurve.h"
#include "kstfittable.h"
#include "kstrvector.h"
#include "kstdatacollection.h"
#include "kstviewfitsdialog_i.h"

KstViewFitsDialogI::KstViewFitsDialogI(QWidget* parent,
                                             const char* name,
                                             bool modal,
                                             WFlags fl) :
KstViewFitsDialog(parent, name, modal, fl) {
  
  tableFits = new KstFitTable( this, "tableFits" );
  tableFits->setNumRows( 0 );
  tableFits->setNumCols( 1 );
  tableFits->setReadOnly( TRUE );
  tableFits->setSorting( FALSE );
  tableFits->setSelectionMode( QTable::Single );
  layout2->addWidget( tableFits, 1, 0 );
    
  connect( Cancel, SIGNAL( clicked() ), this, SLOT( close() ) );
  connect( _comboBoxFits, SIGNAL( activated(const QString&) ), this, SLOT( fitChanged(const QString&) ) );
    
  tableFits->setReadOnly( true );
}

KstViewFitsDialogI::~KstViewFitsDialogI() {
}

void KstViewFitsDialogI::fillComboBox( const QString& str ) {
  KstFitCurveList fits;
  QString fitName = str;
  unsigned int i;

  _comboBoxFits->clear();
  fits = kstObjectSubList<KstDataObject,KstFitCurve>(KST::dataObjectList);
  for (i = 0; i < fits.count(); i++) {
    _comboBoxFits->insertItem( fits[i]->tagName() );
    if (fitName == fits[i]->tagName() || fitName.isEmpty()) {
      _comboBoxFits->setCurrentItem( _comboBoxFits->count()-1 );
      fitChanged( fitName );
      if (fitName.isEmpty()) {
        fitName = fits[i]->tagName();
      }
    }
  }
}

void KstViewFitsDialogI::updateViewFitsDialog() {
  if (_comboBoxFits->listBox()->isVisible()) {
    QTimer::singleShot(250, this, SLOT(updateViewFitsDialog()));
  } else {
    QString old;
    if (_comboBoxFits->count() > 0) {
      int iIndex = _comboBoxFits->currentItem();
      old = _comboBoxFits->text( iIndex );
    }
    fillComboBox( old );
  }
}

void KstViewFitsDialogI::showViewFitsDialog(const QString& strFit) {
  fillComboBox( strFit );
}

void KstViewFitsDialogI::showViewFitsDialog() {
  updateViewFitsDialog();
  updateDefaults(0);
  
  show();
  raise();
}

void KstViewFitsDialogI::fitChanged(const QString& strFit) {
  KstFitCurveList fits;
  KstFitCurvePtr fit;
  KstPluginPtr plugin;
  double* pParams = NULL;
  double* pCovars = NULL;
  int iNumParams = 0;
  int iNumCovars = 0;
  int i;

  fits = kstObjectSubList<KstDataObject,KstFitCurve>(KST::dataObjectList);
  fit = *(fits.findTag(strFit));
  if( fit ) {
    plugin = fit->getPlugin();
    if (plugin) {
      KstVectorMap vectors;
      KstVectorPtr vectorParam;
      KstVectorPtr vectorCovar;

      vectors = plugin->outputVectors( );
      vectorParam = vectors["Parameters"];
      if (vectorParam) {
        vectorCovar = vectors["Covariance"];
        if (vectorCovar) {
          iNumParams = vectorParam->length( );
          iNumCovars = vectorCovar->length( );

          if( iNumParams > 0 && iNumCovars > 0 ) {
            pParams = new double[iNumParams];
            pCovars = new double[iNumCovars];

            if( pParams != NULL ) {
              for( i=0; i<iNumParams; i++ ) {
                pParams[i] = vectorParam->value( i );   
              }
            }

            if( pCovars != NULL ) {
              for( i=0; i<iNumCovars; i++ ) {
                pCovars[i] = vectorCovar->value( i );
              }
            }
          }
        }
      }
    }
  }

  tableFits->setParameters( pParams, iNumParams, pCovars, iNumCovars );

  if( iNumParams > 0 ) {
    tableFits->horizontalHeader()->setLabel( 0, i18n("Parameters") );
    tableFits->horizontalHeader()->setLabel( 1, i18n("") );
    tableFits->horizontalHeader()->setLabel( 2, i18n("Covariance") );
    for( i=3; i<iNumParams+2; i++ ) {
      tableFits->horizontalHeader()->setLabel( i, i18n("") );
    }
  }
  
  tableFits->update();
}

void KstViewFitsDialogI::updateDefaults(int index) {
  Q_UNUSED( index )
}

#include "kstviewfitsdialog_i.moc"
// vim: ts=2 sw=2 et
