/***************************************************************************
                    ksteventmonitor_i.cpp  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2004 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qstring.h>
#include <qtable.h>
#include <qwidget.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qtimer.h>
#include <qmessagebox.h>

// include files for KDE
#include <kdebug.h>
#include <klocale.h>
#include <kstaticdeleter.h>
#include <kmessagebox.h>

// application specific includes
#include "vectorselector.h"
#include "scalarselector.h"
#include "kstrvector.h"
#include "kstdatacollection.h"
#include "ksteventmonitor_i.h"
#include "kstdebug.h"
#include "ksteventmonitorentry.h"
#include "kstdoc.h"
#include "kst.h"

#define DIALOGTYPE KstEventMonitorI
#define DTYPE "Event Monitor"
#include "dataobjectdialog.h"

KstEventMonitorI* KstEventMonitorI::_inst = 0L;
static KStaticDeleter<KstEventMonitorI> _eventInst;

KstEventMonitorI* KstEventMonitorI::globalInstance() {
  if (!_inst) {
    _inst = _eventInst.setObject(new KstEventMonitorI);
  }

  return _inst;
}

KstEventMonitorI::KstEventMonitorI(QWidget* parent,
                                   const char* name, bool modal, WFlags fl)
  : EventMonitor(parent, name, modal, fl) {
  Init();

  connect(_vectorSelectorEq, SIGNAL(newVectorCreated(const QString&)),
          this, SIGNAL(modified()));
  connect(_scalarSelectorEq, SIGNAL(newScalarCreated()),
          this, SIGNAL(modified()));
  connect(_vectorSelectorEq, SIGNAL(selectionChangedLabel(const QString&)),
          lineEditEquation, SLOT(insert(const QString&)));
  connect(_scalarSelectorEq, SIGNAL(selectionChangedLabel(const QString&)),
          lineEditEquation, SLOT(insert(const QString&)));
  connect(_scalarSelectorEq, SIGNAL(selectionChangedLabel(const QString&)),
          lineEditEquation, SLOT(insert(const QString&)));
  connect(_pushButtonELOGConfigure, SIGNAL(clicked()),
          KstApp::inst(), SLOT(EventELOGConfigure()));
}

KstEventMonitorI::~KstEventMonitorI() {
  DP = 0L;
}

EventMonitorEntryPtr KstEventMonitorI::_getPtr(const QString &tagin) {
  KstEventMonitorEntryList c =
    kstObjectSubList<KstDataObject, EventMonitorEntry>(KST::dataObjectList);

  if ( c.findTag(tagin) == c.end() ) {
    return 0L;
  } else {
    return *c.findTag(tagin);
  }
}

void KstEventMonitorI::_fillFieldsForEdit() {
  if ( DP == 0L ) return; // shouldn't be needed
  _tagName->setText( DP->tagName() );

  lineEditEquation->setText( DP->getEvent( ) );
  lineEditDescription->setText( DP->getDescription( ) );
  checkBoxDebug->setChecked( DP->getLogKstDebug( ) );
  checkBoxEMailNotify->setChecked( DP->getLogEMail( ) );
  checkBoxELOGNotify->setChecked( DP->getLogELOG( ) );
  lineEditEMailRecipients->setText( DP->getEMailRecipients( ) );
  lineEditEMailSender->setText( DP->getEMailSender( ) );
  lineEditSMTPServer->setText( DP->getSMTPServer( ) );

  switch( DP->getLevel( ) ) {
      case KstDebug::Notice:
        radioButtonLogNotice->setChecked(true);
        break;
      case KstDebug::Warning:
        radioButtonLogWarning->setChecked(true);
        break;
      case KstDebug::Error:
        radioButtonLogError->setChecked(true);
        break;
      default:
        radioButtonLogWarning->setChecked(true);
        break;
  }

}

void KstEventMonitorI::_fillFieldsForNew() {
  KstEventMonitorEntryList events =
    kstObjectSubList<KstDataObject, EventMonitorEntry>(KST::dataObjectList);

  QString new_label;

  new_label = QString("E%1-").arg(events.count()+1) + i18n("<New_Event>");
  _tagName->setText(new_label);

  radioButtonLogWarning->setChecked(true);
  lineEditEquation->setText( "" );
  lineEditDescription->setText( "" );
  checkBoxDebug->setChecked( true );
  checkBoxEMailNotify->setChecked( false );
  checkBoxELOGNotify->setChecked( false );
  lineEditEMailRecipients->setText( "" );

}

void KstEventMonitorI::update() {
  _vectorSelectorEq->update();
  _scalarSelectorEq->update();
}

void KstEventMonitorI::fillEvent(EventMonitorEntryPtr& event) {
  event->setEvent( lineEditEquation->text() );
  event->setDescription( lineEditDescription->text() );
  event->setLogKstDebug( checkBoxDebug->isChecked() );
  event->setLogEMail( checkBoxEMailNotify->isChecked() );
  event->setLogELOG( checkBoxELOGNotify->isChecked() );
  event->setEMailRecipients( lineEditEMailRecipients->text() );
  event->setEMailSender( lineEditEMailSender->text() );
  event->setSMTPServer( lineEditSMTPServer->text() );

  if ( radioButtonLogNotice->isChecked()) {
    event->setLevel( KstDebug::Notice );
  } else if (radioButtonLogWarning->isChecked()) {
    event->setLevel( KstDebug::Warning );
  } else if (radioButtonLogError->isChecked()) {
    event->setLevel( KstDebug::Error );
  }

  event->update();
}

bool KstEventMonitorI::new_I() {
  EventMonitorEntryPtr event;
  QString tag_name = _tagName->text();
  tag_name.replace(i18n("<New_Event>"), lineEditEquation->text());

  /* verify that the event name is unique */
  if (KST::dataTagNameNotUnique(tag_name)) {
    _tagName->setFocus();
    return false;
  }

  event = new EventMonitorEntry(tag_name);
  if (event) {
    fillEvent( event );

    if (!event->isValid()) {
      event = 0L;

      KMessageBox::sorry(0L, i18n("There is a syntax error in the equation "
                                  "you entered.  Please fix it."));
      return false;
    }
  } else {
    return false; // shouldn't ever happen
  }

  KST::dataObjectList.lock().writeLock();
  KST::dataObjectList.append(event.data());
  KST::dataObjectList.lock().writeUnlock();

  event = 0L; // drop the reference before we update
  emit modified();
  return true;
}

bool KstEventMonitorI::edit_I() {
  QString tag_name;


  /* verify that the tag name is unique */
  tag_name = _tagName->text();
  if (tag_name != DP->tagName()) {
    if (KST::dataTagNameNotUnique(tag_name)) {
      _tagName->setFocus();
      return false;
    }
  }
  DP->setTagName(_tagName->text());

  fillEvent(DP);
  DP->update();

  emit modified();

  return true;
}

#include "ksteventmonitor_i.moc"
// vim: ts=2 sw=2 et
