/***************************************************************************
                          kstview.cpp  -  description
                             -------------------
    begin                : Tue Aug 22 13:46:13 CST 2000
    copyright            : (C) 2000 by Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <math.h>

// include files for Qt
#include <kimageio.h>
#include <kprinter.h>
#include <qpainter.h>
#include <qevent.h>
#include <qbitmap.h>
#include <qbrush.h>
#include <qtabwidget.h>

#include <kurl.h>
#include <ktempfile.h>
#include <kio/netaccess.h>
#include <klocale.h>

// application specific includes
#include "kstview.h"
#include "kstdoc.h"
#include "kstplotlist.h"
#include "kst.h"
#include "kstplotdialog_i.h"
#include "kstmouse.h"
#include "kstlabeldialog_i.h"

#include <iostream>

/** setup the view widget */
KstView::KstView(KstApp *parent, const char *name) :
  QWidget(parent, name) {

  MouseInfo = new KstMouse(this);
  labelDialog = new KstLabelDialogI(parent, "Edit Label");

  first_time = true;
  _minMove = 3;

  ZoomCurrentPlot = false;
  ZoomPlotNum = 0;

  ParentApp = parent;
  needrecreate=true;
  qpixmap=0;
  setBackgroundMode(NoBackground);
  setMouseTracking(true);

  /* initialize the popup menu */
  popupmenu = new KPopupMenu(this);
  popupmenu->insertItem(i18n("Zoom &Max"), this, SLOT(zoomMaxSlot()), Key_M);
  popupmenu->insertItem(i18n("Zoom P&rev"), this, SLOT(zoomPrevSlot()), Key_R);
  popupmenu->insertItem(i18n("Y-Zoom AC Coupled"), this, SLOT(yzoomAcSlot()), Key_A);
  popupmenu->insertSeparator();
  popupmenu->insertItem(i18n("X-Zoom Max"),
                        this, SLOT(xzoomMaxSlot()), CTRL + Key_M);
  popupmenu->insertItem(i18n("X-Zoom Out"),
                        this, SLOT(xzoomOutSlot()), SHIFT + Key_Right);
  popupmenu->insertItem(i18n("X-Zoom In"),
                        this, SLOT(xzoomInSlot()), SHIFT + Key_Left);
  popupmenu->insertItem(i18n("Toggle Log X Axis"),
                        this, SLOT(xLogSlot()), Key_G);
  popupmenu->insertSeparator();
  popupmenu->insertItem(i18n("Y-Zoom Max"),
                        this, SLOT(yzoomMaxSlot()), SHIFT + Key_M);
  popupmenu->insertItem(i18n("Y-Zoom Out"),
                        this, SLOT(yzoomOutSlot()), SHIFT + Key_Up);
  popupmenu->insertItem(i18n("Y-Zoom In"),
                        this, SLOT(yzoomInSlot()), SHIFT + Key_Down);
  popupmenu->insertItem(i18n("Toggle Log Y Axis"),
                        this, SLOT(yLogSlot()), Key_L);
  popupmenu->insertSeparator();
  popupmenu->insertItem(i18n("Scroll Left"), this, SLOT(leftSlot()), Key_Left);
  popupmenu->insertItem(i18n("Scroll Right"), this, SLOT(rightSlot()), Key_Right);
  popupmenu->insertItem(i18n("Scroll Up"), this, SLOT(upSlot()), Key_Up);
  popupmenu->insertItem(i18n("Scroll Down"), this, SLOT(downSlot()), Key_Down);

  popupmenu->insertSeparator();
  popupmenu->insertItem(i18n("Toggle &Pause"), this, SLOT(pauseSlot()), Key_P);
  popupmenu->insertItem(i18n("Toggle &Zoom Current Plot"),
                        this, SLOT(zoomPlotSlot()), Key_Z);

  popupmenu->insertSeparator();
  popupmenu->insertItem(i18n("&Edit Plots"), parent,
                        SLOT(showPlotDialog()), Key_E);
  popupmenu->insertItem(i18n("&Data Manager"), parent,
                        SLOT(showDataManager()), Key_D);


  setFocusPolicy(QWidget::StrongFocus);
  setFocus();
}

KstView::~KstView() {
  delete qpixmap;
  qpixmap = 0L;
  delete MouseInfo;
  MouseInfo = 0L;
}

void KstView::printToGraphicsFile(const QString &filename, int in_w, int in_h) {
  float w, h, tlx, tly;
  QRect v;
  KstPlot *pl = 0L;
  double XBorder, maxXBorder = 0;

  QPixmap tmpPixmap(in_w, in_h);
  tmpPixmap.fill();

  QPainter p(&tmpPixmap);

  v = p.viewport();

  // Find max border width
  for (unsigned i = 0; i < KST::plotList.count(); i++) {
    pl = KST::plotList.at(i);
    w = v.width() * pl->width();
    h = v.height() * pl->height();
    tly = v.height() * pl->topLeftY();
    tlx = v.width() * pl->topLeftX();
    p.setViewport((int)tlx, (int)tly, (int)w, (int)h);
    p.setWindow((int)0, (int)0, (int)w, (int)h);
    XBorder = pl->getXBorder(p);
    if (XBorder>maxXBorder) maxXBorder = XBorder;
  }

  for (unsigned i = 0; i < KST::plotList.count(); i++) {
    pl = KST::plotList.at(i);
    w = v.width() * pl->width();
    h = v.height() * pl->height();
    tly = v.height() * pl->topLeftY();
    tlx = v.width() * pl->topLeftX();
    p.setViewport((int)tlx, (int)tly, (int)w, (int)h);
    p.setWindow((int)0, (int)0, (int)w, (int)h);
    pl->paint(p, maxXBorder);
  }

  QString type = KImageIO::type(filename);
  if (type.isEmpty()) {
    type = "PNG";
  }

  KURL url = KURL::fromPathOrURL(filename);
  if (url.isLocalFile()) {
    tmpPixmap.save(url.path(), type.latin1());
  } else {
    KTempFile tf;
    tf.close();
    tf.setAutoDelete(true);
    tmpPixmap.save(tf.name(), type.latin1());
#if KDE_IS_VERSION(3,1,90)
    KIO::NetAccess::upload(tf.name(), url, this);
#else
    KIO::NetAccess::upload(tf.name(), url);
#endif
  }
}

void KstView::print(KPrinter *printer)
{
  int i;
  float w, h, tlx, tly;
  QRect v;
  KstPlot *pl;
  double XBorder, maxXBorder = 0;

  QPainter p(printer);

  v = p.viewport();

  // Find max border width
  for (i=0; i < (int)KST::plotList.count(); i++) {
    pl = KST::plotList.at(i);
    w = v.width() * pl->width();
    h = v.height() * pl->height();
    tly = v.height() * pl->topLeftY();
    tlx = v.width() * pl->topLeftX();
    p.setViewport((int)tlx, (int)tly, (int)w, (int)h);
    w = 3000.0/h * w;
    h = 3000.0;
    p.setWindow((int)0, (int)0, (int)w, (int)h);
    XBorder = pl->getXBorder(p);
    if (XBorder>maxXBorder) maxXBorder = XBorder;
  }

  for (i=0; i < (int)KST::plotList.count(); i++) {
    pl = KST::plotList.at(i);
    w = v.width() * pl->width();
    h = v.height() * pl->height();
    tly = v.height() * pl->topLeftY();
    tlx = v.width() * pl->topLeftX();
    p.setViewport((int)tlx, (int)tly, (int)w, (int)h);
    w = 3000.0/h * w;
    h = 3000.0;
    p.setWindow((int)0, (int)0, (int)w, (int)h);
    pl->paint(p, maxXBorder);
  }
}

void KstView::paintEvent(QPaintEvent *) {
  unsigned int i;
  QPixmap *tmpPixmap = 0L;
  KstPlot *pl;
  QPainter *p = 0L;
  float w, h, tlx, tly;
  double XBorder, maxXBorder = 0;
  unsigned int i0, i1;
  int n_plots;

  if (qpixmap == 0L) {
    qpixmap = new QPixmap(width(), height());
    qpixmap->setOptimization(QPixmap::MemoryOptim);
    qpixmap->fill();
    erase();
    return;
  }

  n_plots = KST::plotList.count();

  if (n_plots == 0) {
    i0 = 0;
    i1 = 0;
  } else if (ZoomCurrentPlot) {
    i0 = ZoomPlotNum;
    i1 = i0+1;
  } else {
    i0 = 0;
    i1 = n_plots;
  }

  if (needrecreate) {
    qpixmap->resize(width(), height());
    qpixmap->fill();

    // Find max border width
    for (i=i0; i < i1; i++) {
      /* Draw each plot to its own pixmap */
      pl = KST::plotList.at(i);
      if (ZoomCurrentPlot) {
        w = width();
        h = height();
        tly = 0;
        tlx = 0;
      } else {
        w = width() * pl->width();
        h = height() * pl->height();
        tly = height() * pl->topLeftY();
        tlx = width() * pl->topLeftX();
      }
      if (i0==i1) { // only one plot - draw directly onto qpixmap
        tmpPixmap = qpixmap;
        p = new QPainter(tmpPixmap);
      } else if (i==i0) {
        tmpPixmap = new QPixmap(int(w),int(h));
        tmpPixmap->setOptimization(QPixmap::MemoryOptim);
        p = new QPainter(tmpPixmap);
      } else if ((tmpPixmap->width() != w) || (tmpPixmap->height() != h)) {
        delete p;
        tmpPixmap->resize(int(w),int(h));
        p = new QPainter(tmpPixmap);
      }

      XBorder = pl->getXBorder(*p);
      if (XBorder>maxXBorder) maxXBorder = XBorder;
    }

    for (i=i0; i < i1; i++) {
      /* Draw each plot to its own pixmap */
      pl = KST::plotList.at(i);
      if (ZoomCurrentPlot) {
        w = width();
        h = height();
        tly = 0;
        tlx = 0;
      } else {
        w = width() * pl->width();
        h = height() * pl->height();
        tly = height() * pl->topLeftY();
        tlx = width() * pl->topLeftX();
      }
      if ((tmpPixmap->width() != w) || (tmpPixmap->height() != h)) {
        delete p;
        tmpPixmap->resize((int)w,(int)h);
        p = new QPainter(tmpPixmap);
      }
      pl->paint(*p, maxXBorder);
      /* copy the tmppix map to the qpixmap */
      if (i0!=i1) {
        bitBlt(qpixmap, (int)tlx, (int)tly, tmpPixmap,0,0,-1,-1,
               QWidget::CopyROP, true);
      }
      pl->setpixrect((int)tlx, (int)tly);
    }
    delete p;
    if (tmpPixmap!=qpixmap)
      delete tmpPixmap;
  }

  bitBlt(this,0,0,qpixmap,0,0,-1,-1,
         QWidget::CopyROP, true);
  updateTieBoxes(this);

  needrecreate = false;

  // Redraw the mouse box if needed
  if (MouseInfo->getMode()!=INACTIVE) {
    QPainter p(this);
    if (!MouseInfo->isFirstMove()) MouseInfo->DrawBox(p);
  }
}

void KstView::resizeEvent(QResizeEvent *) {
  needrecreate=true;
}


void KstView::update() {
  needrecreate=true;
  paintEvent(NULL);

}

void KstView::mouseMoveEvent(QMouseEvent *e) {
  int x,y;
  int i;
  QString msg;
  QRect plot_rect;
  double xmin, xmax, ymin, ymax, xpos, ypos;
  bool in_plot = false;
  int plot_num;

  plot_num = MouseInfo->getPlotNum();

  if (MouseInfo->getMode() == XY_ZOOMBOX) {
    QRect pr = (KST::plotList.at(plot_num))->
               GetPlotRegion();

    if (e->x() > pr.right()) x = pr.right()+1;
    else if (e->x() < pr.left()) x = pr.left();
    else x = e->x();

    if (e->y() > pr.bottom()) y = pr.bottom()+1;
    else if (e->y() < pr.top()) y = pr.top();
    else y = e->y();

    MouseInfo->setLastLocation(QPoint(x,y));
  } else if (MouseInfo->getMode() == Y_ZOOMBOX) {
    QRect pr = (KST::plotList.at(plot_num))->
               GetPlotRegion();

    x = pr.right();

    if (e->y() > pr.bottom()) y = pr.bottom()+1;
    else if (e->y() < pr.top()) y = pr.top();
    else y = e->y();

    MouseInfo->setLastLocation(QPoint(x,y));
  } else if (MouseInfo->getMode() == X_ZOOMBOX) {
    QRect pr = (KST::plotList.at(plot_num))->
               GetPlotRegion();

    if (e->x() > pr.right()) x = pr.right()+1;
    else if (e->x() < pr.left()) x = pr.left();
    else x = e->x();

    y = pr.bottom();

    MouseInfo->setLastLocation(QPoint(x,y));
  }

  // change the xy field
  //emit newDataMsg(msg);

  msg = "";

  for (i=0; i < (int)KST::plotList.count(); i++) {
    plot_rect = (KST::plotList.at(i))->GetPlotRegion();
    if (plot_rect.contains(e->pos())) {
      (KST::plotList.at(i))->getLScale(xmin, ymin, xmax, ymax);
      xpos = (double)(e->x() - plot_rect.left())/(double)plot_rect.width();
      xpos = xpos * (xmax - xmin) + xmin;
      ypos = (double)(e->y() - plot_rect.top())/(double)plot_rect.height();
      ypos = ypos * (ymin-ymax) + ymax;
      if (KST::plotList.at(i)->isXLog()) {
        xpos = pow(10.0, xpos);
      }
      if (KST::plotList.at(i)->isYLog()) {
        ypos = pow(10.0, ypos);
      }
      msg = i18n("(%1, %2)").arg(xpos,0,'G').arg(ypos,0,'G');
      if (MouseInfo->getMode() == INACTIVE) {
        if (i!=plot_num) {
          MouseInfo->setPlotNum(i);
          updateTieBoxes(this);
        }
      }
      in_plot = true;
    }
  }
  emit newDataMsg(msg);
  MouseInfo->setCursor(in_plot, e);
}

void KstView::mousePressEvent(QMouseEvent *e) {
  unsigned int i;
  QRect win_rect, plot_rect, tie_rect, plot_and_axis_rect;
  KstPlot *plot;

  /* Find where the mouse was to determine which mode to be in */
  /* which button */
  if (e->button() == Qt::LeftButton) {
    /* search through the plots */
    for (i = 0; i < KST::plotList.count(); i++) {
      plot = KST::plotList.at(i);
      win_rect = plot->GetWinRegion();
      plot_rect = plot->GetPlotRegion();
      tie_rect = plot->GetTieBoxRegion();
      plot_and_axis_rect = plot->GetPlotAndAxisRegion();
      if (tie_rect.contains(e->pos())) {
        plot->toggleTied();
        updateTieBoxes(this);
      } else if (plot_rect.contains(e->pos())) {
        MouseInfo->mousePressedInPlot(e, plot_rect);
        MouseInfo->setPlotNum(i);
        return;
      } else if (plot_and_axis_rect.contains(e->pos())) {
        MouseInfo->setPlotNum(i);
        ParentApp->plotDialog->Select->setCurrentItem(i);
        ParentApp->plotDialog->show_I();
        ParentApp->plotDialog->TabWidget->setCurrentPage(LIMITS_TAB);
      } else if (win_rect.contains(e->pos())) {
        MouseInfo->setPlotNum(i);
        ParentApp->plotDialog->Select->setCurrentItem(i);
        ParentApp->plotDialog->show_I();
        ParentApp->plotDialog->TabWidget->setCurrentPage(LABELS_TAB);
      }
    }
  } else if (e->button() == Qt::RightButton) {
    for (i = 0; i < KST::plotList.count(); i++) {
      win_rect = KST::plotList.at(i)->GetPlotRegion();
      if (win_rect.contains(e->pos())) {
        MouseInfo->setMode(INACTIVE);
        MouseInfo->setPressLocation(e->pos());
        MouseInfo->setPlotNum(i);
        popupmenu->popup(mapToGlobal(e->pos()));
        return;
      }
    }
  } else if (e->button() == Qt::MidButton) {
    for (i=0; i < KST::plotList.count(); i++) {
      win_rect = (KST::plotList.at(i))->GetPlotRegion();
      if (win_rect.contains(e->pos())) {
        MouseInfo->setMode(INACTIVE);
        MouseInfo->setPressLocation(e->pos());
        MouseInfo->setPlotNum(i);
        zoomPrevSlot();
        return;
      }
    }
    return;
  } else {
    // cout << "unknown button: " << e->button() << "\n";
  }
}

void KstView::mouseReleaseEvent(QMouseEvent *e) {
  double xmin, xmax, ymin, ymax;
  double new_xmin, new_xmax, new_ymin, new_ymax;
  QRect plotregion;
  unsigned int i_plot;
  KstPlot *plot, *iplot;
  unsigned int count;

  if (KST::plotList.isEmpty()) {
    return;
  }

  i_plot = MouseInfo->getPlotNum();
  plot = KST::plotList.at(i_plot);

  if (MouseInfo->getMode() == XY_ZOOMBOX) {
    /* erase the zoombox: */
    QPainter p(this);
    if (!MouseInfo->isFirstMove()) MouseInfo->DrawBox(p);
    if ((MouseInfo->getMouseRect().width() >_minMove) &&
        (MouseInfo->getMouseRect().height() >_minMove)) {

      plot->getLScale(xmin, ymin, xmax, ymax);
      plotregion = plot->GetPlotRegion();
      new_xmin = (double)(MouseInfo->getMouseRect().left() -
                          plotregion.left())/
                 (double)plotregion.width() * (xmax - xmin) + xmin;
      new_xmax = (double)(MouseInfo->getMouseRect().right() -
                          plotregion.left() + 1)/
                 (double)plotregion.width() * (xmax - xmin) + xmin;
      new_ymin = (double)(MouseInfo->getMouseRect().bottom() -
                          plotregion.top()+1)/
                 (double)plotregion.height() * (ymin - ymax) + ymax;
      new_ymax = (double)(MouseInfo->getMouseRect().top() - plotregion.top())/
                 (double)plotregion.height() * (ymin - ymax) + ymax;


      count = KST::plotList.count();
      for (i_plot = 0; i_plot < count; i_plot++) {
        iplot = KST::plotList.at(i_plot);
        if (plot == iplot || iplot->isTied()) {
          iplot->setXScaleMode(FIXED);
          iplot->setYScaleMode(FIXED);
          iplot->setLScale(new_xmin, new_ymin, new_xmax, new_ymax);
          iplot->pushScale();
        }
      }
    }
  } else if (MouseInfo->getMode() == Y_ZOOMBOX) {
    /* erase the zoombox: */
    QPainter p(this);
    if (!MouseInfo->isFirstMove()) MouseInfo->DrawBox(p);
    if (MouseInfo->getMouseRect().height() >_minMove) {

      plot->getLScale(xmin, ymin, xmax, ymax);
      plotregion = plot->GetPlotRegion();
      new_ymin = (double)(MouseInfo->getMouseRect().bottom() -
                          plotregion.top()+1)/
                 (double)plotregion.height() * (ymin - ymax) + ymax;
      new_ymax = (double)(MouseInfo->getMouseRect().top() - plotregion.top())/
                 (double)plotregion.height() * (ymin - ymax) + ymax;

      count = KST::plotList.count();
      for (i_plot = 0; i_plot < count; i_plot++) {
        iplot = KST::plotList.at(i_plot);
        if (plot == iplot || iplot->isTied()) {
          iplot->setYScaleMode(FIXED);
          iplot->setLYScale(new_ymin, new_ymax);
          iplot->pushScale();
        }
      }
    }
  } else   if (MouseInfo->getMode() == X_ZOOMBOX) {
    /* erase the zoombox: */
    QPainter p(this);
    if (!MouseInfo->isFirstMove()) MouseInfo->DrawBox(p);

    if (MouseInfo->getMouseRect().width() > _minMove) {

      plot->getLScale(xmin, ymin, xmax, ymax);
      plotregion = plot->GetPlotRegion();
      new_xmin = (double)(MouseInfo->getMouseRect().left() - plotregion.left())/
                 (double)plotregion.width() * (xmax - xmin) + xmin;
      new_xmax = (double)(MouseInfo->getMouseRect().right() -
                          plotregion.left() + 1)/
                 (double)plotregion.width() * (xmax - xmin) + xmin;

      count = KST::plotList.count();
      for (i_plot = 0; i_plot < count; i_plot++) {
        iplot = KST::plotList.at(i_plot);
        if (plot == iplot || iplot->isTied()) {
          iplot->setXScaleMode(FIXED);
          iplot->setLXScale(new_xmin, new_xmax);
          iplot->pushScale();
        }
      }
    }
  } else if (MouseInfo->getMode() == LABEL_TOOL) {
    int i_label;
    i_label = MouseInfo->getLabelNum(e);

    plotregion = plot->GetPlotRegion();
    double x = (double)(e->x() - plotregion.left())/
               (double)(plotregion.width());
    double y = (double)(e->y() - plotregion.top())/
               (double)(plotregion.height());
    labelDialog->showI(i_plot, i_label, x, y);
  }

  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();
  mouseMoveEvent(e);
}

void KstView::zoomMaxSlot() {
  unsigned int i_plot, count;
  KstPlot *iplot;

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->setXScaleMode(AUTO);
      iplot->setYScaleMode(AUTO);
      iplot->pushScale();
    }
  }
  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();

}

void KstView::keyPressEvent(QKeyEvent *e) {
  MouseInfo->setCursor(true, e->stateAfter());

  if (e->key() == Qt::Key_Escape) {
    MouseInfo->setMode(INACTIVE);
    update();
  } else {
    e->ignore();
  }
}

void KstView::keyReleaseEvent(QKeyEvent *e) {
  MouseInfo->setCursor(true, e->stateAfter());
}

void KstView::xzoomMaxSlot() {
  unsigned int i_plot, count;
  KstPlot *iplot;

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->setXScaleMode(AUTO);
      iplot->pushScale();
    }
  }
  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();
}

void KstView::yzoomMaxSlot() {
  unsigned int i_plot, count;
  KstPlot *iplot;

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->setYScaleMode(AUTO);
      iplot->pushScale();
    }
  }
  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();
}

void KstView::yzoomAcSlot() {
  unsigned int i_plot, count;
  KstPlot *iplot;

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->setYScaleMode(AC);
      iplot->pushScale();
    }
  }
  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();
}

void KstView::zoomOutSlot() {
  double xmin, xmax, ymin, ymax;
  double new_xmin, new_xmax, new_ymin, new_ymax;
  unsigned int i_plot, count;
  KstPlot *plot, *iplot;

  plot = (KST::plotList.at(MouseInfo->getPlotNum()));
  plot->getLScale(xmin, ymin, xmax, ymax);

  new_xmin = xmin - (xmax - xmin)*0.25;
  new_xmax = xmax + (xmax - xmin)*0.25;
  new_ymin = ymin - (ymax - ymin)*0.25;
  new_ymax = ymax + (ymax - ymin)*0.25;

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->setXScaleMode(FIXED);
      iplot->setYScaleMode(FIXED);
      iplot->setLScale(new_xmin, new_ymin, new_xmax, new_ymax);
      iplot->pushScale();
    }
  }
  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();

}

void KstView::xzoomInSlot() {
  double xmin, xmax, ymin, ymax;
  double new_xmin, new_xmax;
  unsigned int i_plot, count;
  KstPlot *plot, *iplot;

  plot = (KST::plotList.at(MouseInfo->getPlotNum()));
  plot->getLScale(xmin, ymin, xmax, ymax);

  new_xmin = xmin + (xmax - xmin)*0.1666666;
  new_xmax = xmax - (xmax - xmin)*0.1666666;

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->setXScaleMode(FIXED);
      iplot->setLXScale(new_xmin, new_xmax);
      iplot->pushScale();
    }
  }
  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();
}
void KstView::xzoomOutSlot() {
  double xmin, xmax, ymin, ymax;
  double new_xmin, new_xmax;
  unsigned int i_plot, count;
  KstPlot *plot, *iplot;

  plot = (KST::plotList.at(MouseInfo->getPlotNum()));
  plot->getLScale(xmin, ymin, xmax, ymax);

  new_xmin = xmin - (xmax - xmin)*0.25;
  new_xmax = xmax + (xmax - xmin)*0.25;

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->setXScaleMode(FIXED);
      iplot->setLXScale(new_xmin, new_xmax);
      iplot->pushScale();
    }
  }

  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();
}

void KstView::yzoomInSlot() {
  double xmin, xmax, ymin, ymax;
  double new_ymin, new_ymax;
  unsigned int i_plot, count;
  KstPlot *plot, *iplot;

  plot = (KST::plotList.at(MouseInfo->getPlotNum()));
  plot->getLScale(xmin, ymin, xmax, ymax);

  new_ymin = ymin + (ymax - ymin)*0.16666666;
  new_ymax = ymax - (ymax - ymin)*0.16666666;

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->setYScaleMode(FIXED);
      iplot->setLYScale(new_ymin, new_ymax);
      iplot->pushScale();
    }
  }
  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();
}

void KstView::yzoomOutSlot() {
  double xmin, xmax, ymin, ymax;
  double new_ymin, new_ymax;
  unsigned int i_plot, count;
  KstPlot *plot, *iplot;

  plot = (KST::plotList.at(MouseInfo->getPlotNum()));
  plot->getLScale(xmin, ymin, xmax, ymax);

  new_ymin = ymin - (ymax - ymin)*0.25;
  new_ymax = ymax + (ymax - ymin)*0.25;

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->setYScaleMode(FIXED);
      iplot->setLYScale(new_ymin, new_ymax);
      iplot->pushScale();
    }
  }
  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();
}

void KstView::zoomPrevSlot() {
  unsigned int i_plot, count;
  bool popped = false;
  KstPlot *plot;

  /* pop prev zoom on all tied plots */
  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    plot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (plot->isTied())) {
      if (plot->popScale()) {
        popped = true;
      }
    }
  }

  if (popped) {
    needrecreate = true;
    update();
  }

}

void KstView::upSlot() {
  double xmin, xmax, ymin, ymax;
  double new_ymin, new_ymax;
  unsigned int i_plot, count;
  KstPlot *plot, *iplot;

  plot = (KST::plotList.at(MouseInfo->getPlotNum()));
  plot->getLScale(xmin, ymin, xmax, ymax);

  new_ymin = ymin + (ymax - ymin)*0.25;
  new_ymax = ymax + (ymax - ymin)*0.25;

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->getLScale(xmin, ymin, xmax, ymax);
      new_ymin = ymin + (ymax - ymin)*0.25;
      new_ymax = ymax + (ymax - ymin)*0.25;

      iplot->setYScaleMode(FIXED);
      iplot->setLYScale(new_ymin, new_ymax);
      iplot->pushScale();
    }
  }
  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();
}

void KstView::downSlot() {
    double xmin, xmax, ymin, ymax;
  double new_ymin, new_ymax;
  unsigned int i_plot,count;
  KstPlot *plot, *iplot;

  plot = (KST::plotList.at(MouseInfo->getPlotNum()));
  plot->getLScale(xmin, ymin, xmax, ymax);

  new_ymin = ymin - (ymax - ymin)*0.25;
  new_ymax = ymax - (ymax - ymin)*0.25;


  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      if (ParentApp->getMouseZoomRadio() == X_ZOOMBOX) {
        iplot->getLScale(xmin, ymin, xmax, ymax);
        new_ymin = ymin - (ymax - ymin)*0.25;
        new_ymax = ymax - (ymax - ymin)*0.25;
      }

      iplot->setYScaleMode(FIXED);
      iplot->setLYScale(new_ymin, new_ymax);
      iplot->pushScale();
    }
  }

  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();

}

void KstView::rightSlot() {
  double xmin, xmax, ymin, ymax;
  double new_xmin, new_xmax;
  unsigned int i_plot, count;
  KstPlot *plot, *iplot;

  plot = (KST::plotList.at(MouseInfo->getPlotNum()));
  plot->getLScale(xmin, ymin, xmax, ymax);

  new_xmin = xmin + (xmax - xmin)*0.1;
  new_xmax = xmax + (xmax - xmin)*0.1;

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->setXScaleMode(FIXED);
      iplot->setLXScale(new_xmin, new_xmax);
      iplot->pushScale();
    }
  }
  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();
}

void KstView::leftSlot() {
  double xmin, xmax, ymin, ymax;
  double new_xmin, new_xmax;
  unsigned int i_plot, count;
  KstPlot *plot, *iplot;

  plot = (KST::plotList.at(MouseInfo->getPlotNum()));
  plot->getLScale(xmin, ymin, xmax, ymax);

  new_xmin = xmin - (xmax - xmin)*0.1;
  new_xmax = xmax - (xmax - xmin)*0.1;

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->setXScaleMode(FIXED);
      iplot->setLXScale(new_xmin, new_xmax);
      iplot->pushScale();
    }
  }
  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();
}

void KstView::pauseSlot(){
  ParentApp->togglePaused();
}

void KstView::xLogSlot() {
  unsigned int i_plot, count;
  KstPlot *plot, *iplot;
  bool xLog, yLog;

  plot = (KST::plotList.at(MouseInfo->getPlotNum()));
  xLog = !plot->isXLog();
  yLog = plot->isYLog();

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->setLog(xLog, yLog);
    }
  }
  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();
}

void KstView::yLogSlot() {
  unsigned int i_plot, count;
  KstPlot *plot, *iplot;
  bool xLog, yLog;

  plot = (KST::plotList.at(MouseInfo->getPlotNum()));
  xLog = plot->isXLog();
  yLog = !plot->isYLog();

  count = KST::plotList.count();
  for (i_plot=0; i_plot<count; i_plot++) {
    iplot = KST::plotList.at(i_plot);
    if ((i_plot==MouseInfo->getPlotNum()) || (iplot->isTied())) {
      iplot->setLog(xLog, yLog);
    }
  }
  MouseInfo->setMode(INACTIVE);
  needrecreate = true;
  update();
}

void KstView::updateTieBox(QPaintDevice *pd, unsigned int i) {
  int s_dim;
  int s_left, s_top;
  QRect tie_box;
  KstPlot *plot;

  if (ZoomCurrentPlot) return;

  QPainter p(pd);
  p.setPen(QColor("black"));

  plot = KST::plotList.at(i);
  tie_box = plot->GetTieBoxRegion();
  s_dim = tie_box.width()/3;
  s_left = tie_box.left() + tie_box.width()/2 - s_dim/2;
  s_top = tie_box.top() + tie_box.width()/2 - s_dim/2;

  if (plot->isTied()) {
    p.fillRect(tie_box, QColor("slate grey"));
  } else {
    p.fillRect(tie_box, QColor("white"));
  }
  p.drawRoundRect(tie_box);
  if (i==MouseInfo->getPlotNum()) {
    p.fillRect(s_left, s_top, s_dim, s_dim, QColor("black"));
  } else {
    p.fillRect(s_left, s_top, s_dim, s_dim, QColor("white"));
  }
}

void KstView::updateTieBoxes(QPaintDevice *pd) {
  unsigned int i, count;

  if (ZoomCurrentPlot) return;

  count = KST::plotList.count();
  for (i=0; i < count; i++) {
    updateTieBox(pd, i);
  }
}

void KstView::toggleTiedZoom() {
  int i, count;
  KstPlot *plot;
  int num_tied=0;
  bool new_tie_state;

  // the plots get to vote on whether we are going to tie or untie...
  count = (int)KST::plotList.count();
  for (i=0; i < count; i++) {
    plot = KST::plotList.at(i);
    if (plot->isTied()) num_tied++;
  }
  if (num_tied>count/2) new_tie_state = false;
  else new_tie_state = true;

  for (i=0; i < count; i++) {
    plot = KST::plotList.at(i);
    plot->setTied(new_tie_state);
  }
  updateTieBoxes(this);
}

void KstView::zoomPlotSlot() {
  ZoomCurrentPlot = !ZoomCurrentPlot;

  if (ZoomCurrentPlot) MouseInfo->setZoomed();
  else MouseInfo->unsetZoom();

  ZoomPlotNum =  MouseInfo->getPlotNum();
  update();
}

void KstView::forceUpdate() {
  needrecreate = true;
  paintEvent(0L);
}

#include "kstview.moc"
