/***************************************************************************
 *
 * knetworkmanager-vpnauthenticationdialog.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <stdlib.h>
#include <kpushbutton.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qmessagebox.h>
#include <qwidgetstack.h>
#include <klineedit.h>
#include <qlabel.h>
#include <klocale.h>
#include <kdebug.h>
#include <qobjectlist.h>
#include <qfocusdata.h>
#include <kiconloader.h>

#include "knetworkmanager-vpn.h"
#include "knetworkmanager-vpnauthenticationdialog.h"

/*
 * class VPNAuthenticationDialog
 *
 */
VPNAuthenticationDialog::VPNAuthenticationDialog(VPNConnection* conn, QWidget* parent, const char* name, bool modal, WFlags fl)
	: AuthenticationDialog(parent, name, modal, fl)
{
	this->setIcon(SmallIcon("encrypted", QIconSet::Automatic));
	this->setCaption(i18n("VPN Authentication for %1").arg(conn->getName()));
	labelPixmap->setPixmap(KGlobal::instance()->iconLoader()->loadIcon("encrypted", KIcon::Small, 32));

	// nice icons
	pushOK->setIconSet(SmallIcon("button_ok", QIconSet::Automatic));
	pushCancel->setIconSet(SmallIcon("button_cancel", QIconSet::Automatic));

	// we need the last widget in the focus queue
	QFocusData* foc = focusData();
	QWidget* lastFocusWidget = foc->last();
	
	// get the appropriate plugin and create the authentication widget
	VPNPlugin* vpnPlugin = conn->getVPNService()->getVPNPlugin();
	if (vpnPlugin)
	{
		_vpnAuthWidget = vpnPlugin->CreateAuthenticationWidget(widgetStack);
		if (_vpnAuthWidget)
			widgetStack->raiseWidget(_vpnAuthWidget);
	}
	
	/*
	 the widgets inside the authenticationwidget are now in the focus queue
	 ==> we can now search the first widget inside the authenticationwidget 
	     which has to get the focus
	*/
	QWidget* widget = foc->home();
	for (int i = 0; i < foc->count(); ++i)
	{
		if (widget == lastFocusWidget)
		{
			// the next one is the first widget inside the authwidget
			widget = foc->next();
			break;
		}
		widget = foc->next();
	}
	if (widget)
		widget->setFocus();

	// resize
	this->resize(minimumSizeHint());
}

VPNAuthenticationDialog::~VPNAuthenticationDialog()
{
	
}

bool VPNAuthenticationDialog::close(bool alsoDelete)
{
	QStringList helper;
	emit done(true, helper, false, false);
	return AuthenticationDialog::close(alsoDelete);
}

void VPNAuthenticationDialog::ok()
{
	QStringList helper = _vpnAuthWidget->getPasswords();
	emit done (false, helper, chkStorePasswordsPermanent->isChecked(), chkStorePasswordsSession->isChecked()); 
	QDialog::done(0);
}

void VPNAuthenticationDialog::cancel()
{
	QStringList x;
	emit done (true, x, false, false);
	QDialog::done(1);
}

