/* -*- c++ -*-
 *
 * imageloader.cpp
 *
 * Copyright (C) 2005 Petter Stokke <ummo@hellokitty.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include "imageloader.h"

#include <kdebug.h>
#include <qpixmapcache.h>
#include <kpixmap.h>
#include <kstandarddirs.h>

#include <network.h>

KPixmap ImageLoader::imageForNetwork(Network* network)
{
    QString cacheString("networkimage:" + network->networkName());
    KPixmap image;
    if (QPixmapCache::find(cacheString, image)) return image;
    KStandardDirs dirs;
    QString path = dirs.findResource("data", "kmldonkey/images/networks/");
    QString filename(network->networkName());
    filename = filename.lower().replace(" ", "").append(".png");
    kdDebug() << "Generated path " << path << filename << endl;
    if (!image.load(path + filename))
        image.load(path + "unknown.png");
    QPixmapCache::insert(cacheString, image);
    return image;
}
