/* -*- c++ -*-
 *
 * main.cpp
 *
 * Copyright (C) 2003 Petter Stokke <ummo@hellokitty.com>
 * Copyright (C) 2006 Christian Muehlhaeuser <chris@chris.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include <stdlib.h>

#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kconfig.h>
#include <kdebug.h>
#include <klocale.h>
#include <kuniqueapplication.h>

#include "disclaimer.h"
#include "kmldonkey.h"
#include "setupwizard.h"
#include "version.h"

static KCmdLineOptions options[] =
{
    { 0, 0, 0 }
};

int main( int argc, char **argv )
{
    KAboutData about( "kmldonkey", I18N_NOOP( "KMLDonkey" ), KMLDONKEY_VERSION,
                      I18N_NOOP( "An MLDonkey frontend for the KDE desktop." ),
                      KAboutData::License_GPL_V2, I18N_NOOP( "Copyright (C) 2003 - 2006 The KMLDonkey Authors" ),
                      I18N_NOOP( "Part of the KMLDonkey package." ),
                      "http://www.kmldonkey.org" );

    about.addAuthor( "Christian Muehlhaeuser", I18N_NOOP( "Maintainer" ), "chris@chris.de" );
    about.addAuthor( "Petter Stokke", I18N_NOOP( "Developer & Project Founder" ), "ummo@hellokitty.com" );
    about.addAuthor( "Sebastian Sauer", I18N_NOOP( "Developer" ), "mail@dipe.org" );
    about.setTranslator(I18N_NOOP( "_: NAME OF TRANSLATORS\nYour names" ), I18N_NOOP( "_: EMAIL OF TRANSLATORS\nYour emails" ) );

    KCmdLineArgs::init( argc, argv, &about );
    KCmdLineArgs::addCmdLineOptions( options );
    KUniqueApplication::addCmdLineOptions();

    if ( !KUniqueApplication::start() )
    {
        QByteArray data;
        QDataStream arg( data, IO_WriteOnly );
        arg << true;

        DCOPClient client;
        client.registerAs( "kmldonkeyLauncher" );
        client.send( "kmldonkey", "KMLDonkey", "setShown(bool)", data );
        exit( 0 );
    }

    KUniqueApplication app;
    app.dcopClient()->registerAs( app.name(), false );
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    args->clear();

    DisclaimerDialog* disclaimer = new DisclaimerDialog();
    disclaimer->exec();
    delete disclaimer;

    KConfig* conf = KGlobal::config();
    conf->setGroup( "State" );
    if ( conf->readBoolEntry( "FirstRun", true ) )
    {
        SetupWizard w;
        w.exec();
    }

    KMLDonkey widget;
    widget.show();
    return app.exec();
}
