/***************************************************************************
                          rectdlg.cpp  -  description
                             -------------------
    begin                : Sat Apr 28 2001
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include "brushdlg.h"
#include "kpldoubleedit.h"
#include "rectitem.h"
#include "rectdlg.h"

RectDlg::RectDlg(QWidget* _parent, KplDoc* model, RectItem* rd0) :
 DecoDlg(_parent, QString::null, rd0->iType() == KplItem::Rectangle ?
         "SEC-RECT" : "SEC-ELLIPSE", model, rd0, 5), rd(rd0)
{
  QFrame* frame = plainPage();
  grid->addWidget(new QLabel(i18n("Width"), frame), 0, 0);
  grid->addWidget(eWidth = new KplDoubleEdit(rd->width, 0.1, 200.0, frame),
                  0, 1);
  grid->addWidget(new QLabel("cm", frame), 0, 2);
  grid->addWidget(new QLabel(i18n("Height"), frame), 0, 4);
  grid->addWidget(eHeight = new KplDoubleEdit(rd->height, 0.1, 200.0, frame),
                  0, 5);
  grid->addWidget(new QLabel("cm", frame), 0, 6);
  grid->addWidget(new QLabel(i18n("Rotation"), frame), 1, 0);
  grid->addWidget(eDir = new KplDoubleEdit(rd->dir, -360.0, 360.0, frame),
                  1, 1);
  grid->addWidget(new QLabel("", frame), 1, 2);
  initEntries(2);
  lSize->setText(i18n("Line width"));
  grid->addWidget(new QLabel(i18n("Fill pattern"), frame), 4, 4);
  grid->addWidget(fill = new BrushButton(frame, rd->fillStyle), 4, 5);
}

RectDlg::~RectDlg()
{
}

void RectDlg::getValues(bool ok)
{
  rd->width = eWidth->value();
  rd->height = eHeight->value();
  rd->dir = eDir->value();
  rd->fillStyle = fill->value();
  DecoDlg::getValues(ok);
}

void RectDlg::slotOk()
{
  getValues(true);
}

void RectDlg::slotApply()
{
  getValues(false);
}
