/***************************************************************************
 *   Copyright (C) 2000 2008 by Michael Rapaport   *
 *   rucko4t@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <stdlib.h>
#include <math.h>
#include <qdir.h>
#include <qfile.h>
#include <krandomsequence.h>
#include "game.h"
#include "game1.h"
#include "masq.h"

float score[2];
unsigned int *ppq;
extern int alreadyDrawn,num_moves_no_cap_or_man_move;
extern Hash hash[64];
extern int numGames;
QString gpaht,glocalpaht;
QString curBrain;

Game::Game(QString pahht,QString localpahht)
{
 gpaht = pahht;glocalpaht = localpahht;
}

int Game::loadBrain(QString toRead)
{
QString theFile;
if(QFile::exists(glocalpaht+toRead))theFile = glocalpaht+toRead;
else theFile = gpaht+"brain/"+toRead;
QFile p(theFile);
float *pf;
curBrain = toRead;
if (p.open( IO_ReadOnly )) 			//brainA.dat
   	{
   	QDataStream s (&p);
	s>>numGames;
	pf=fWeights[0][0][0];
	for (k=0;k<17424;k++){s>>*pf;pf++;}
	p.close();
	return 1;
        }
else return 0;
}

int Game::def_Brain()
{
QFile p(gpaht+"brain/"+curBrain);
float *pf;

if (p.open( IO_ReadOnly ))
   	{
   	QDataStream s (&p);
	s>>numGames;
	pf=fWeights[0][0][0];
	for (k=0;k<17424;k++){s>>*pf;pf++;}
	p.close();
	return 1;
        }
else return 0;
}

void Game::scramble()
{
KRandomSequence brand(0);

		for (k=0;k<4;k++)		 /// create birth brain
		{
			for (i=0;i<32;i++) 
			{
				for (j=0;j<33;j++) 
				{
				fWeights[0][k][j][i] = (float) brand.getDouble();     //0.25f;  //.001f;   //25f;	//compmen
				fWeights[1][k][j][i] = (float) -brand.getDouble();    //-0.25f; //-.001f;  //25f;	//enemymen
				fWeights[2][k][j][i] = (float) brand.getDouble();     //0.75f;   //.001f;   //75f;	//compking
				fWeights[3][k][j][i] = (float) -brand.getDouble();   //-0.75f;  //-.001f;   //75f;	//enemyking
				}
			}

		}

		for (j=0;j<32;j++) 
		{
		fWeights[0][0][j][32] = (float) brand.getDouble();   //0.25f;	//.001f;   //25f;//1/(float)4;	//compmen
		fWeights[1][1][j][32] = (float) brand.getDouble();   //0.25f;	//.001f;   //25f;//-1/(float)4;	//enemymen
		fWeights[2][2][j][32] = (float) brand.getDouble();   //0.75f;	//.001f;   //75f;//3/(float)4;	//compking
		fWeights[3][3][j][32] = (float) brand.getDouble();   //0.75f;	//.001f;   //75f;//-3/(float)4;	//enemyking
		}
	numGames=0;					///Syrus is born
}

Game::~Game()
{
float *pf;
pf=fWeights[0][0][0];

QFile m(glocalpaht+curBrain);
if (m.open( IO_WriteOnly ))
   	{
	QDataStream s (&m);
	s<<(Q_INT32)numGames;
	pf=fWeights[0][0][0];
	for (k=0;k<17424;k++){s<<(float)*pf;pf++;}
	m.close();
	}
}

float Game::popcount(uint64_t b)
{
    unsigned int n;
    uint64_t a = b - ((b >> 1) & m1);
    uint64_t c = (a & m2) + ((a >> 2) & m2);
    n = ((unsigned int) c) + ((unsigned int) (c >> 32));
    n = (n & 0x0F0F0F0F) + ((n >> 4) & 0x0F0F0F0F);
    n = (n & 0xFFFF) + (n >> 16);
    n = (n & 0xFF) + (n >> 8);
    return (float)n;
}
					// search game tree to given depth, return evaluation of root node
float Game::negamax()
{
	float e=-infiniti;
	float backalpha,backbeta;
	
	if(!(emg|ekg))
	{
		return (-winlose-dep);
	}
	backalpha=alpha;backbeta=beta;
	alpha=-backbeta;beta=-backalpha;

	ckg|=(cmg&prom[playingA]);cmg^=(cmg&prom[playingA]);
	
		if(dep<2)
		{
						//Quiesce search:Carry out all the compulsory takes
			playingA=!playingA;
			temp=emg;emg=cmg;cmg=temp;
    			temp=ekg;ekg=ckg;ckg=temp; 

			if(cmg)e=genMtakes();
			if(ckg && e<beta)e=genKtakes(e);
			
			playingA=!playingA;
			temp=emg;emg=cmg;cmg=temp;	
    			temp=ekg;ekg=ckg;ckg=temp;	

			if(e==-infiniti) 
				{
				alpha=backalpha;beta=backbeta;
				return   RunA();           //eval();//(this->*peval[moverplayA])();
				}
			alpha=backalpha;beta=backbeta;
			return e;
		}
	dep--;
	playingA=!playingA;
	temp=emg;emg=cmg;cmg=temp;
    	temp=ekg;ekg=ckg;ckg=temp; 

	if(cmg)e=genMtakes();
	if(ckg && e<beta)e=genKtakes(e);
	if(e==-infiniti)
	{
		if(cmg)e=gen_onemove();
		if(ckg && e<beta)e=genKmove(e);
	}

	playingA=!playingA;
	temp=emg;emg=cmg;cmg=temp;	
    	temp=ekg;ekg=ckg;ckg=temp;	

	dep++;
	alpha=backalpha;beta=backbeta;
	
	return e;

} 

float Game::startMtakes()
{
	float a=-infiniti,e = -infiniti;		// e is needed for takes
	uint64_t to_map,allenemy,ek,cm,em, ck,manland;
	int to_sq;
	cm=cmg;em=emg;ck=ckg;ek=ekg;
	allenemy=em|ek;
	manland=~(cmg|ckg|allenemy)&validsq;
	to_map=manland&((cmg<<7)&allenemy)<<7;
		while (to_map) 
		{
			to_sq=LSB(to_map);
			to_map^=mask[to_sq];
			cmg^=mask[to_sq-14];
			cmg|=mask[to_sq];
			emg&=notmask[to_sq-7];
			ekg&=notmask[to_sq-7];
			a=pursueMtakes(pbest+1,to_sq,e);
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			
			if(e<a)
			{
				e=a;
				*pbest=to_sq-14;
				*(pbest+1)=to_sq;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}
		
	   }

		to_map=manland&((cmg<<9)&allenemy)<<9;
		while (to_map) 
		{
			to_sq=LSB(to_map);
			to_map^=mask[to_sq];
			cmg^=mask[to_sq-18];
			cmg|=mask[to_sq];
			emg&=notmask[to_sq-9];
			ekg&=notmask[to_sq-9];
			a=pursueMtakes(pbest+1,to_sq,e);
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			
			if(e<a)
			{
				e=a;
				*pbest=to_sq-18;
				*(pbest+1)=to_sq;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
				
			}
			
	   }

		to_map=manland&((cmg>>9)&allenemy)>>9;
		while (to_map) 
		{
			to_sq=LSB(to_map);
			to_map^=mask[to_sq];
			cmg^=mask[to_sq+18];
			cmg|=mask[to_sq];
			emg&=notmask[to_sq+9];
			ekg&=notmask[to_sq+9];
			a=pursueMtakes(pbest+1,to_sq,e);
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			
			if(e<a)
			{
				e=a;
				*pbest=to_sq+18;
				*(pbest+1)=to_sq;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
				
			}
			
	   }

		to_map=manland&((cmg>>7)&allenemy)>>7;
		while (to_map) 
		{
			to_sq=LSB(to_map);
			to_map^=mask[to_sq];
			cmg^=mask[to_sq+14];
			cmg|=mask[to_sq];
			emg&=notmask[to_sq+7];
			ekg&=notmask[to_sq+7];
			a=pursueMtakes(pbest+1,to_sq,e);
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			
			if(e<a)
			{
				e=a;
				*pbest=to_sq+14;
				*(pbest+1)=to_sq;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
				
			}
			
	   }
			
		return e;
}

float Game::pursueMtakes(unsigned int *pbest,int man,float e)
{
	float a=-infiniti;
	uint64_t to_map,capture,allenemy,cm,em,ek, ck,manland;
	int to_sq,tokins=0;
		capture=mask[man];
		cm=cmg;em=emg;ck=ckg;ek=ekg;
		allenemy=em|ek;
		manland=~(cmg|ckg|allenemy)&validsq;
		to_map=manland&((capture<<7)&allenemy)<<7;
		if(to_map) 
		{
			to_sq=LSB(to_map);
			to_map^=mask[to_sq];
			cmg^=mask[to_sq-14];
			cmg|=mask[to_sq];
			emg&=notmask[to_sq-7];
			ekg&=notmask[to_sq-7];
			a=pursueMtakes(pbest+1,to_sq,e);
			if(e<a)
			{
				e=a;
				*(pbest+1)=to_sq;            //dest
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}
			cmg=cm;emg=em;ckg=ck;ekg=ek;tokins++;
	   }
	
		to_map=manland&((capture<<9)&allenemy)<<9;
		if(to_map) 
		{
			to_sq=LSB(to_map);
			to_map^=mask[to_sq];
			cmg^=mask[to_sq-18];
			cmg|=mask[to_sq];
			emg&=notmask[to_sq-9];
			ekg&=notmask[to_sq-9];
			a=pursueMtakes(pbest+1,to_sq,e);
			if(e<a)
			{
				e=a;
				*(pbest+1)=to_sq;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}
			cmg=cm;emg=em;ckg=ck;ekg=ek;tokins++;
	   }

		to_map=manland&((capture>>9)&allenemy)>>9;
		if(to_map) 
		{
			to_sq=LSB(to_map);
			to_map^=mask[to_sq];
			cmg^=mask[to_sq+18];
			cmg|=mask[to_sq];
			emg&=notmask[to_sq+9];
			ekg&=notmask[to_sq+9];
			a=pursueMtakes(pbest+1,to_sq,e);
			if(e<a)
			{
				e=a;
				*(pbest+1)=to_sq;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}
			cmg=cm;emg=em;ckg=ck;ekg=ek;tokins++;
	   }

		to_map=manland&((capture>>7)&allenemy)>>7;
		if(to_map) 
		{
			to_sq=LSB(to_map);
			to_map^=mask[to_sq];
			cmg^=mask[to_sq+14];
			cmg|=mask[to_sq];
			emg&=notmask[to_sq+7];
			ekg&=notmask[to_sq+7];
			a=pursueMtakes(pbest+1,to_sq,e);
			if(e<a)
			{
				e=a;
				*(pbest+1)=to_sq;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}
			cmg=cm;emg=em;ckg=ck;ekg=ek;tokins++;
	   }

		if(!tokins)
		{
			a=-negamax();
			if(e<a)return a;		//{*(pbest+1)=to_sq;return a;}
		}
		return e;
}

float Game::genMtakes()
{
	float a=-infiniti,e = -infiniti;                    // e is needed for takes
	uint64_t to_map,allenemy,ek,cm,em, ck,manland,starM;
	cm=cmg;em=emg;ck=ckg;ek=ekg;
	allenemy=em|ek;
	manland=~(cmg|ckg|allenemy)&validsq;

	to_map=manland&((cmg<<7)&allenemy)<<7;
		while (to_map) 
		{
			starM=to_map&((~to_map)+1);
			to_map^=starM;
			cmg^=starM>>14;
			cmg|=starM;
			emg&=~(starM>>7);
			ekg&=~(starM>>7);
			a=gen_pursueMtakes(starM);
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			if(e<a)
			{
				e=a;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}	
	   }
	
		to_map=manland&((cmg<<9)&allenemy)<<9;
		while (to_map) 
		{
			starM=to_map&((~to_map)+1);
			to_map^=starM;
			cmg^=starM>>18;
			cmg|=starM;
			emg&=~(starM>>9);
			ekg&=~(starM>>9);
			a=gen_pursueMtakes(starM);
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			if(e<a)
			{
				e=a;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}	
	   }

		to_map=manland&((cmg>>9)&allenemy)>>9;
	while (to_map) 
		{
			starM=to_map&((~to_map)+1);
			to_map^=starM;
			cmg^=starM<<18;
			cmg|=starM;
			emg&=~(starM<<9);
			ekg&=~(starM<<9);
			a=gen_pursueMtakes(starM);
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			if(e<a)
			{
				e=a;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}	
	   }
	
		to_map=manland&((cmg>>7)&allenemy)>>7;
		while (to_map) 
		{
			starM=to_map&((~to_map)+1);
			to_map^=starM;
			cmg^=starM<<14;
			cmg|=starM;
			emg&=~(starM<<7);
			ekg&=~(starM<<7);
			a=gen_pursueMtakes(starM);
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			if(e<a)
			{
				e=a;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}	
	   }
	

		return e;
}

float Game::gen_pursueMtakes(uint64_t capture)
{
	float e = -infiniti,a=-infiniti;
	uint64_t to_map,allenemy,cm,em,ek, ck,manland;

		cm=cmg;em=emg;ck=ckg;ek=ekg;
		allenemy=em|ek;
		manland=~(cmg|ckg|allenemy)&validsq;
		to_map=manland&((capture<<7)&allenemy)<<7;
		if(to_map) 
		{
					//	starM=to_map&((~to_map)+1);
			cmg^=capture;
			cmg|=to_map;
			emg&=~(to_map>>7);
			ekg&=~(to_map>>7);
			a=gen_pursueMtakes(to_map);
			if(e<a)
			{
				e=a;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}
			cmg=cm;emg=em;ckg=ck;ekg=ek;
	   }
		to_map=manland&((capture<<9)&allenemy)<<9;
			if(to_map) 
		{
					//	starM=to_map&((~to_map)+1);
			cmg^=capture;
			cmg|=to_map;
			emg&=~(to_map>>9);
			ekg&=~(to_map>>9);
			a=gen_pursueMtakes(to_map);
			if(e<a)
			{
				e=a;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}
			cmg=cm;emg=em;ckg=ck;ekg=ek;
	   }
	
		to_map=manland&((capture>>9)&allenemy)>>9;
	if(to_map) 
		{
					//		starM=to_map&((~to_map)+1);
			cmg^=capture;
			cmg|=to_map;
			emg&=~(to_map<<9);
			ekg&=~(to_map<<9);
			a=gen_pursueMtakes(to_map);
			if(e<a)
			{
				e=a;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}
			cmg=cm;emg=em;ckg=ck;ekg=ek;
	   }
		to_map=manland&((capture>>7)&allenemy)>>7;
	if(to_map) 
		{
						//		starM=to_map&((~to_map)+1);
			cmg^=capture;
			cmg|=to_map;
			emg&=~(to_map<<7);
			ekg&=~(to_map<<7);
			a=gen_pursueMtakes(to_map);
			if(e<a)
			{
				e=a;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}
			cmg=cm;emg=em;ckg=ck;ekg=ek;
	   }
	
		if(e==-infiniti)
		{
			e=-negamax();
			return e;
		}
		return e;
}


float Game::start_onemove()
{
	float a=-infiniti,e=-winlose-dep;		//e = -infiniti;
	
	uint64_t to_map,ek,cm,em, ck,manland;
	int to_sq;
	cm=cmg;em=emg;ck=ckg;ek=ekg;
	manland=~(cmg|emg|ckg|ekg)&validsq;
 	if(!playingA)             
	{
		to_map=manland&(cmg<<7);
		while (to_map) 
		{
			to_sq=MSB(to_map);
			to_map^=mask[to_sq];
			cmg^=mask[to_sq-7];
			cmg|=mask[to_sq];
			a=-negamax();
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			
			if(e<a)
			{
				e=a;
				*pbest=to_sq-7;
				*(pbest+1)=to_sq;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
				
			}
		
	   }
		to_map=manland&(cmg<<9);
		while (to_map) 
		{
			to_sq=MSB(to_map);
			to_map^=mask[to_sq];
			cmg^=mask[to_sq-9];
			cmg|=mask[to_sq];
			a=-negamax();
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			
			if(e<a)
			{
				e=a;
				*pbest=to_sq-9;
				*(pbest+1)=to_sq;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
				
			}
			
	   }
	}
//	if(playingA)
	else
	{
		to_map=manland&(cmg>>7);
		while (to_map) 
		{
			to_sq=LSB(to_map);
			to_map^=mask[to_sq];
			cmg^=mask[to_sq+7];
			cmg|=mask[to_sq];
			a=-negamax();
			cmg=cm;emg=em;ckg=ck;ekg=ek;

			if(e<a)
			{
				e=a;
				*pbest=to_sq+7;
				*(pbest+1)=to_sq;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
				
			}
			
	   }
		to_map=manland&(cmg>>9);
		while (to_map) 
		{
			to_sq=LSB(to_map);
			to_map^=mask[to_sq];
			cmg^=mask[to_sq+9];
			cmg|=mask[to_sq];
			a=-negamax();
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			
			if(e<a)
			{
				e=a;
				*pbest=to_sq+9;
				*(pbest+1)=to_sq;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
				
			}
			
	   }
	}

   return e;
}

float Game::gen_onemove()
{
	float a=-infiniti,e=-winlose-dep;		//e = -infiniti;
	uint64_t to_map,ek,cm,em, ck,manland,starM;
//	int to_sq;
	cm=cmg;em=emg;ck=ckg;ek=ekg;
	manland=~(cmg|emg|ckg|ekg)&validsq;
if(!playingA)	
	{
	to_map=manland&(cmg<<7);
		while (to_map) 
		{
			starM=to_map&((~to_map)+1);
			to_map^=starM;
			cmg^=starM>>7;
			cmg|=starM;
			a=-negamax();
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			if(e<a)
			{
				e=a;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}	
	   }
		to_map=manland&(cmg<<9);
		while (to_map) 
		{
			starM=to_map&((~to_map)+1);
			to_map^=starM;
			cmg^=starM>>9;
			cmg|=starM;
			a=-negamax();
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			if(e<a)
			{
				e=a;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}
			
	   }
	}
//if(playingA)
else
	{
		to_map=manland&(cmg>>7);
		while (to_map) 
		{
			starM=to_map&((~to_map)+1);
			to_map^=starM;
			cmg^=starM<<7;
			cmg|=starM;
			a=-negamax();
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			if(e<a)
			{
				e=a;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}	
	   }
		to_map=manland&(cmg>>9);
		while (to_map) 
		{
			starM=to_map&((~to_map)+1);
			to_map^=starM;
			cmg^=starM<<9;
			cmg|=starM;
			a=-negamax();
			cmg=cm;emg=em;ckg=ck;ekg=ek;
			if(e<a)
			{
				e=a;
				if(alpha<a)alpha=a;
				if(a>=beta)return a;
			}
			
	   }

	}
   return e;
}


int Game::play_it(int playfirst,unsigned int *p) 	//former name computer
	{				    		//  *p point to movelist[]
					    		//  array to store moves
	float e=-infiniti;
	int was_one_move=0;
	ppq=p;

	if(!(cmg|ckg))return 0; // You won: I have no men. :(
	countt=0;
	pbest=ppq;                 ///movelist1;
	dep=hard;		//		dep=level[playfirst];
	playingA=playfirst;			                        
	moverplayA=playfirst;

//	if(dep>11&&(popcount(ekg)||popcount(ckg)))dep-=2;

					//////////////////Aspiration Search/////////////////
	alpha = -infiniti-2;
	beta  =  infiniti+2;
	st_alpha=alpha;
	st_beta=beta;
	
	for(;;)
	{
	    e=-infiniti;                 
	    was_one_move=0;
		pbest=ppq;			//movelist1;
		if(cmg)e=startMtakes();
		if(ckg)e=startKtakes(e);	
		
		if(e==-infiniti)                              
			{
			was_one_move=1;
			if(cmg)e=start_onemove();
			if(ckg)e=startKmove(e);  //read above
			}
		     if(e<=st_alpha){alpha = -infiniti-2;st_alpha=alpha;st_beta=beta;continue;}
		else if(e>=st_beta ){beta  =  infiniti+2;st_alpha=alpha;st_beta=beta;continue;}
        else break;
	}

	playingA=playfirst;
	score[playfirst]=e;
	start=e;
	winner=2;

if(!alreadyDrawn)
	{
	if(e==-winlose-dep || (e==-infiniti))
		{winner=0;if(dep>-10){TrainA(e/winlose);}return winner;}       // You won
				                                            
	if((e==winlose+dep-1) || (e==winlose+dep) || (e==infiniti))
	{winner=1;if(dep>-10){TrainA(e/winlose);}return winner;}               // I won

	if(was_one_move && ckg&mask[*pbest])	//Draw can only occur when a king is moving
	{
		num_moves_no_cap_or_man_move++;

		if(e<winlose && e>-winlose && popcount(ekg)>0 && popcount(ekg|emg)<4 && popcount(ckg|cmg)<4 )
			{
if(pendingDraw){pendingDraw=0;e=0;winner=3;if(dep>-10){TrainA(e/winlose);}return winner;} else  pendingDraw=1;                                                                         //offer draw
			}

		if(num_moves_no_cap_or_man_move>14)
			{
if(pendingDraw){pendingDraw=0;e=0;winner=3;if(dep>-10){TrainA(e/winlose);}return winner;} else  pendingDraw=1;
			}
		if( hash[*(pbest+1)].cm==0xFFFFFFFFFFFFFFFFLL || 
			(hash[*(pbest+1)].cm==cmg && hash[*(pbest+1)].ck==ckg	
			&& hash[*(pbest+1)].em==emg && hash[*(pbest+1)].ek==ekg))
				{
			hash[*(pbest+1)].num_repeats++;
			if(hash[*(pbest+1)].num_repeats==3)
						{
if(pendingDraw){pendingDraw=0;e=0;winner=3;if(dep>-10){TrainA(e/winlose);}return winner;} else  pendingDraw=1;
						}
				}
		else
			{
			hash[*(pbest+1)].num_repeats=1;
			}
		hash[*(pbest+1)].cm=cmg;hash[*(pbest+1)].ck=ckg;	
		hash[*(pbest+1)].em=emg;hash[*(pbest+1)].ek=ekg;
	}
	  else
		{
		num_moves_no_cap_or_man_move=0;
		}

	if(dep>-10){TrainA(e/winlose);}return winner;	
	}
return winner;
}

float Game::startKtakes(float e)
{	
	float a=-infiniti;   
	uint64_t to_map,em,ek,allcomp,cm, ck,Kmask,star,starK,allpiece,allenemy,starland;
	int sq,sqbak,take,land,sqland;

	to_map=ckg;
	cm=cmg;em=emg;ck=ckg;ek=ekg;allenemy=em|ek;allcomp=cm|ck;
		while (to_map) 
		{
			sq=sqbak=LSB(to_map);
			starK=star=mask[sq];		    // roll out a king
			to_map^=starK;			    // and erase it.. one les king to do
			allpiece=(cmg|allenemy|(ckg^starK));
						   
						   /////////NE//////////
	
	if((kingNE[sq]&(allenemy))!=0)
	{
		Kmask=kingNE[sq]&~((allpiece&(allpiece>>7|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK<<7))               
		{
			starK<<=7;
		   if(starK&allenemy)							     
				{
				if(take)
					{
						a=pursueKtakes(pbest+1,1,sq,e);
						if(a!=-infiniti)land=0;       //no takes found

						if(e<a)e=a;

						if(alpha<a)
						{alpha=a;*pbest=sqbak;*(pbest+1)=sq;}
						
						break;
					}
				emg&=~starK;ekg&=~starK;ckg|=(starK<<=7);ckg^=starK>>14;
				take++;sq+=14;sqland=sq;starland=starK;
				} 
		 
		 else   {
				  ckg|=starK;ckg^=starK>>7;sq+=7;
				}
		if(take)              
				{
					a=pursueKtakes(pbest+1,10,sq,e);
					if(a!=-infiniti)land=0;       //no takes found


				if(e<a)e=a;
				if(alpha<a)
				{alpha=a;*pbest=sqbak;*(pbest+1)=sq;}
				
				}								
			}
		if(land && take)        // only one take so lets send all the landings to negamax.
		{
		ckg^=starK;ckg|=starland;
		while(Kmask&starland)              
			{
				a=-negamax();				
				if(e<a)e=a;
				if(alpha<a)
				{alpha=a;*pbest=sqbak;*(pbest+1)=sqland;}
				ckg^=starland;starland<<=7;sqland+=7;ckg|=starland;
			}

		}
		cmg=cm;emg=em;ckg=ck;ekg=ek;starK=star;sq=sqbak;
	}
							 /////////NW//////////      
		    
	if((kingNW[sq]&(allenemy))!=0)
	{
		Kmask=kingNW[sq]&~((allpiece&(allpiece>>9|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK<<9))               
		{
			starK<<=9;
		   if(starK&allenemy)							     
				{
			   if(take)
			   {
						a=pursueKtakes(pbest+1,2,sq,e);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;

						if(alpha<a)
						{alpha=a;*pbest=sqbak;*(pbest+1)=sq;}
					 break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK<<=9);ckg^=starK>>18;
				take++;sq+=18;sqland=sq;starland=starK;
				}
		
		 else   {
				  ckg|=starK;ckg^=starK>>9;sq+=9;
				}
		if(take)              
				{ 
						a=pursueKtakes(pbest+1,5,sq,e);
						if(a!=-infiniti)land=0;

				if(e<a)e=a;
				if(alpha<a)
				{alpha=a;*pbest=sqbak;*(pbest+1)=sq;}
				}
			}
	if(land && take)			// only one take so lets send all the landings to negamax.
		{
		ckg^=starK;ckg|=starland;
		while(Kmask&starland)              
			{
				a=-negamax();				
				if(e<a)e=a;
				if(alpha<a)
				{alpha=a;*pbest=sqbak;*(pbest+1)=sqland;}
				ckg^=starland;starland<<=9;sqland+=9;ckg|=starland;
			}

		}
			 
		cmg=cm;emg=em;ckg=ck;ekg=ek;starK=star;sq=sqbak;				
	}
								/////////SW//////////
	if((kingSW[sq]&(allenemy))!=0)
	{
		Kmask=kingSW[sq]&~((allpiece&(allpiece<<7|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK>>7))               
		{
			starK>>=7;
		   if(starK&allenemy)							     
				{
			   if(take){
						a=pursueKtakes(pbest+1,4,sq,e);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;

						if(alpha<a)
						{alpha=a;*pbest=sqbak;*(pbest+1)=sq;}
				   break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK>>=7);ckg^=starK<<14;
				take++;sq-=14;sqland=sq;starland=starK;
				}
		 
		 else   {
				  ckg|=starK;ckg^=starK<<7;sq-=7;
				}
		if(take)              
				{ 
						a=pursueKtakes(pbest+1,10,sq,e);
						if(a!=-infiniti)land=0;

				if(e<a)e=a;
				if(alpha<a)
				{alpha=a;*pbest=sqbak;*(pbest+1)=sq;}
				}
			}
	if(land && take)					// only one take so lets send all the landings to negamax.
		{
		ckg^=starK;ckg|=starland;
		while(Kmask&starland)              
			{
				a=-negamax();				
				if(e<a)e=a;
				if(alpha<a)
				{alpha=a;*pbest=sqbak;*(pbest+1)=sqland;}
				ckg^=starland;starland>>=7;sqland-=7;ckg|=starland;
			}

		}
			
		cmg=cm;emg=em;ckg=ck;ekg=ek;starK=star;sq=sqbak;
	}
								/////////SE//////////

	if((kingSE[sq]&(allenemy))!=0)
	{
		Kmask=kingSE[sq]&~((allpiece&(allpiece<<9|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK>>9))               
		{	
			starK>>=9;
		   if(starK&allenemy)							     
				{
			   if(take){
				   		a=pursueKtakes(pbest+1,8,sq,e);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;

						if(alpha<a)
						{alpha=a;*pbest=sqbak;*(pbest+1)=sq;}
				   break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK>>=9);ckg^=starK<<18;
				take++;sq-=18;sqland=sq;starland=starK;
				}
		 
		 else   {
				  ckg|=starK;ckg^=starK<<9;sq-=9;
				}
		if(take)              
				{ 
						a=pursueKtakes(pbest+1,5,sq,e);
						if(a!=-infiniti)land=0;

				if(e<a)e=a;
				if(alpha<a)
				{alpha=a;*pbest=sqbak;*(pbest+1)=sq;}
				}
			}
		if(land && take)    				// only one take so lets send all the landings to negamax.
		{
		ckg^=starK;ckg|=starland;
		while(Kmask&starland)              
			{
				a=-negamax();				
				if(e<a)e=a;
				if(alpha<a)
				{alpha=a;*pbest=sqbak;*(pbest+1)=sqland;}
				ckg^=starland;starland>>=9;sqland-=9;ckg|=starland;  
			}

		}

		cmg=cm;emg=em;ckg=ck;ekg=ek;                //starK=star;sq=sqbak; 

	}
  }
	return e;
}


		// If skip==0 skip none ,1 skip NE   2 skip NW    3 skip SW		4 skip SE

float Game::pursueKtakes(unsigned int *pbest,int skip,int sq,float e)
{	
	float a=-infiniti;             //      1s3 2s4 3s1 4s2
	uint64_t em,ek,allcomp,cm, ck,Kmask,star,starK,allpiece,allenemy,starland;
	int take,sqbak,land,sqland,tokins=0;
			sqbak=sq;		
			starK=star=mask[sq];
			cm=cmg;em=emg;ck=ckg;ek=ekg;allenemy=em|ek;allcomp=cm|ck;
			allpiece=(cmg|allenemy|(ckg^starK));

  if(skip&1 && (kingNE[sq]&(allenemy))!=0)  
	{				   /////////NE//////////
		Kmask=kingNE[sq]&~((allpiece&(allpiece>>7|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK<<7))               
		{
			starK<<=7;
		   if(starK&allenemy)							     
				{
			   if(take){
				   		a=pursueKtakes(pbest+1,1,sq,e);
						if(a!=-infiniti)land=0;
						if(e<a)
							{e=a;*pbest=sqbak;*(pbest+1)=sq;}
				   break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK<<=7);ckg^=starK>>14;
				take++;sq+=14;sqland=sq;starland=starK;
				}
		   
			else{
				  ckg|=starK;ckg^=starK>>7;sq+=7;
				}
		if(take)              
				{ 
						a=pursueKtakes(pbest+1,10,sq,e);
						if(a!=-infiniti)land=0;
						if(e<a)
							{e=a;*pbest=sqbak;*(pbest+1)=sq;}
				}
			}
		if(land && take)    		 // only one take so lets send all the landings to negamax.
		{
			ckg^=starK;ckg|=starland;
			while(Kmask&starland)            
			{
				a=-negamax();				
				if(e<a){e=a;*pbest=sqbak;*(pbest+1)=sqland;}
				ckg^=starland;starland<<=7;sqland+=7;ckg|=starland;
			}
			
		}
		cmg=cm;emg=em;ckg=ck;ekg=ek;starK=star;sq=sqbak;tokins+=take;
	}
 if(skip&2 && (kingNW[sq]&(allenemy))!=0)                                       
	{						 /////////NW//////////
			Kmask=kingNW[sq]&~((allpiece&(allpiece>>9|edge))|(allcomp));
			take=0;land=1;
		while(Kmask&(starK<<9))               
			{
			starK<<=9;
			if(starK&allenemy)							     
				{
			   if(take){
				   		a=pursueKtakes(pbest+1,2,sq,e);
						if(a!=-infiniti)land=0;
						if(e<a)
							{e=a;*pbest=sqbak;*(pbest+1)=sq;}
				   break;
						}
			 
				emg&=~starK;ekg&=~starK;ckg|=(starK<<=9);ckg^=starK>>18;
				take++;sq+=18;sqland=sq;starland=starK;
				}
		 
		    else{
				  ckg|=starK;ckg^=starK>>9;sq+=9;
				}

		if(take)              
				{ 
						a=pursueKtakes(pbest+1,5,sq,e);
						if(a!=-infiniti)land=0;
						if(e<a)
							{e=a;*pbest=sqbak;*(pbest+1)=sq;}
	
				}
			}
	if(land && take)				// only one take so lets send all the landings to negamax.
		{
			ckg^=starK;ckg|=starland;
			while(Kmask&starland)            
			{
				a=-negamax();		
				if(e<a){e=a;*pbest=sqbak;*(pbest+1)=sqland;}
				ckg^=starland;starland<<=9;sqland+=9;ckg|=starland;
			}
			
		}
		cmg=cm;emg=em;ckg=ck;ekg=ek;starK=star;sq=sqbak;tokins+=take;
	}

if(skip&4 && (kingSW[sq]&(allenemy))!=0)                                       
	{						/////////SW//////////
		Kmask=kingSW[sq]&~((allpiece&(allpiece<<7|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK>>7))               
		{
			starK>>=7;
		   if(starK&allenemy)							     
				{
			   if(take){
				   		a=pursueKtakes(pbest+1,4,sq,e);
						if(a!=-infiniti)land=0;
						if(e<a)
							{e=a;*pbest=sqbak;*(pbest+1)=sq;}
				   break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK>>=7);ckg^=starK<<14;
				take++;sq-=14;sqland=sq;starland=starK;
				}
		  
			else{
				  ckg|=starK;ckg^=starK<<7;sq-=7;
				}
		if(take)              
				{ 
						a=pursueKtakes(pbest+1,10,sq,e);
						if(a!=-infiniti)land=0;
						if(e<a)
							{e=a;*pbest=sqbak;*(pbest+1)=sq;}
	
				}
			}
	if(land && take)     		 // only one take so lets send all the landings to negamax.
		{
			ckg^=starK;ckg|=starland;
			while(Kmask&starland)            
			{
				a=-negamax();				
				if(e<a){e=a;*pbest=sqbak;*(pbest+1)=sqland;}
				ckg^=starland;starland>>=7;sqland-=7;ckg|=starland;
			}
			
		}
		cmg=cm;emg=em;ckg=ck;ekg=ek;starK=star;sq=sqbak;tokins+=take;
	}
if(skip&8 && (kingSE[sq]&(allenemy))!=0)                                       
	{						/////////SE//////////
	  Kmask=kingSE[sq]&~((allpiece&(allpiece<<9|edge))|(allcomp));
	  take=0;land=1;						//starK>>=9;
	while(Kmask&(starK>>9))               
		{
		starK>>=9;
		   if(starK&allenemy)							     
				{
			   if(take){
				   		a=pursueKtakes(pbest+1,8,sq,e);//a=6000;
						if(a!=-infiniti)land=0;
						if(e<a)
							{e=a;*pbest=sqbak;*(pbest+1)=sq;}
				   break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK>>=9);ckg^=starK<<18;
				take++;sq-=18;sqland=sq;starland=starK;
				}
		  
			else{
				  ckg|=starK;ckg^=starK<<9;sq-=9;
				}
		if(take)              
				{ 
						a=pursueKtakes(pbest+1,5,sq,e);//a=6000;
						if(a!=-infiniti)land=0;
						if(e<a)
							{e=a;*pbest=sqbak;*(pbest+1)=sq;}
				}
			}
	if(land && take)			// only one take so lets send all the landings to negamax.
		{
			ckg^=starK;ckg|=starland;
			while(Kmask&starland)            
			{
				a=-negamax();				
				if(e<a){e=a;*pbest=sqbak;*(pbest+1)=sqland;}
				ckg^=starland;starland>>=9;sqland-=9;ckg|=starland; 
			}
			
		}
		cmg=cm;emg=em;ckg=ck;ekg=ek;tokins+=take;         //starK=star;sq=sqbak;
	}
	if(!tokins)return -infiniti;
	return e;
}

		// If skip==0 skip none ,1 skip NE   2 skip NW    3 skip SW		4 skip SE

float Game::gen_pursueKtakes(int skip,int sq)		 //sq should be starK
{	
	float e = -infiniti,a=-infiniti; 		//,a;             //      1s3 2s4 3s1 4s2
	uint64_t em,ek,allcomp,cm, ck,Kmask,star,starK,allpiece,allenemy,starland;
	int take,sqbak,land;
			sqbak=sq;		
			starK=star=mask[sq];
			ck=ckg;allenemy=emg|ekg;allcomp=cmg|ckg;cm=cmg;em=emg;ek=ekg;
			allpiece=(allenemy|allcomp)^starK;//(cmg|emg|(ckg^starK)|ekg);
if(skip&1 && (kingNE[sq]&(allenemy))!=0)                                       
	{				  			 /////////NE//////////
		Kmask=kingNE[sq]&~((allpiece&(allpiece>>7|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK<<7))               
			{
			starK<<=7;
		   if(starK&allenemy)							     
				{
			   if(take){
				   			a=gen_pursueKtakes(1,sq);
							if(a!=-infiniti)land=0;
							if(e<a)e=a;
				   break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK<<=7);ckg^=starK>>14;
				take++;sq+=14;starland=starK;
				}
		   
			else{
				  ckg|=starK;ckg^=starK>>7;sq+=7;
				}
		if(take)              
				{ 
							a=gen_pursueKtakes(10,sq);
							if(a!=-infiniti)land=0;
							if(e<a)e=a;
		
				}
			}
	
	if(land && take)     			// only one take so lets send all the landings to negamax.
		{
			ckg^=starK;ckg|=starland;
			while(Kmask&starland)              
			{
				a=-negamax();				
				if(e<a)e=a;
				ckg^=starland;starland<<=7;ckg|=starland;
			}
			 
		}
		cmg=cm;emg=em;ckg=ck;ekg=ek;starK=star;sq=sqbak;
	}
if(skip&2 && (kingNW[sq]&(allenemy))!=0)                                       
	{								 /////////NW//////////
	    Kmask=kingNW[sq]&~((allpiece&(allpiece>>9|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK<<9))               
			{
			starK<<=9;
		   if(starK&allenemy)							     
				{
			   if(take){
				   		a=gen_pursueKtakes(2,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
				   break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK<<=9);ckg^=starK>>18;
				take++;sq+=18;starland=starK;
				}
		   
		    else{
				  ckg|=starK;ckg^=starK>>9;sq+=9;
				}
		if(take)              
				{ 
				

						a=gen_pursueKtakes(5,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
				
				}
			}
	
	if(land && take)        		// only one take so lets send all the landings to negamax.
		{
			ckg^=starK;ckg|=starland;

			while(Kmask&starland)              
			{
				a=-negamax();				
				if(e<a)e=a;
				ckg^=starland;starland<<=9;ckg|=starland;
			}
			 
		}
		cmg=cm;emg=em;ckg=ck;ekg=ek;starK=star;sq=sqbak;
	}
if(skip&4 && (kingSW[sq]&(allenemy))!=0)                                       
	{								/////////SW//////////
	   Kmask=kingSW[sq]&~((allpiece&(allpiece<<7|edge))|(allcomp));
	   take=0;land=1;
	while(Kmask&(starK>>7))               
			{
			starK>>=7;
		   if(starK&allenemy)							     
				{
			   if(take){
				   		a=gen_pursueKtakes(4,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
				   break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK>>=7);ckg^=starK<<14;
				take++;sq-=14;starland=starK;
				}
		   
			else{
				  ckg|=starK;ckg^=starK<<7;sq-=7;
				}
		if(take)              
				{ 
						a=gen_pursueKtakes(10,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
				
				}
			}
	
	if(land && take)			// only one take so lets send all the landings to negamax.
		{
			ckg^=starK;ckg|=starland;
			while(Kmask&starland)              
			{
				a=-negamax();				
				if(e<a)e=a;
				ckg^=starland;starland>>=7;ckg|=starland;
			}
			 
		}
		cmg=cm;emg=em;ckg=ck;ekg=ek;starK=star;sq=sqbak;
	}
if(skip&8 && (kingSE[sq]&(allenemy))!=0)                                       
	{							/////////SE//////////
		Kmask=kingSE[sq]&~((allpiece&(allpiece<<9|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK>>9))               
			{
			starK>>=9;
		   if(starK&allenemy)							     
				{
			   if(take){
				   		a=gen_pursueKtakes(8,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
				   break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK>>=9);ckg^=starK<<18;
				take++;sq-=18;starland=starK;
				}
		  
			else{
				  ckg|=starK;ckg^=starK<<9;sq-=9;
				}
		if(take)              
				{ 
						a=gen_pursueKtakes(5,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
				}
			}

	if(land && take)		// only one take so lets send all the landings to negamax.
		{
			ckg^=starK;ckg|=starland;
			while(Kmask&starland)              
			{
				a=-negamax();				
				if(e<a)e=a;
				ckg^=starland;starland>>=9;ckg|=starland;
			}
			 
		}
		cmg=cm;emg=em;ckg=ck;ekg=ek;                 //starK=star;sq=sqbak;
	}

	return e;
}


float Game::genKtakes(float e)
{	
	float a=-infiniti;
	uint64_t to_map,em,ek,allcomp,cm, ck,Kmask,star,starK,allpiece,allenemy,starland;
	int sq,sqbak,take,land;

	to_map=ck=ckg;allenemy=emg|ekg;allcomp=cmg|ckg;cm=cmg;em=emg;ek=ekg;

	while (to_map) 
	{
			sq=sqbak=LSB(to_map);
			starK=star=mask[sq];       		// roll out a king
			to_map^=starK;			  	// and erase it.. one les king to do
			allpiece=(allenemy|allcomp)^starK;	//(cmg|allenemy|(ckg^starK));
						   
						  	 /////////NE//////////
	if((kingNE[sq]&(allenemy))!=0)
	{
		Kmask=kingNE[sq]&~((allpiece&(allpiece>>7|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK<<7))               
			{
			starK<<=7;
		   if(starK&allenemy)							     
				{
				if(take){
				   		a=gen_pursueKtakes(1,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
						if(e>=beta){cmg=cm;emg=em;ckg=ck;ekg=ek;return e;}
						if(alpha<a)alpha=a;
				   break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK<<=7);ckg^=starK>>14;
				take++;sq+=14;starland=starK;
				} 
		 
		 else   {
				  ckg|=starK;ckg^=starK>>7;sq+=7;
				}
		if(take)              
				{ 
						a=gen_pursueKtakes(10,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
						if(e>=beta){cmg=cm;emg=em;ckg=ck;ekg=ek;return e;}
						if(alpha<a)alpha=a;
				}
			}
			
	if(land && take)		// only one take so lets send all the landings to negamax.
		{
			ckg^=starK;ckg|=starland;
			while(Kmask&starland)               
			{
				a=-negamax();				
				if(e<a)e=a;
				if(e>=beta){cmg=cm;emg=em;ckg=ck;ekg=ek;return e;}
				if(alpha<a)alpha=a;
				ckg^=starland;starland<<=7;ckg|=starland;
			}
			
		}
		cmg=cm;emg=em;ckg=ck;ekg=ek;starK=star;sq=sqbak;
	}
							 /////////NW//////////      
		    
	if((kingNW[sq]&(allenemy))!=0)
	{
		Kmask=kingNW[sq]&~((allpiece&(allpiece>>9|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK<<9))               
			{
			starK<<=9;
		   if(starK&allenemy)							     
				{
			   if(take){
				   		a=gen_pursueKtakes(2,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
						if(e>=beta){cmg=cm;emg=em;ckg=ck;ekg=ek;return e;}
						if(alpha<a)alpha=a;
				   break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK<<=9);ckg^=starK>>18;
				take++;sq+=18;starland=starK;
				}
		 
		 else   {
				  ckg|=starK;ckg^=starK>>9;sq+=9;
				}
		if(take)              
				{ 
						a=gen_pursueKtakes(5,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
						if(e>=beta){cmg=cm;emg=em;ckg=ck;ekg=ek;return e;}
						if(alpha<a)alpha=a;
				}
			}
	
	if(land && take)    		 // only one take so lets send all the landings to negamax.
		{
			ckg^=starK;ckg|=starland;
			while(Kmask&starland)               
			{
				a=-negamax();				
				if(e<a)e=a;
				if(e>=beta){cmg=cm;emg=em;ckg=ck;ekg=ek;return e;}
				if(alpha<a)alpha=a;
				ckg^=starland;starland<<=9;ckg|=starland;
			}
			
		}
		cmg=cm;emg=em;ckg=ck;ekg=ek;starK=star;sq=sqbak;				
	}
					/////////SW//////////

	if((kingSW[sq]&(allenemy))!=0)
	{
		Kmask=kingSW[sq]&~((allpiece&(allpiece<<7|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK>>7))               
			{
			starK>>=7;
		   if(starK&allenemy)							     
				{
			   if(take){
				   		a=gen_pursueKtakes(4,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
						if(e>=beta){cmg=cm;emg=em;ckg=ck;ekg=ek;return e;}
						if(alpha<a)alpha=a;
				   break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK>>=7);ckg^=starK<<14;
				take++;sq-=14;starland=starK;
				}
		 
		 else   {
				  ckg|=starK;ckg^=starK<<7;sq-=7;
				}
		if(take)              
				{ 
						a=gen_pursueKtakes(10,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
						if(e>=beta){cmg=cm;emg=em;ckg=ck;ekg=ek;return e;}
						if(alpha<a)alpha=a;
				
				}
			}
	
	if(land && take)     			 // only one take so lets send all the landings to negamax.
		{
			ckg^=starK;ckg|=starland;
			while(Kmask&starland)               
			{
				a=-negamax();				
				if(e<a)e=a;
				if(e>=beta){cmg=cm;emg=em;ckg=ck;ekg=ek;return e;}
				if(alpha<a)alpha=a;
				ckg^=starland;starland>>=7;ckg|=starland;
			}
			
		}
		cmg=cm;emg=em;ckg=ck;ekg=ek;starK=star;sq=sqbak;
	}
					/////////SE//////////
	if((kingSE[sq]&(allenemy))!=0)
	{
		Kmask=kingSE[sq]&~((allpiece&(allpiece<<9|edge))|(allcomp));
		take=0;land=1;
	while(Kmask&(starK>>9))               
			{
			starK>>=9;
		   if(starK&allenemy)							     
				{
			   if(take){
				   		a=gen_pursueKtakes(8,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
						if(e>=beta){cmg=cm;emg=em;ckg=ck;ekg=ek;return e;}
						if(alpha<a)alpha=a;
				   break;
			   }
				emg&=~starK;ekg&=~starK;ckg|=(starK>>=9);ckg^=starK<<18;
				take++;sq-=18;starland=starK;
				}
		 
		 else   {
				  ckg|=starK;ckg^=starK<<9;sq-=9;
				}
		if(take)              
				{ 
						a=gen_pursueKtakes(5,sq);
						if(a!=-infiniti)land=0;
						if(e<a)e=a;
						if(e>=beta){cmg=cm;emg=em;ckg=ck;ekg=ek;return e;}
						if(alpha<a)alpha=a;
				}
			}

	if(land && take)  		// only one take so lets send all the landings to negamax.
		{
			ckg^=starK;ckg|=starland;
			while(Kmask&starland)               
			{
				a=-negamax();				
				if(e<a)e=a;
				if(e>=beta){cmg=cm;emg=em;ckg=ck;ekg=ek;return e;}
				if(alpha<a)alpha=a;
				ckg^=starland;starland>>=9;ckg|=starland;
			}
			
		}
		cmg=cm;emg=em;ckg=ck;ekg=ek;        //starK=star;sq=sqbak; 
	}
  }

	return e;
}

float Game::startKmove(float e)
{	
	float a=-infiniti;      // Removed since e is coming from outside.  e = -infiniti
	uint64_t to_map,ck,Kmask,star,starK,allpiece;
	int sq,sqbak;
	Hash thash;

	to_map=ck=ckg;

		while (to_map) 
		{
			sq=sqbak=LSB(to_map);
			starK=star=mask[sq];      	 // roll out a king
			to_map^=starK;			   // and erase it.. one les king to do
			allpiece=(cmg|emg|(ckg^starK)|ekg);
						   /////////NE//////////
			Kmask=(~allpiece)&validsq;
		while(Kmask&(starK<<=7))               
				{
					 ckg|=starK;ckg^=starK>>7;sq+=7;

					thash=hash[sq];
					if( hash[sq].cm==0xFFFFFFFFFFFFFFFFLL || 
						(hash[sq].cm==cmg && hash[sq].ck==ck	
						&& hash[sq].em==emg && hash[sq].ek==ekg))
					{
						hash[sq].num_repeats++;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						if(hash[sq].num_repeats<3)
						{
							a=-negamax();
						}
						else
						{
							a=0;
						}
					}
					else
					{
						hash[sq].num_repeats=1;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						a=-negamax();
					}
					hash[sq]=thash;
				 if(e<a)e=a;
				if(alpha<a)
				{alpha=a;*pbest=sqbak;*(pbest+1)=sq;}
				}
			ckg=ck;starK=star;sq=sqbak;

							 /////////NW//////////      
	while(Kmask&(starK<<=9))               
				{
				  ckg|=starK;ckg^=starK>>9;sq+=9;

					thash=hash[sq];
					if( hash[sq].cm==0xFFFFFFFFFFFFFFFFLL || 
						(hash[sq].cm==cmg && hash[sq].ck==ck	
						&& hash[sq].em==emg && hash[sq].ek==ekg))
					{
						hash[sq].num_repeats++;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						if(hash[sq].num_repeats<3)
						{
							a=-negamax();
						}
						else
						{
							a=0;
						}
					}
					else
					{
						hash[sq].num_repeats=1;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						a=-negamax();
					}
					hash[sq]=thash;

				 if(e<a)e=a;
				if(alpha<a)
				{alpha=a;*pbest=sqbak;*(pbest+1)=sq;}
				}
			ckg=ck;starK=star;sq=sqbak;

					/////////SW//////////

	while(Kmask&(starK>>=7))               
				{
		   		 ckg|=starK;ckg^=starK<<7;sq-=7;

					thash=hash[sq];
					if( hash[sq].cm==0xFFFFFFFFFFFFFFFFLL || 
						(hash[sq].cm==cmg && hash[sq].ck==ck	
						&& hash[sq].em==emg && hash[sq].ek==ekg))
					{
						hash[sq].num_repeats++;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						if(hash[sq].num_repeats<3)
						{
							a=-negamax();
						}
						else
						{
							a=0;
						}
					}
					else
					{
						hash[sq].num_repeats=1;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						a=-negamax();
					}
					hash[sq]=thash;

				 if(e<a)e=a;
				if(alpha<a)
				{alpha=a;*pbest=sqbak;*(pbest+1)=sq;}
				}
			ckg=ck;starK=star;sq=sqbak;

					/////////SE//////////
	while(Kmask&(starK>>=9))               
				{	
		   		  ckg|=starK;ckg^=starK<<9;sq-=9;

					thash=hash[sq];
					if( hash[sq].cm==0xFFFFFFFFFFFFFFFFLL || 
						(hash[sq].cm==cmg && hash[sq].ck==ck	
						&& hash[sq].em==emg && hash[sq].ek==ekg))
					{
						hash[sq].num_repeats++;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						if(hash[sq].num_repeats<3)
						{
							a=-negamax();
						}
						else
						{
							a=0;
						}
					}
					else
					{
						hash[sq].num_repeats=1;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						a=-negamax();
					}
					hash[sq]=thash;

				 if(e<a)e=a;
				if(alpha<a)
				{alpha=a;*pbest=sqbak;*(pbest+1)=sq;}
				}
			ckg=ck;					//starK=star;sq=sqbak; //??
		}
	return e;
}

float Game::genKmove(float e)		//e is not needed since global alpha replace "e" here
{	
	float a=-infiniti;
	uint64_t to_map,ck,Kmask,star,starK,allpiece;
	int sq,sqbak;
	Hash thash;

	to_map=ck=ckg;
		while (to_map) 
		{
			sq=sqbak=LSB(to_map);
			starK=star=mask[sq];			// roll out a king
			to_map^=starK;			   // and erase it.. one les king to do
			allpiece=(cmg|emg|(ckg^starK)|ekg);
						   
						   	/////////NE//////////
			Kmask=(~allpiece)&validsq;
		while(Kmask&(starK<<=7))               
					{
					ckg|=starK;ckg^=starK>>7;sq+=7;

						thash=hash[sq];
					if( hash[sq].cm==0xFFFFFFFFFFFFFFFFLL || 
						(hash[sq].cm==cmg && hash[sq].ck==ck	
						&& hash[sq].em==emg && hash[sq].ek==ekg))
					{
						hash[sq].num_repeats++;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						if(hash[sq].num_repeats<3)
						{
							a=-negamax();
						}
						else
						{
							a=0;
						}
					}
					else
					{
						hash[sq].num_repeats=1;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						a=-negamax();
					}
					hash[sq]=thash;

					if(a>=beta){ckg=ck;return a;}
					if(alpha<a)alpha=a;
					if(e<a)e=a;
					}
				ckg=ck;starK=star;sq=sqbak;				
							 /////////NW//////////      
	while(Kmask&(starK<<=9))               
				{
				  ckg|=starK;ckg^=starK>>9;sq+=9;

		thash=hash[sq];
					if( hash[sq].cm==0xFFFFFFFFFFFFFFFFLL || 
						(hash[sq].cm==cmg && hash[sq].ck==ck	
						&& hash[sq].em==emg && hash[sq].ek==ekg))
					{
						hash[sq].num_repeats++;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						if(hash[sq].num_repeats<3)
						{
							a=-negamax();
						}
						else
						{
							a=0;
						}
					}
					else
					{
						hash[sq].num_repeats=1;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						a=-negamax();
					}
					hash[sq]=thash;

					if(a>=beta){ckg=ck;return a;}
					if(alpha<a)alpha=a;
					if(e<a)e=a;
					}
				ckg=ck;starK=star;sq=sqbak;						
					/////////SW//////////

	while(Kmask&(starK>>=7))               
				{
		   		 ckg|=starK;ckg^=starK<<7;sq-=7;

		thash=hash[sq];
					if( hash[sq].cm==0xFFFFFFFFFFFFFFFFLL || 
						(hash[sq].cm==cmg && hash[sq].ck==ck	
						&& hash[sq].em==emg && hash[sq].ek==ekg))
					{
						hash[sq].num_repeats++;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						if(hash[sq].num_repeats<3)
						{
							a=-negamax();
						}
						else
						{
							a=0;
						}
					}
					else
					{
						hash[sq].num_repeats=1;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						a=-negamax();
					}
					hash[sq]=thash;

					if(a>=beta){ckg=ck;return a;}
					if(alpha<a)alpha=a;
					if(e<a)e=a;
					}
				ckg=ck;starK=star;sq=sqbak;			
					/////////SE//////////
	while(Kmask&(starK>>=9))               
				{	
		   		  ckg|=starK;ckg^=starK<<9;sq-=9;

		thash=hash[sq];
					if( hash[sq].cm==0xFFFFFFFFFFFFFFFFLL || 
						(hash[sq].cm==cmg && hash[sq].ck==ck	
						&& hash[sq].em==emg && hash[sq].ek==ekg))
					{
						hash[sq].num_repeats++;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						if(hash[sq].num_repeats<3)
						{
							a=-negamax();
						}
						else
						{
							a=0;
						}
					}
					else
					{
						hash[sq].num_repeats=1;
						hash[sq].cm=cmg;hash[sq].ck=ck;hash[sq].em=emg;hash[sq].ek=ekg;
						a=-negamax();
					}
					hash[sq]=thash;

					if(a>=beta){ckg=ck;return a;}
					if(alpha<a)alpha=a;
					if(e<a)e=a;
					}
				ckg=ck;		       //starK=star;sq=sqbak;
		}
	return e;
}
/////////////////////////////////////////////////////////////////////////////////////
//
//
//                    BP_NET
////////////////////////////////////////////////////////////////////////////////////////

void Game::TrainA(float d){
	ppvalidmask=validmask[playingA];
	num=0;
	net[32]=0;

			for(j=0;j<32;j++)
			{
				 if(cmg&ppvalidmask[j])
				 {
				 		net[j] = fWeights[0][0][32][j] + fWeights[1][0][32][j] + fWeights[2][0][32][j] + fWeights[3][0][32][j];
						type[num]=0;sq[num]=j;
						
						net[j]+=fWeights[0][0][j][j];
						for(k=0;k<num;k++)
						{
							net[j]+=fWeights[type[k]][0][sq[k]][j];
							net[sq[k]]+=fWeights[0][type[k]][j][sq[k]];
						}
						num++;
				 } 				//compmen
			else	 if(emg&ppvalidmask[j])
				 {
				 		net[j] = fWeights[0][1][32][j] + fWeights[1][1][32][j] + fWeights[2][1][32][j] + fWeights[3][1][32][j];
						type[num]=1;sq[num]=j;
						
						net[j]+=fWeights[1][1][j][j];
						for(k=0;k<num;k++)
						{
							net[j]+=fWeights[type[k]][1][sq[k]][j];
							net[sq[k]]+=fWeights[1][type[k]][j][sq[k]];
						}
						num++;
				 }					 //enemymen
			else	 if(ckg&ppvalidmask[j])
				 {
				 		net[j] = fWeights[0][2][32][j] + fWeights[1][2][32][j] + fWeights[2][2][32][j] + fWeights[3][2][32][j];
						type[num]=2;sq[num]=j;
						
						net[j]+=fWeights[2][2][j][j];
						for(k=0;k<num;k++)
						{
							net[j]+=fWeights[type[k]][2][sq[k]][j];
							net[sq[k]]+=fWeights[2][type[k]][j][sq[k]];
						}
						num++;
				 }						 //compking
			else	 if(ekg&ppvalidmask[j])
				 {
				 		net[j] = fWeights[0][3][32][j] + fWeights[1][3][32][j] + fWeights[2][3][32][j] + fWeights[3][3][32][j];
						type[num]=3;sq[num]=j;
						
						net[j]+=fWeights[3][3][j][j];
						for(k=0;k<num;k++)
						{
							net[j]+=fWeights[type[k]][3][sq[k]][j];
							net[sq[k]]+=fWeights[3][type[k]][j][sq[k]];
						}
						num++;
				 } 						//enemyking	

			}

			r=num&3;
			while(r--)
			{
				netout[sq[r]]=Sigmoid(net[sq[r]]);		
				net[32]+=netout[sq[r]]*fWeights[type[r]][type[r]][sq[r]][32];
			}

			for(k=num&3;k<num;k+=4)
			{
				// Use the hardlimiter function - the Sigmoid.
				netout[sq[k]]=Sigmoid(net[sq[k]]);		
				net[32]+=netout[sq[k]]*fWeights[type[k]][type[k]][sq[k]][32];

				netout[sq[k+1]]=Sigmoid(net[sq[k+1]]);		
				net[32]+=netout[sq[k+1]]*fWeights[type[k+1]][type[k+1]][sq[k+1]][32];

				netout[sq[k+2]]=Sigmoid(net[sq[k+2]]);		
				net[32]+=netout[sq[k+2]]*fWeights[type[k+2]][type[k+2]][sq[k+2]][32];

				netout[sq[k+3]]=Sigmoid(net[sq[k+3]]);		
				net[32]+=netout[sq[k+3]]*fWeights[type[k+3]][type[k+3]][sq[k+3]][32];
			}

/*
			for(k=0;k<num;k++)
			{
				// Use the hardlimiter function - the Sigmoid.
				netout[sq[k]]=Sigmoid(net[sq[k]]);		
				net[32]+=netout[sq[k]]*fWeights[type[k]][type[k]][sq[k]][32];
			}
*/


	netout[32]=Sigmoid(net[32]);

	deltasout =BP_LEARNING*(1-netout[32]*netout[32])*(d-netout[32])/2;

	for(j=0;j<num;j++)
	{
			deltas =(1-netout[sq[j]]*netout[sq[j]])*fWeights[type[j]][type[j]][sq[j]][32]*(deltasout)/2;

			fWeights[type[j]][type[j]][sq[j]][32]+=netout[sq[j]] * deltasout;

			//Adjust the shift
			fWeights[0][type[j]][32][sq[j]]+=deltas;
			fWeights[1][type[j]][32][sq[j]]+=deltas;
			fWeights[2][type[j]][32][sq[j]]+=deltas;
			fWeights[3][type[j]][32][sq[j]]+=deltas;

			for(k=0;k<num;k++)
			{
				fWeights[type[k]][type[j]][sq[k]][sq[j]]+=deltas;
			}

	}


}

float Game::RunA() {
			// I just copied and pasted the code from the Train() function,
			// so see there for the necessary documentation.
			//uint64_t *ppvalidmask;
	out=0;		//memset(neti,0x0,128);
	ppvalidmask=validmask[!playingA];

	num=0;

							//generic for loop
			for(j=0;j<32;j++)
			{
				 if(emg&ppvalidmask[j])
				 {
				 		neti[j] = fWeights[0][0][32][j] + fWeights[1][0][32][j] + fWeights[2][0][32][j] + fWeights[3][0][32][j];
						type[num]=0;sq[num]=j;
						
						neti[j]+=fWeights[0][0][j][j];
						for(k=0;k<num;k++)
						{
							neti[j]+=fWeights[type[k]][0][sq[k]][j];
							neti[sq[k]]+=fWeights[0][type[k]][j][sq[k]];
						}
						num++;
				 }				 //compmen
			else	 if(cmg&ppvalidmask[j])
				 {
				 		neti[j] = fWeights[0][1][32][j] + fWeights[1][1][32][j] + fWeights[2][1][32][j] + fWeights[3][1][32][j];
						type[num]=1;sq[num]=j;
						
						neti[j]+=fWeights[1][1][j][j];
						for(k=0;k<num;k++)
						{
							neti[j]+=fWeights[type[k]][1][sq[k]][j];
							neti[sq[k]]+=fWeights[1][type[k]][j][sq[k]];
						}
						num++;
				 } 					//enemymen
			else	 if(ekg&ppvalidmask[j])
				 {
				 		neti[j] = fWeights[0][2][32][j] + fWeights[1][2][32][j] + fWeights[2][2][32][j] + fWeights[3][2][32][j];
						type[num]=2;sq[num]=j;
						
						neti[j]+=fWeights[2][2][j][j];
						for(k=0;k<num;k++)
						{
							neti[j]+=fWeights[type[k]][2][sq[k]][j];
							neti[sq[k]]+=fWeights[2][type[k]][j][sq[k]];
						}
						num++;
				 } 					//compking
			else	 if(ckg&ppvalidmask[j])
				 {
				 		neti[j] = fWeights[0][3][32][j] + fWeights[1][3][32][j] + fWeights[2][3][32][j] + fWeights[3][3][32][j];
						type[num]=3;sq[num]=j;
						
						neti[j]+=fWeights[3][3][j][j];
						for(k=0;k<num;k++)
						{
							neti[j]+=fWeights[type[k]][3][sq[k]][j];
							neti[sq[k]]+=fWeights[3][type[k]][j][sq[k]];
						}
						num++;
				 }					 //enemyking	

			}


			r=num&3;
			while(r--)
			{
				out+=Sigmoid(neti[sq[r]])*fWeights[type[r]][type[r]][sq[r]][32];
			}

			for(k=num&3;k<num;k+=4)
			{
				// Use the hardlimiter function - the Sigmoid.
				out+=Sigmoid(neti[sq[k]])*fWeights[type[k]][type[k]][sq[k]][32];
				out+=Sigmoid(neti[sq[k+1]])*fWeights[type[k+1]][type[k+1]][sq[k+1]][32];
				out+=Sigmoid(neti[sq[k+2]])*fWeights[type[k+2]][type[k+2]][sq[k+2]][32];
				out+=Sigmoid(neti[sq[k+3]])*fWeights[type[k+3]][type[k+3]][sq[k+3]][32];
			}

/*
			for(k=0;k<num;k++)
			{
						// Use the hardlimiter function - the Sigmoid.
				out+=Sigmoid(neti[sq[k]])*fWeights[type[k]][type[k]][sq[k]][32];
			}
*/

			return (Sigmoid(out)*winlose);

}

float Game::Sigmoid(float num) {
	return (float)((2/(1+exp(-num)))-1);
}
/*
float engine::eval() {

	float e;
//	e=popcount(emg)+3*popcount(ekg)-popcount(cmg)-3*popcount(ckg);
	e=(popcount(emg)-popcount(cmg))+3.f*(popcount(ekg)-popcount(ckg));
	return (rand()&0x7)+(e*8);
}

*/
int Game::LSB(uint64_t  value)
{
int i;
uint64_t skim=0x1LL;
	for(i=0;i<=63;i++)
		{
		if(value&skim)break;
		skim<<=1;
		}
return i;
}

int Game::MSB(uint64_t  value)
{
int i;
uint64_t skim=0x8000000000000000LL;
	for(i=63;i>=0;i--)
		{
		if(value&skim)break;
		skim>>=1;
		}
return i;
}
//#include "game.moc"
