/***************************************************************************
 *   Copyright (C) 2000 2008 by Michael Rapaport   *
 *   rucko4t@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <stdlib.h>
#include <kstandarddirs.h>
#include "draught.h"
#include "draughtview.h"
#include "game.h"
#include <qlabel.h>
#include <kmessagebox.h>
#include <qmutex.h>
#include <qimage.h>
#include <kaction.h>
#include <kfile.h>
#include <kstatusbar.h>
#include <kpopupmenu.h>
#include <kmenubar.h>
#include <qwmatrix.h>
#include <kapp.h>
#include <qdatetime.h>
#include <kactionclasses.h>
#include <kfiledialog.h>

KToggleAction *First,*Speed;
KRadioAction *Novice,*Average,*Good,*Expert;
int half_inc,wth,xr,yr,yh=3,bm,deskHight;
int first=1;
extern QMutex playing;
extern int infinitie;
QImage mana_fn,kinga_fn,manb_fn,kingb_fn,boardd_fn;
QString paht,localpaht,ssnd;
QString current_brain;
draughtView *pFig;
Game *mike;

QDataStream& operator << (QDataStream& s, bool v)
{
  Q_UINT8 t = v;
  s << t;
  return s;
}

QDataStream& operator >> (QDataStream& s, bool& v)
{
  Q_UINT8 t;
  s >> t;
  v = t;
  return s;
}

draught::draught() : KMainWindow()
{
  				// create canvas and canvas view 
				//QColor  bak(50,150,150); ///blue
				//QColor  bak(150,100,150); QColor  bak(50,100,150);

	QColor  bak(200,200,200);
	paht = locate("data","draught/");
        localpaht  = getenv ("HOME");
        localpaht+="/.Draught/" ;

//KMessageBox::information( this, paht,"paht" );

QDir m(localpaht);

if(!m.exists())
{
m.mkdir(localpaht);

}
	ssnd = paht+"mysound/theSound";

	menuFile = new KPopupMenu( this );
	menuEdit = new KPopupMenu( this );
	menuOptions  = new KPopupMenu( this );
	menuLevels  = new KPopupMenu( this );
	
	menuBar()->insertItem( "&File", menuFile );
	menuBar()->insertItem( "&Edit", menuEdit );
	menuBar()->insertItem( "&Options", menuOptions );
	menuBar()->insertItem( "&Levels", menuLevels );
	menuBar()->insertItem( "&Help", helpMenu() );
	
	
	KAction *actionOpen = KStdAction::open(this, SLOT(fileOpen()), 0);
	KAction *actionSave = KStdAction::save(this, SLOT(fileSave()), 0);

	actionOpen->plug( menuFile );
	actionSave->plug( menuFile );
	
	menuFile->insertSeparator();

	KAction *actionNew = new KAction( "&newGame", QIconSet(QPixmap(paht+"myicon/n.png")), CTRL+Key_N, this, SLOT(newView()), this, "A");
	KAction *actionReset = new KAction( "&ResetScore",0, CTRL+Key_R, this, SLOT(resetScore()), this, "B");
	KAction *actionBloat = new KAction( "Bloat", 0, "", this, SLOT(bloatist()), this, "C");
	KAction *actionShrink = new KAction( "Shrink",0, "", this, SLOT(shrinkist()), this, "D");
	
	KAction *actionBack = new KAction( "take_back", 0, CTRL+Key_Left, this, SLOT(take_back()), this, "E");
	KAction *actionForward = new KAction( "forward", 0, CTRL+Key_Right, this, SLOT(forward()), this, "F");
	KAction *actionTrain = new KAction( "train", 0, "", this, SLOT(train()), this, "H");

	KAction *actionScramble = new KAction( "Scramble_brain", 0, "", this, SLOT(scramblist()), this, "I");

	KAction *actiondef_Brain = new KAction( "default_brain", 0, "", this, SLOT(def_Brain()), this, "J");

	KAction *actionPlay = new KAction( "cheat", QIconSet(QPixmap(paht+"myicon/p.png")), Key_P, this, SLOT(play()), this, "K");
	KAction *actionStop = new KAction( "stop",QIconSet(QPixmap(paht+"myicon/x.png")), CTRL+Key_C, this, SLOT(stop()), this, "L");
	KAction *actionSound = new KAction( "toggleSound", QIconSet(QPixmap(paht+"myicon/m.png")), CTRL+Key_M, this, SLOT(mute()), this, "M");

	First = new KToggleAction("cpuFirst","",this,SLOT(newView()),this);
	First->setChecked(FALSE);
	First->plug(menuOptions);

	Speed = new KToggleAction("speed","",this,SLOT(changeSpeed()),this);
	Speed->setChecked(FALSE);
	Speed->plug(menuFile);


	Novice = new KRadioAction("novice","",this,SLOT(changeLevel()),this);
	Novice->setChecked(FALSE);
        Novice->setExclusiveGroup ("hardness");
	Novice->plug(menuLevels);

	Average = new KRadioAction("average","",this,SLOT(changeLevel()),this);
	Average->setChecked(FALSE);
        Average->setExclusiveGroup ("hardness");
	Average->plug(menuLevels);

	Good = new KRadioAction("good","",this,SLOT(changeLevel()),this);
	Good->setChecked(TRUE);
        Good->setExclusiveGroup ("hardness");
	Good->plug(menuLevels);

	Expert = new KRadioAction("expert","",this,SLOT(changeLevel()),this);
	Expert->setChecked(FALSE);
        Expert->setExclusiveGroup ("hardness");
	Expert->plug(menuLevels);

	actionReset->plug(menuFile);
	actionBloat->plug(menuEdit);
	actionShrink->plug(menuEdit);
	
	actionBack->plug(menuEdit);
	actionForward->plug(menuEdit);
	actionTrain->plug(menuEdit);
        actionScramble->plug(menuEdit);
        actiondef_Brain->plug(menuEdit);


	actionNew->plug(toolBar());
	actionStop ->plug(toolBar());
	actionSound->plug(toolBar());
	actionPlay->plug(toolBar());
        wth = (int) (deskHight * .7);

setIcon(QPixmap("hi16-app-draught.png"));

boardd_fn =  QPixmap(paht+"pics/board1.png");

	boardd_fn=boardd_fn.scaleWidth( wth );
 
	mana_fn = QPixmap(paht+"pics/mana1.png");
	mana_fn=mana_fn.scaleWidth ( (int)(wth/11.5 ));

	kinga_fn = QPixmap(paht+"pics/kinga1.png");
	kinga_fn=kinga_fn.scaleWidth ( (int)(wth/11.5) );

	manb_fn = QPixmap(QString(paht+"pics/manb1.png"));
	manb_fn=manb_fn.scaleWidth ((int)( wth/11.5 ));

	kingb_fn = QPixmap(paht+"pics/kingb1.png");
	kingb_fn=kingb_fn.scaleWidth ( (int)(wth/11.5 ));

        QCanvas  *canvas  = new QCanvas( this );
	pFig = new draughtView( canvas, this);
        mike = new Game(paht,localpaht);
	setCentralWidget( pFig );
						//pFig->setBackgroundColor ( const QColor & c )
canvas->setBackgroundColor(bak);
	pFig->setVScrollBarMode(QScrollView::AlwaysOff);
	pFig->setHScrollBarMode(QScrollView::AlwaysOff);
	canvas->resize((int)(wth*1.4),wth+10); 
						//resize(sizeHint());
setFixedSize(sizeHint());
	pFig->show();
	bm = height()-canvas->height();
	statusBar()->message("paht");
	init();
}

draught::~draught(){
if(pFig != NULL)delete pFig;
if(mike != NULL)delete mike;
}

void draught::init()
{
	pFig->inc=wth/8;half_inc=pFig->inc/2;
  	pFig->border=5;
	pFig->ofsetxy=(int)(pFig->inc/5.5 + 5);          //6.5 + 5;   ///ofset plus //border
        pFig->muted=0;
        pFig->Amenfirst= First->isChecked();
	if(pFig->Amenfirst)pFig->pieces.black_on_top=1;
	else	pFig->pieces.black_on_top=0;
	changeLevel();
        pFig->speed = Speed->isChecked();
        pFig->myBoard();
        pFig->initialiser(1);
//  statusBar()->message(QString("  Syrus at depth --  "   +  QString::number(hard,10)));
}

void draught::newView()
{ 					 //New Game
	if(playing.locked())return;
        pFig->Amenfirst= First->isChecked();
	if(pFig->Amenfirst)pFig->pieces.black_on_top=1;
	else	pFig->pieces.black_on_top=0;
	pFig->initialiser(1);
        statusBar()->message(QString("  Syrus in control -- Level = "+ current_brain ));
}

void draught::changeLevel()
{
if(playing.locked())return;
        pFig->Amenfirst = First->isChecked();
	     if(Expert->isChecked()){mike->hard=10;current_brain="expert";}
	else if(Good->isChecked()){mike->hard=8;current_brain="good";}
	else if(Average->isChecked()){mike->hard=4;current_brain="average";}
	else if(Novice->isChecked()){mike->hard=2;current_brain="novice";}
	mike->loadBrain(current_brain);
	if(!first) pFig->show_current_Brain();
	else first=0;
  statusBar()->message(QString("  Syrus in control -- Level = "+ current_brain ));
}

void draught::changeSpeed()
{
        pFig->speed = Speed->isChecked();
}

void draught::resetScore(){
	pFig->reset_score();
}

void draught::shrinkist(){
	if(playing.locked())return;
	if(yh<=0)return;
	yh--;
   	QWMatrix m = pFig->worldMatrix();
	yr=(int)(pFig->contentsHeight()*.75);
	xr=(int)(pFig->contentsWidth()*.75);
	m.scale( .75,.75);
        pFig->resize(xr,yr);
	resize(xr,yr+bm);
	pFig->setWorldMatrix( m );
}

void draught::bloatist(){
	if(playing.locked())return;
	if(yh>=3)return;
	yh++;
   	QWMatrix m = pFig->worldMatrix();
	yr=(int)(pFig->contentsHeight()*1.33);
	xr=(int)(pFig->contentsWidth()*1.33);
	m.scale( 1.33,1.33);
	pFig->resize(xr,yr);
	resize(xr,yr+bm);
	pFig->setWorldMatrix( m );
}

bool draught::fileOpen()
{
  // get user to select filename and location
unsigned int *pu;
if(playing.locked())return false;

 QString fileName = KFileDialog::getOpenFileNameWId ("", "*.drg",0,0); 

  if (fileName.isEmpty()) return false;

 				 // open the file and check we can read from it
  QFile m(fileName);
  if (!m.open(IO_ReadOnly))
  {
    statusBar()->message(QString("Failed to open '%1'").arg(fileName));
    return false;
  }
	QDataStream s (&m);
		pu=pFig->pieces.Hist;
		s>>pFig->pieces.lasthist;
		s>>pFig->pieces.curhist;
		s>>pFig->pieces.black_on_top;

		pFig->plastHist=pu+pFig->pieces.lasthist;  
		pFig->phist=pu+pFig->pieces.curhist;

		s>>pFig->pieces.PlayAmen;
		s>>pFig->pieces.cpturn;
		s>>pFig->pieces.compmen;
		s>>pFig->pieces.enemymen;
		s>>pFig->pieces.compkings;
		s>>pFig->pieces.enemykings;

		while(pu<=pFig->plastHist){s>>*pu;pu++;}

            	m.close();
  		statusBar()->message(QString("Loaded '%1'").arg(fileName));
	pFig->initialiser(0);
	pFig->stall();
  return true;
}

bool draught::fileSave()
{
unsigned int *pu,*p_end;
if(playing.locked())return false;
 QString fileName = KFileDialog::getSaveFileNameWId ("", "*.drg",0,0); 

  if (fileName.isEmpty()){ return false;}

  QFile m(fileName);
  if (!m.open(IO_WriteOnly))
  {
    statusBar()->message(QString("Failed to save '%1'").arg(fileName));
    return false;
  }
	QDataStream s (&m);

		pFig->pieces.lasthist=pFig->plastHist-pFig->pieces.Hist;
		pFig->pieces.curhist=pFig->phist-pFig->pieces.Hist;
		pu=pFig->pieces.Hist;
                p_end=pu+pFig->pieces.lasthist;

		s<<(unsigned int)pFig->pieces.lasthist;
		s<<(unsigned int)pFig->pieces.curhist;

		s<<(bool) pFig->pieces.black_on_top;
		s<<(bool) pFig->pieces.PlayAmen;
		s<<(bool) pFig->pieces.cpturn;

		s<<(uint64_t)pFig->pieces.compmen;
		s<<(uint64_t)pFig->pieces.enemymen;
		s<<(uint64_t)pFig->pieces.compkings;
		s<<(uint64_t)pFig->pieces.enemykings;
		while(pu<=p_end){s<<(unsigned int)*pu;pu++;}
        pFig->stall();
	m.close();

  statusBar()->message(QString("Saved to '%1'").arg(fileName));
  return true;
}

void draught::take_back(){
if(playing.locked())return;
pFig->OnBack();
}

void draught::forward(){
if(playing.locked())return;
pFig->OnForward();
}

void draught:: train(){
if(playing.locked())return;
if(pFig->OnTrain()){
menuEdit->setDisabled (TRUE);
menuOptions->setDisabled (TRUE);
menuLevels->setDisabled (TRUE);
}
statusBar()->message(QString("  Syrus in control -- Level = "+ current_brain ));
} 

void draught:: play(){
if(playing.locked())return;
pFig->OnPlay();
} 

void draught:: mute(){
if(playing.locked())return;
pFig->muted=!pFig->muted;
}

void draught:: stop(){

if(!playing.locked())return;
  mike->dep=-infinitie;pFig->killer=1;
  menuEdit->setDisabled (FALSE);
  menuOptions->setDisabled (FALSE);
  menuLevels->setDisabled (FALSE);
  statusBar()->message(QString( "Training stopped"));
}

void draught::clear()
{
if(playing.locked())return;
    pFig->clear();
}

void draught::scramblist()
{
if(playing.locked())return;
    pFig->OnScramble();
  statusBar()->message(QString("  Syrus in control -- Level = "+ current_brain ));
}

void draught::def_Brain()
{
if(playing.locked())return;
    pFig->On_def_Brain();
  statusBar()->message(QString("  Syrus in control -- Level = "+ current_brain ));
}

void draught::closeEvent( QCloseEvent *e )
{
if(playing.locked())stop();
else QMainWindow::closeEvent(e);
}

#include "draught.moc"

