#include "fontsetup.h"
#include "settings.h"
#include <kfontdialog.h>
#include <qlistbox.h>
#include <qtextview.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#define Inherited fontsetupData

fontsetup::fontsetup(QWidget* parent,const char* name)
    :Inherited( parent, name ),fixFont("fixed"),nonpropFont("helvetica")
{
    m_FontTypeList->insertItem("Non proportional font");
    m_FontTypeList->insertItem("Proportional font");
    fixFont = GlobalSettings.get_fixed_font();
    nonpropFont=GlobalSettings.get_nonprop_font();
    m_FontTypeList->setCurrentItem(0);
}


fontsetup::~fontsetup()
{
}

void fontsetup::Type_Selected(int i)
{
    last_selected = i;
    switch (i) {
    case 1:
        m_KFontChooser->setFont(fixFont,true);
        break;
    case 0:
    default:
        m_KFontChooser->setFont(nonpropFont);
        break;
    }
}

void fontsetup::selected_Font(const QFont& fnt)
{
    if (last_selected == 0) {
        nonpropFont = fnt;
        emit snonpropFont(nonpropFont);
    } else {
        fixFont = fnt;
        emit sfixFont(fixFont);
    }
}
