#include <qpixmap.h>

#include "compoundkeydlg.h"
#include "helpers/stringhelper.h"
#include "helpers/qt_stl_string.h"
#include <qmessagebox.h>
#include <kapp.h>
#include <klocale.h>
#include <qframe.h>                                                             
#include <qlabel.h>                                                             
#include <qlineedit.h>                                                          
#include <qlistbox.h>                                                           
#include <qpushbutton.h>                                                        
#include <qradiobutton.h>                                                       
#include <qlayout.h>                                                            
#include <qvariant.h>                                                           
#include <qtooltip.h>                                                           
#include <qwhatsthis.h>                                                         
#include <qimage.h>                                                             
#include <qpixmap.h> 
#include <algorithm>

#include "stringres.h"

#define Inherited CCompoundKeyData

CCompoundKeyDlg::CCompoundKeyDlg(QWidget* parent,const char* name)
    :Inherited( parent, name,true )
{
    setCaption( "Create compound key" );
    int_col_list = 0;
    int_key_list = 0;
    CurrentKey=0;
    AddKeyButton->setEnabled(FALSE);
    DeleteKeyButton->setEnabled(FALSE);
    ToKeyButton->setEnabled(FALSE);
    FromKeyButton->setEnabled(FALSE);
}

CCompoundKeyDlg::~CCompoundKeyDlg()
{
}

void CCompoundKeyDlg::set_Columns(ColumnList*col_list,KeyList*key_list)
{
    int_col_list = col_list;
    int_key_list = key_list;
    KeyList_iterator key_iterator;
    if (!col_list || !key_list)
        return;
    for (key_iterator = int_key_list->begin();key_iterator != int_key_list->end();++key_iterator) {
        if (key_iterator->is_compound()) {
            KeysList->insertItem(key_iterator->get_name());
        }
    }
    ColumnList_iterator col_iterator;
    for (col_iterator = int_col_list->begin();col_iterator != int_col_list->end();++col_iterator) {
        TableColumns->insertItem(col_iterator->get_name().c_str());
    }
}

void CCompoundKeyDlg::AddKey()
{
    QString name;
    name = KeyNameEdit->text();
    CKeyDescriptor temp_key;

    if (name.isEmpty())
        return;
    temp_key.set_name(name.latin1());

    if (std::find(int_key_list->begin(),int_key_list->end(),temp_key)!=int_key_list->end()) {
        QString info;
        info = GET_TEXT(0);
        info+=" ";
        info+=name;
        info+=" ";
        info+=GET_TEXT(1);
        QMessageBox::warning(this,GET_TEXT(2),info);
        return;
    }
    temp_key.set_compound(true);
    int_key_list->push_back(temp_key);
    int j = int_key_list->size()-1;
    CurrentKey = (&(*int_key_list)[j]);
#if 0
    CurrentKey = --(int_key_list->end());
#endif
    //CurrentKey = int_key_list->rbegin();
    KeysList->insertItem(name);
    
    KeysList->setCurrentItem(KeysList->count()-1);
    UniqueSelected();
    UniqueType->setChecked(TRUE);
}

void CCompoundKeyDlg::DeleteKey()
{
    if (!CurrentKey)
        return;
#if 0
    CKeyDescriptor* find_key;
#endif
    QString name;
    int pos;
    pos = KeysList->currentItem();
    if (pos == -1)
        return;
    name = KeysList->text(pos);
    if (name.isEmpty())
        return;
    KeyList_iterator key_iterator;
    for (key_iterator = int_key_list->begin(); key_iterator != int_key_list->end();++key_iterator) {
#if 0
        find_key = key_iterator;
#endif
        if (*key_iterator == name.latin1()) {
            key_iterator = int_key_list->erase(key_iterator);
            KeysList->removeItem(pos);
            return;
        }
    }
}

void CCompoundKeyDlg::KeyTextReturn()
{
    if (AddKeyButton->isEnabled() == FALSE)
        return;
    AddKey();
}

void CCompoundKeyDlg::IndexSelected()
{
    if (!CurrentKey)
        return;
    CurrentKey->setType(CKeyDescriptor::INDEX);
    PrimaryType->setChecked(FALSE);
    UniqueType->setChecked(FALSE);
}

void CCompoundKeyDlg::UniqueSelected()
{
    if (!CurrentKey)
        return;
    CurrentKey->setType(CKeyDescriptor::UNIQUE);
    PrimaryType->setChecked(FALSE);
    IndexType->setChecked(FALSE);
}

void CCompoundKeyDlg::KeyFieldSelected(int which)
{
    CurrentKey = 0;
    KeyColumns->clear();
    DeleteKeyButton->setEnabled(FALSE); 
    if (which < 0) {
        return;
    }
    QString Item;
    Item = KeysList->text(which);
    if (Item.length() == 0)
        return;
    KeyList_iterator key_iterator;
    for (key_iterator = int_key_list->begin();key_iterator != int_key_list->end();++key_iterator) {
        if (*key_iterator == Item.latin1()) {
            break;
        }
    }
    CurrentKey = &(*key_iterator);
    if (key_iterator == int_key_list->end()) {
        CurrentKey = 0;
        return;
    }
    DeleteKeyButton->setEnabled(TRUE);
    switch(key_iterator->getType()) {
    case CKeyDescriptor::PRIMARY:
        PrimaryType->setChecked(TRUE);
        UniqueType->setChecked(FALSE);
        IndexType->setChecked(FALSE);
        break;
    case CKeyDescriptor::UNIQUE:
        PrimaryType->setChecked(FALSE);
        UniqueType->setChecked(TRUE);
        IndexType->setChecked(FALSE);
        break;
    case CKeyDescriptor::INDEX:
        PrimaryType->setChecked(FALSE);
        UniqueType->setChecked(FALSE);
        IndexType->setChecked(TRUE);
        break;
    default:
        PrimaryType->setChecked(FALSE);
        UniqueType->setChecked(FALSE);
        IndexType->setChecked(FALSE);
        break;
    }
    if (key_iterator->column_count() != 0) {
        pairIlist col_list = key_iterator->get_ColList();
        pairIlist::iterator iter = col_list.begin();
        for (;iter!=col_list.end();++iter) {
            KeyColumns->insertItem(iter->first.c_str());
        }
    }
    int i = TableColumns->currentItem();
    TableColumnsSelected(i);
}

void CCompoundKeyDlg::TableColumnsSelected(int which)
{
    if (which < 0 || !CurrentKey) {
        ToKeyButton->setEnabled(FALSE);
        return;
    }
    QString text;
    text = TableColumns->text(which);
    for (unsigned int i = 0; i < KeyColumns->count();i++){
        if (Caseequ()(text.latin1(),KeyColumns->text(i).latin1())) {
            ToKeyButton->setEnabled(FALSE);
            return;
        }
    }
    ToKeyButton->setEnabled(TRUE);
}

void CCompoundKeyDlg::KeyColumnsSelected(int which)
{
    if (!CurrentKey || which <0) {
        FromKeyButton->setEnabled(FALSE);
        return;
    }
    FromKeyButton->setEnabled(TRUE);
}

void CCompoundKeyDlg::AddToKey()
{
    if (!CurrentKey)
        return;
    int pos;
    QString text;
    pos = TableColumns->currentItem();
    if (pos == -1)
        return;
    text = TableColumns->text(pos);
    if (CurrentKey->contains_column_name(text.latin1()))
        return;
    KeyColumns->insertItem(text);
    CurrentKey->add_column_name(QT_TO_STL_STRING(text));
}

void CCompoundKeyDlg::KeyNameChanged(const QString&text)
{
    if (text.length() == 0) {
        AddKeyButton->setEnabled(FALSE);
        return;
    }
    for (unsigned int i = 0; i < KeysList->count();i++){
        if (Caseequ()(text.latin1(),KeysList->text(i).latin1())) {
            AddKeyButton->setEnabled(FALSE);
            return;
        }
    }
    AddKeyButton->setEnabled(TRUE);
}

void CCompoundKeyDlg::PrimarySelected()
{
    if (!CurrentKey)
        return;
    CurrentKey->setType(CKeyDescriptor::PRIMARY);
    UniqueType->setChecked(FALSE);
    IndexType->setChecked(FALSE);
}

void CCompoundKeyDlg::RemoveFromKey()
{
    if (!CurrentKey)
        return;
    int pos;
    QString text;
    pos = KeyColumns->currentItem();
    if (pos == -1)
        return;
    text = KeyColumns->text(pos);
    KeyColumns->removeItem(pos);
    CurrentKey->remove_column_name(text.latin1());
}
