/***************************************************************************
                          altertable.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Aug 9 1999                                           
    copyright            : (C) 1999 by Rajko Albrecht                         
    email                : Rajko.Albrecht@informatik.tu-chemnitz.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef WIN32
#include <kapp.h>
#else
#pragma warning (disable:4786)
#endif

#include <string>
#include <qlist.h>
#include <qmessagebox.h>
#include "globals.h"
#include "stringres.h"
#include "my_sql.h"
#include "kmysqladmin/helpers/stringhelper.h"
#include "kmysqladmin/helpers/qt_stl_string.h"

#include "altertable.h"
#include <qcheckbox.h>                                                          
#include <qcombobox.h>                                                          
#include <qframe.h>                                                             
#include <qlabel.h>                                                             
#include <qlcdnumber.h>                                                         
#include <qlineedit.h>                                                          
#include <qlistbox.h>                                                           
#include <qpushbutton.h>                                                        
#include <qradiobutton.h>                                                       
#include <qslider.h>                                                            
#include <qlayout.h>                                                            
#include <qvariant.h>                                                           
#include <qtooltip.h>                                                           
#include <qwhatsthis.h>
#include <algorithm>

CAlterTable::CAlterTable(smart_pointer<CMySql>& _sql_server,QWidget *parent, const char *name )
    : CModifyTable(_sql_server,parent,name)
{
    QString Caption = CStringRes::get_string(125);
    Caption+= " - ";
    Caption+=CStringRes::get_string(114);
    setCaption(Caption);
    TableNameEdit = new QComboBox(FALSE,TopMost,"Tablelist");
    TableNameEdit->setGeometry(280,5,208,25);
    TableNameEdit->setMinimumSize(0,0);
    TableNameEdit->setMaximumSize(32767,32767);
    TableNameEdit->setFocus();
    SetDBString(0);
    CreateTableButton->setText("Alter");
    connect( CreateTableButton, SIGNAL(clicked()), SLOT(AlterTable()) );
    connect(TableNameEdit,SIGNAL(activated(int)),SLOT(SetTableString(int)));
    TopMostLayout->addWidget(TableNameEdit);
}

CAlterTable::~CAlterTable()
{
}

void CAlterTable::SetDBString(const QString&)
{
    CurrentTables.resize(0);
    TableNameEdit->clear();
    if (!sql_server->get_table_list("%",QT_TO_STL_STRING(DBList->currentText()),CurrentTables)) {
	return;
    }
    for (stringlist::iterator p = CurrentTables.begin();p!=CurrentTables.end();++p) {
	TableNameEdit->insertItem(p->c_str());
    }
    SetTableString(0);
}

void CAlterTable::SetTableString(int index)
{
    DescrChanges.resize(0);
    KeyChanges.resize(0);
    if (index < 0 || CurrentTables.size()==0)
      	return;
    if (!sql_server->get_table_fields(DBList->currentText().latin1(),
				      TableNameEdit->currentText().latin1(),
				      CurrentColumns)) {
	return;
    }
    if (!sql_server->get_table_keys(DBList->currentText().latin1(),
				    TableNameEdit->currentText().latin1(),
				    CurrentKeys)) {
    	return;
    }
    key_list = CurrentKeys;
    desc_list = CurrentColumns;
    build_strings();
    CompoundKeyButton->setEnabled(CurrentColumns.size()>1);
    ColumnNameEdit->setEnabled(true);
    if (CurrentColumns.size()) {
	ColumnsList->setCurrentItem(0);
	CreateTableButton->setEnabled(true);
    }
}

void CAlterTable::build_strings()
{
    //for an easier use :)
#define c_item desc_list[count]
    ColumnsList->clear();
    unsigned int count = 0;
    std::string name;
    std::string item_desc;
    ColumnsList->setAutoUpdate(false);
    for (;count < desc_list.size();++count) {
	name = desc_list[count].get_name();
	name+=" ";
	name+=CMySql::TypeDescript(c_item.get_FieldType());
	name+="(";
	name+=FormatSTLString("%i",c_item.get_MaxLength());
	if (c_item.get_MaxDecimals()) {
	    name+=",";
	    name+=FormatSTLString("%i",c_item.get_MaxDecimals());
	}
	name+=") ";
	if (c_item.is_Unsigned()) {
	    name+="UNSIGNED ";
	}
	if (c_item.is_NotNull()) {
	    name+="NOT NULL ";
	}
	if (c_item.is_AutoIncrement()) {
	    name+= "AUTO_INCREMENT ";
	}
	if (c_item.is_ZeroFill()) {
	    name+="ZEROFILL ";
	}
	if (c_item.is_Binary()) {
	    name+="BINARY ";
	}
	ColumnsList->insertItem(name.c_str());
    }
    ColumnsList->setAutoUpdate(true);
    ColumnsList->repaint();
#undef c_item
}

void CAlterTable::NameChanged(const QString&text)
{
    CModifyTable::NameChanged(text);
}

void CAlterTable::TableTextChanged(const QString&text)
{
    CModifyTable::TableTextChanged(text);
}

void CAlterTable::Modify_Column()
{
    std::string n_name = ColumnNameEdit->text().latin1();
    
    std::string old_name = "";
    ColumnList_iterator c_iter;
    change_list::iterator d_iter;
    CColumnDescriptor temp_desc;
    change_type t_change;
    change_type k_change;
    int i = ColumnsList->currentItem();
    if (i < 0 || (unsigned int)i > desc_list.size()) {
	return;
    }
    old_name = desc_list[i].get_name();

    temp_desc.set_name(old_name);
    c_iter = std::find(CurrentColumns.begin(),
                       CurrentColumns.end(),
                       temp_desc);
    t_change.columns.second = old_name;
    t_change.columns.first = "";
    d_iter = find_second(DescrChanges,t_change);
    if (!_modify_column()) {
	return;
    }
    //first modify
    if (c_iter!=CurrentColumns.end() && d_iter==DescrChanges.end()) {
	t_change.columns.first = old_name.c_str();
	t_change.columns.second = n_name.c_str();
	t_change.typ = change_type::mod;
	DescrChanges.push_back(t_change);
      
    } else if (d_iter!=DescrChanges.end() && d_iter->columns.first.size()>0) {
	//some more modifies and / or renamed to original name
	d_iter->columns.second = n_name;
	d_iter->typ = change_type::mod;
    } else if (d_iter==DescrChanges.end() && c_iter==CurrentColumns.end()) {
	//possible first deleted
	t_change.columns.first = n_name;
	t_change.columns.second = "";
	d_iter = std::find(DescrChanges.begin(),
                           DescrChanges.end(),
                           t_change);
	if (d_iter!=DescrChanges.end()) {
	    d_iter->columns.first = n_name;
	    d_iter->columns.second = n_name;
	    d_iter->typ = change_type::mod;
	}
    } else if (d_iter!=DescrChanges.end() && d_iter->columns.first.size()==0) {
	d_iter->columns.second = n_name;
    }
#ifndef NO_DEBUG
    debug_change();
#endif
}

void CAlterTable::AddColumn()
{
    std::string n_name = ColumnNameEdit->text().latin1();

    change_type t_change;
    change_list::iterator d_iter;
    
    t_change.columns.first = n_name;
    d_iter = std::find(DescrChanges.begin(),
                       DescrChanges.end(),
                       t_change);

    if (!_add_column()) {
	return;
    }
    if (d_iter!=DescrChanges.end()) {
	//	d_iter->columns.first = n_name;
	d_iter->columns.second = n_name;
	d_iter->typ = change_type::mod;
    } else {
	t_change.columns.first = "";
	t_change.columns.second = n_name;
	t_change.typ = change_type::add;
	DescrChanges.push_back(t_change);
    }
#ifndef NO_DEBUG
    debug_change();
#endif
}

void CAlterTable::Delete_Column()
{
    std::string name;
    change_type t_change;
    ColumnList_iterator c_iter;
    change_list::iterator d_iter;
    CColumnDescriptor temp_desc;

    int i = ColumnsList->currentItem();
    if (i < 0 || (unsigned int)i > desc_list.size()) {
	return;
    }
    name = desc_list[i].get_name();
    t_change.columns.first = name;
    t_change.columns.second = "";
    t_change.typ = change_type::del;
    temp_desc.set_name(name);
    c_iter = std::find(CurrentColumns.begin(),
                       CurrentColumns.end(),
                       temp_desc);
    if (c_iter!=CurrentColumns.end()) {
	//ok - first check for possible modified keys
	//deleting an original column
	d_iter = std::find(DescrChanges.begin(),
                           DescrChanges.end(),
                           t_change);
	if (d_iter!=DescrChanges.end()) {
	    //we fiddled around 
	    d_iter->columns.second = "";
	    d_iter->typ = change_type::del;
	} else {
	    //first shot
	    DescrChanges.push_back(t_change);
	}
    } else {
	t_change.columns.first = "";
	t_change.columns.second = name;
	d_iter = find_second(DescrChanges,t_change);
	if (d_iter!=DescrChanges.end()) {
	    DescrChanges.erase(d_iter);
	}
    }
    CModifyTable::Delete_Column();
#ifndef NO_DEBUG
    debug_change();
#endif
}

void CAlterTable::AlterTable()
{
    if (!sql_server->alter_table(QT_TO_STL_STRING(DBList->currentText()),
				 QT_TO_STL_STRING(TableNameEdit->currentText()),
				 desc_list,key_list,DescrChanges,CurrentKeys)) {
	QMessageBox::critical(this,CStringRes::get_string(120),
			      CStringRes::get_string(10));
	return;
    }
    close();
}

#ifndef NO_DEBUG
void CAlterTable::debug_change()
{
    debug("**** Current Changes ****");
    for (unsigned j = 0; j < DescrChanges.size();++j) {
	std::string debugausgabe = "";
	switch(DescrChanges[j].typ) {
	case change_type::mod:
	    debugausgabe = "Modify:  ";
	    break;
	case change_type::add:
	    debugausgabe = "Add:     ";
	    break;
	case change_type::del:
	    debugausgabe = "Delete:  ";
	    break;
	default:
	    debugausgabe = "Unknown: ";
	    break;
	}
	debugausgabe+= DescrChanges[j].columns.first;
	debugausgabe+= " -> ";
	debugausgabe+= DescrChanges[j].columns.second;
	debug(debugausgabe.c_str());
    }
    debug("*************************\n");
}
#endif
