/***************************************************************************
                          phrasetree.h  -  description
                             -------------------
    begin                : Don Okt 24 2002
    copyright            : (C) 2002 by Gunnar Schmi Dt
    email                : kmouth@schmi-dt.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// $Id: phrasetree.h,v 1.1 2003/01/17 23:09:36 gunnar Exp $

#ifndef PHRASETREE_H
#define PHRASETREE_H

#include <qpixmap.h>
#include <kshortcut.h>
#include <klistview.h>

class PhraseBook;
class PhraseShortcutRequest;

/**The class PhraseTreeItem is an ListViewItem for either a phrase or a phrase book.
  *@author Gunnar Schmi Dt
  */

class PhraseTreeItem : public KListViewItem {
   friend class PhraseTree;
private:
   /** Creates a phrase item within a sub phrase book */
   PhraseTreeItem (QListView *parent, QListViewItem *after, QString phrase, KShortcut shortcut, QPixmap icon);
   /** Creates a phrase item at the top level */
   PhraseTreeItem (QListViewItem *parent, QListViewItem *after, QString phrase, KShortcut shortcut, QPixmap icon);
   /** Creates a phrase book item within a sub phrase book */
   PhraseTreeItem (QListView *parent, QListViewItem *after, QString name, QPixmap icon);
   /** Creates a phrase book item at the top level */
   PhraseTreeItem (QListViewItem *parent, QListViewItem *after, QString name, QPixmap icon);

public:
   bool isPhrase();
   KShortcut cut();
   void setCut(KShortcut cut);

private:
   bool isPhraseValue;
   KShortcut cutValue;
};

/**
 * The class PhraseTree represents the ListView of the phrase book edit
 * dialog. It extends KListView for providing better drag-and-drop support.
 * @author Gunnar Schmi Dt
 */

class PhraseTree : public KListView  {
   friend class PhraseTreeItem;
   Q_OBJECT
public: 
   PhraseTree (QWidget *parent = 0, const char *name = 0);
   ~PhraseTree ();

   void keyPressEvent (QKeyEvent *e);

   PhraseTreeItem *insertPhrase (QListViewItem *parent, QListViewItem *after, QString phrase, QString shortcut);
   PhraseTreeItem *insertBook (QListViewItem *parent, QListViewItem *after, QString name);

   QListViewItem *addBook (QListViewItem *parent, QListViewItem *after, PhraseBook *book);
   void fillBook (PhraseBook *book, bool respectSelection);

   QDragObject *dragObject ();
   QDragObject *dragObject (bool isDependent);

   void moveItem (QListViewItem *item, QListViewItem *parent, QListViewItem *above);

   bool hasSelectedItems();
   void deleteSelectedItems();

protected:
   bool acceptDrag (QDropEvent* event) const;

private:
   void _warning (const KKeySequence& cut, QString sAction, QString sTitle);
   bool isStdAccelPresent (const KShortcut& cut, bool warnUser);
   bool isGlobalKeyPresent (const KShortcut& cut, bool warnUser);
   bool isApplicationKeyPresent (const KShortcut& cut, bool warnUser);
   bool isPhraseKeyPresent (const KShortcut& cut, PhraseTreeItem* cutItem, bool warnUser);
public:
   bool isKeyPresent (const KShortcut& cut, PhraseTreeItem* cutItem, bool warnUser);

public slots:
   void itemExpanded (QListViewItem *item);
   void itemCollapsed (QListViewItem *item);

signals:
   void shortcutRequest (PhraseShortcutRequest *request);

private:
   QPixmap phrasebook_open;
   QPixmap phrasebook_closed;
   QPixmap phrase;
};

#endif

/*
 * $Log: phrasetree.h,v $
 * Revision 1.1  2003/01/17 23:09:36  gunnar
 * Imported KMouth into kdeaccessibility
 *
 * Revision 1.4  2003/01/08 16:58:40  gunnar
 * Selection of multiple phrase book entres in the editor added
 *
 * Revision 1.3  2002/11/20 10:11:49  gunnar
 * Keyboard drag of entries within the phrase book edit window implementated
 *
 * Revision 1.2  2002/11/17 17:13:18  gunnar
 * Several small changes in the phrase book edit window
 *
 * Revision 1.1  2002/11/11 21:25:44  gunnar
 * Moved the parts concerning phrase books into a static library
 *
 * Revision 1.2  2002/11/06 17:28:02  gunnar
 * Code for preventing double keyboard shortcuts extended for imported/dragged/pasted phrasebooks
 *
 * Revision 1.1  2002/10/24 19:54:42  gunnar
 * Drag and drop support in the phrase book edit dialog improved
 *
 */
