/***************************************************************************
                          dockwidget.cpp  -  description
                             -------------------
    begin                : Fri Nov 14 2000
    copyright            : (C) 2000 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dockwidget.h"
#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>

/*************************************************
 * create dockwidget with popup-menu             *
 *************************************************/
dockwidget::dockwidget(QWidget *, const char * name) : KDockWindow(0, name)
{
  popup_menu = new KPopupMenu(this);
  popup_menu->setTitle("KSteak");
  popup_menu->insertItem(i18n("Undock"), 1);
  popup_menu->insertSeparator();
  popup_menu->insertItem(BarIcon("exit.png"), i18n("Quit"), 2);
  connect(popup_menu, SIGNAL(activated(int)), this, SLOT(slotMenuClicked(int)));
}

/*************************************************
 * destructor                                    *
 *************************************************/
dockwidget::~dockwidget()
{
  delete popup_menu;
}

/*************************************************
 * exec popup-menu on mousepressevent            *
 *************************************************/
void dockwidget::mousePressEvent(QMouseEvent* e)
{
  if (e->button() == RightButton) popup_menu->exec(QCursor::pos());
  if (e->button() == LeftButton) emit translate();
}

/*************************************************
 * emit signals when (un-)dock                   *
 *************************************************/
void dockwidget::slotMenuClicked(int i)
{
  if (i == 1) emit undock();
  if (i == 2) emit done();
}
