/***************************************************************************
                          kryptosf.h  -  description
                             -------------------
    begin                : Sam Dez 22 22:15:44 CET 2001
    copyright            : (C) 2001 by SiSch
    email                : general_ossig@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRYPTOSF_H
#define KRYPTOSF_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//QT:
#include <qwidget.h>
#include <qtextview.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qfileinfo.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qtextstream.h>
#include <qprogressdialog.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qradiobutton.h>
#include <qclipboard.h>

//kde:
#include <kapp.h>
#include <kfiledialog.h>
#include <ktmainwindow.h>
#include <kconfig.h>
#include <kmenubar.h>
#include <kprocess.h>
#include <kiconloader.h>
#include <kurlrequester.h>
#include <kurlpixmapprovider.h>
#include <kio/netaccess.h>
#include <krun.h>
#include <kdiroperator.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kstdaction.h>
#include <kaccel.h>
#include <ktar.h>

//Ansi:
#include <stdlib.h>

//eigene:
#include <configdialog.h>

/** Kryptosf is the base class of the project */
/*sorry, is n bisschen durcheinander*/

class Kryptosf : public KTMainWindow
{
  Q_OBJECT
  public:
    /** construtor */
    Kryptosf( );
    /** destructor */
    ~Kryptosf();

/*Klasseneigene Enums:*/

/*spezieller exitstatus von krypto wenn man es mit dem
 *parameter w (wie "Wer bist du?") aufruft
 */
enum { ICH_BIN_KRYPTO_VON_SICH = 109 };

enum { STATUSBAR_READY	};

/*Eigenschaften:*/
/*==============*/

	//for the output
	QFile *oFile;
	KURLPixmapProvider PixmapProvider;

	//Actions
	KAction *QuitAction;
	KAction *UpAction;
	KAction *DownAction;
	KAction *SwapAction;
	KAction *StopAction;
	KAction *RunAction;
	KAction *RunFolderAction;
	KAction *PasteAction;
	KAction *OpenAction;
	KAction *SaveAction;
	KToggleAction *ToggleToolbarAct;
	KToggleAction *ToggleStatusbarAct;
	KToggleAction *ToggleAusgabeAct;
	KToggleAction *ToggleDirViewAct;
  //Automatisches Ergnzen:
	KToggleAction *ToggleAutoErgAct;
	KToggleAction *ToggleDeleteOrgAct;

	/*main widget:*/
	QWidget *w;
	KDirOperator *DirView;
	QTimer *timer1;
  KProcess *Process;
	KConfig *config;
  QFileInfo *FileInfo;
	/*Slimlsit ist eine liste von 'j's und 'n's.
	jedes 'n' steht fr
	"Die Datei die in der SrcLbx(s. unten) den
	gleichen Index hat wie ich in der SlimList,
	soll normal verschlsselt werden".
	'j' steht fr
	 "...soll im slim mode (einfache Verschlsselung)
	 verschlsselt werden".
	*/
	QString SlimList;
	QString *Filter;
	QString Program;
	QString ExtraParameter;
  /* header fr "kryptosfsavedateien" */
  QString kryptosDateiHeader;
	uint currentStep;
  uint totalSteps;
	uint srcsize;

	/*zum prfen ob wir es mit dem richtigen
	 *Programm zutun haben
	 */
	bool Programsaidit;

/*---------------dialogs------------*/
	ConfigDialog *cd;
	KFileDialog *FileDialog;

/* //////////////widgets://///////// */
	QPopupMenu * LbxMenu;
  	QRadioButton *r8fach;
	QRadioButton *r2fach;

  	QRadioButton *rent;
	QRadioButton *rver;

	QGroupBox *SrcGroup;
  //target
  	QGroupBox *TrgGroup;
	QGroupBox *spacer;
	QCheckBox *Overwrite;
		
  	QHBoxLayout *hlayout1;
  	QVBoxLayout *SrcGroupvlayout;
	QVBoxLayout *TrgGroupvlayout;
  	QHBoxLayout *ahlayout;
	QHBoxLayout *Trghlayout;
	QHBoxLayout *Srchlayout;
	QVBoxLayout *avlayout;
  	QVBoxLayout *vlayout;
  	QHBoxLayout *hlayout;

  QTextView *Browser;

  QPushButton *BeginBtn;
  QPushButton *BeginAllBtn;

  QPushButton *AddFileBtn;
	QPushButton *SearchBtn;
	QPushButton *TrgSearchBtn;

  //source file edit
  QLineEdit *SrcEdit;
  QLineEdit *TrgEdit;
  QLineEdit *PswEdit;
  QLineEdit *PswEdit2;
	QListBox *SrcLbx;
	QListBox *TrgLbx;

/*Funktionen:*/
/*===========*/
	virtual bool queryClose();
	QString Arguments( const QString Src, bool slim, bool showPasswordNotAsSternchen);
	bool isRightProgram ();
  /** Allgemeine Connections */
  void setupConnections();
  /** setup the Tooltips */
  void setupTooltips();
  /** Setup the layouts */
  void setupLayouts();
  /** setup the Menu */
  void setupMenu();
  /** setup the shortcuts */
  void setupActions();
  /** No descriptions */
  void setupToolbar();

  /** wird aufgerufen vom session manager */
  virtual void saveProperties ( KConfig* );
	void saveConfig();
  /** No descriptions */
  void readConfig(  );

  /** Die eigentliche Arbeit fr ne bestimmte Datei erledigen
		  SrcIndex gibt den Index dieser bestimmten Datei innerhalb
		  von SrcLbx an*/
  void work ( int SrcIndex, const QString &theSrc, const QString &Trg );
  /** receonnected n par slots (siehe _disconect) */
  void _reconnect();
  /** disconnected n par slots um in bestimmten
	situationen rekursion zu vermeiden */
  void _disconnect();
  /** No descriptions */
  QPixmap getTrgIcon ( QString icon );
  /** No descriptions */
  QPixmap getSrcIcon ( QString icon );
  /** returns the local path from the url if it is local */
  QString localPathFromURL( KURL URL );
  /** disable some widgets before work */
  void _disable();
  /** enable some widgets after work */
  void _enable();
  /** fragt nach (mittels KMessageBox):
	text ist die Ja/Nein Frage
	caption ist der titel der Messagebox

	returns true wenn ja geantwortet wurde,
	ansonsten false
	 */
  bool question ( QString text, QString caption );
  /** siehe KMessageBox::sorry */
  void sorry( QString text, QString caption = "Kryptos frend");
  /** checked ob Inhalt des Clipboards richtiges Format hat */
  bool clipboardHasFormat();

/*SLOTS:*/
/*======*/

/*Achtung: nicht alle Slots sind mit dem Prfix slot gekennzeichnet!*/
  public slots:
	/** checked ob alle Dateien existieren bzw. nicht
 	existieren usw. */
  bool allRight ( const QString &Src, const QString &Trg );
	void slotAddFileBtnClicked ();
	void slotSearchBtnClicked();
	void slotTrgSearchBtnClicked();
	void slotFilterChanged(const QString &);
	void slotConfigMnuClicked ();
	void slotBtn1Clicked();
	void slotBtn2Clicked();
	void slotBtn3Clicked();
	void slotFindBtnClicked();
	void slotExtraEdtChange ( const QString &);
	void slotBegin();
  	void slotDataReceived(KProcess *, char *, int );
	void slotStdDataReceived(KProcess *, char *, int );
	void slotCancel();
  /** No descriptions */
  void slotStateChanged( int );
  /** ListBox selection changed */
  void slotLbxSelChanged( int );
  /** the sourcefile listbox scrollbar changed */
  void SrcLbxScrollbarChanged ( int );
  /** No descriptions */
  void TrgLbxScrollbarChanged ( int );
  /** Popupmenu of src and Trg Listbox listbox */
  void slotLbxMenu ( QListBoxItem *, const QPoint & ) ;
  /** popupmenuaction */
  void LbxRemoveItem();
  /** Listboxen clearen */
  void LbxClear();
  /** No descriptions */
  void slotBeginAllBtnClicked();
  /** No descriptions */
  void LbxSwap();
  /** swapp all item from SrcLbx to TrgLbx */
  void LbxSwapAll();
  /** No descriptions */
  void slotSlimChanged( int );
  /** No descriptions */
  void slotTrgEditChange (const QString & );
  /** No descriptions */
  void slotSrcEditChange (const QString &);
  /** No descriptions */
  void slotLbxDoubleClicked( QListBoxItem * );
  /** speichern der listen */
  void saveLists();
  /** listen laden */
  void loadLists();
  /** sortiere TrgLbx */
  void TrgLbxSort();
  /** sortiere SrcLbx */
  void SrcLbxSort();
  /** Ausgabe des kryptoprogramms anzeigen
	oder halt nicht */
  void slotToggleAusgabe();
  void slotToggleDirView();
  void slotToggleToolbar();
  void slotToggleStatusbar();
  /** No descriptions */
  void LbxPasteItem();
  /** No descriptions */
  void LbxCopyItem();
  /** No descriptions */
  void DirViewFileSelected (const KFileViewItem*);
  /** No descriptions */
  void slotLbxUpdate();
  /** Zeile hoch */
  void LbxUp();
  /** zeile runter */
  void LbxDown();
  /** No descriptions */
  void LbxRunFolder();
  /** datei ausfhren */
  void LbxRun();
signals: // Signals
  /** wird and den Progressdialog gesannt */
  void fortschrittAktualisieren( int );
protected: // Protected methods
};

#endif
