/***************************************************************************
                          textdlg.cpp  -  description
                             -------------------
    begin                : Wed Apr 18 2001
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qstringlist.h>
#include <klocale.h>
#include <kapp.h>
#include "edittextdlg.h"
#include "kpldoubleedit.h"
#include "textitem.h"
#include "textdlg.h"

TextDlg::TextDlg(QWidget* parent, KplDoc* model, TextItem* td0) :
 DecoDlg(parent, model, td0, 4), td(td0)
{
  resize(400, 160);
  setCaption(i18n("Text"));
  grid->addWidget(new QLabel(i18n("Text"), this), 0, 0);
  grid->addMultiCellWidget(eText = new QLineEdit(td->s, this), 0, 0, 1, 5);
  QPushButton* b = new QPushButton("...", this);
  b->setFixedWidth(28);
  grid->addWidget(b, 0, 6);
  connect(b, SIGNAL(clicked()), SLOT(slotEditText()));
  grid->addWidget(new QLabel(i18n("Direction"), this), 1, 0);
  grid->addWidget(eDir = new KplDoubleEdit(td->dir, -360.0, 360.0, this),
                  1, 1);
  grid->addWidget(new QLabel("", this), 1, 2);
  grid->addWidget(new QLabel(i18n("Alignment"), this), 1, 4);
  grid->addWidget(eAlign = new QComboBox(false, this), 1, 5);
  QStringList list;
  list << i18n("left") << i18n("centered") << i18n("right");
  eAlign->insertStringList(list);
  eAlign->setCurrentItem(td->iAlign - 1);
  initEntries(2);
  initButtons();
  connect(bHelp, SIGNAL(clicked()), SLOT(slotHelp()));
  connect(bOK, SIGNAL(clicked()), SLOT(slotOK()));
  connect(bApply, SIGNAL(clicked()), SLOT(slotApply()));
}

TextDlg::~TextDlg()
{
}

void TextDlg::getValues(bool ok)
{
  td->dir = eDir->value();
  td->iAlign = eAlign->currentItem() + 1;
  td->s = eText->text();
  DecoDlg::getValues(ok);
}

void TextDlg::slotEditText()
{
  EditTextDlg dlg(this, eText);
  dlg.exec();
}

void TextDlg::slotOK()
{
  getValues(true);
}

void TextDlg::slotApply()
{
  getValues(false);
}

void TextDlg::slotHelp()
{
  kapp->invokeHelp("SEC-TEXT");
}
