/***************************************************************************
                          kplwidget.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPLWIDGET_H
#define KPLWIDGET_H

#include <qglobal.h>
#include <qwidget.h>
#include <kurl.h>

/**
  * Plot widget. Provides the page widget to plot on.
  * @author Werner Stille
  */
class KplWidget : public QWidget
{
   Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   */
	KplWidget(QWidget* parent);
  /** Destructor */
	~KplWidget();

protected:
  /** Repaints the widget by bitblitting the pixmap. */
  virtual void paintEvent(QPaintEvent* e);
  /** Sets cross cursor and emits signal for statusbar updating. */
  virtual void mouseMoveEvent(QMouseEvent* e);
  /** Emits signals when left or right button pressed. */
  virtual void mousePressEvent(QMouseEvent* e);
  /** Emits signal when left button released. */
  virtual void mouseReleaseEvent(QMouseEvent* e);
  /** Emits signal when mouse enters the widget. */
  virtual void enterEvent(QEvent* e);
  /** Emits signal when mouse leaves the widget. */
  virtual void leaveEvent(QEvent* e);
  /** Reimplemented for handling Qt DnD events. */
  virtual void dragEnterEvent(QDragEnterEvent* e);
  /** Reimplemented for handling Qt DnD events. */
  virtual void dropEvent(QDropEvent* e);
  QPixmap* pm;

  friend class KplView;

signals:
  /**
   * Emitted when changed mouse position needs updating of the status bar.
   * @param e mouse event.
   */
  void mouseMoved(QMouseEvent* e);
  /**
   * Emitted when left mouse button pressed.
   * @param e mouse event.
   */
  void leftButtonPressed(QMouseEvent* e);
  /**
   * Emitted when left mouse button released.
   * @param e mouse event.
   */
  void leftButtonReleased(QMouseEvent* e);
  /** Emitted when right mouse button pressed to display the context menu. */
  void rightButtonPressed();
  /**
   * Emitted when mouse enters the widget.
   * @param pos mouse position.
   */
  void mouseEntered(const QPoint& pos);
  /** Emitted when mouse leaves the widget. */
  void mouseLeaved();
  /**
   * Emitted when Qt drop results in a list or URLs.
   * @param list pointer to list.
   */
  void urlsDropped(KURL::List* list);
};

#endif
