/***************************************************************************
                          frameitem.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Aug 29 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ksimpleconfig.h>
#include <klocale.h>
#include "kgraph.h"
#include "kplchecklistitem.h"
#include "frameitem.h"
#include "framedlg.h"
#include "utils.h"

FrameItem::FrameItem() : logx(false), logy(false), xTop(false), yRight(false),
 ndigx(-1), ndigy(-1), mticx(5), mticy(2), gridmode(2), iex(0), iey(0),
 colFrame(0), colGrid(0), xf(21.0), yf(29.7), w(15.0), h(10.0),
 xmi(0.0), xma(15.0), ymi(0.0), yma(10.0), xtic(5.0), ytic(2.0), relsiz(1.0)
{
  x0 = 4.0;
  y0 = 3.0;
}

FrameItem::FrameItem(Kpl::AutoStruct* aut) :
 logx(aut->autoLogX), logy(aut->autoLogY), xTop(false), yRight(false),
 ndigx(-1), ndigy(-1), mticx(5), mticy(2), gridmode(aut->autoGrid),
 iex(0), iey(0), colFrame(aut->colFrame), colGrid(aut->colGrid),
 xf(aut->xf), yf(aut->yf), w(aut->xlAuto), h(aut->ylAuto),
 xmi(0.0), xma(aut->xlAuto), ymi(0.0), yma(aut->ylAuto), xtic(5.0), ytic(2.0),
 relsiz(1.0), sx(aut->sxAuto), sy(aut->syAuto), sh(aut->shAuto)
{
  x0 = aut->x0Auto;
  y0 = aut->y0Auto;
}

FrameItem::FrameItem(KSimpleConfig* plo, Kpl::AutoStruct* aut) : KplItem(plo)
{
  logx = plo->readBoolEntry("logx", false);
  logy = plo->readBoolEntry("logy", false);
  xTop = plo->readBoolEntry("xTop", false);
  yRight = plo->readBoolEntry("yRight", false);
  ndigx = plo->readNumEntry("ndigx", -1);
  ndigy = plo->readNumEntry("ndigy", -1);
  mticx = plo->readNumEntry("mticx", 5);
  mticy = plo->readNumEntry("mticy", 2);
  gridmode = plo->readNumEntry("gridmode", aut->autoGrid);
  iex = plo->readNumEntry("iex");
  iey = plo->readNumEntry("iey");
  QString s = plo->readEntry("colframe", "");
  unsigned u;
  if (!s.isEmpty()) {
    sscanf(s.latin1(), "%x", &u);
    colFrame = Utils::rgbQt(u);
  } else
    colFrame = aut->colFrame;
  s = plo->readEntry("colgrid", "");
  if (!s.isEmpty()) {
    sscanf(s, "%x", &u);
    colGrid = Utils::rgbQt(u);
  } else
    colGrid = aut->colGrid;
  xf = plo->readDoubleNumEntry("xf", aut->xf);
  yf = plo->readDoubleNumEntry("yf", aut->yf);
  x0 = plo->readDoubleNumEntry("xw0", aut->x0Auto);
  w = plo->readDoubleNumEntry("xw", aut->xlAuto);
  y0 = plo->readDoubleNumEntry("yw0", aut->y0Auto);
  h = plo->readDoubleNumEntry("yw", aut->ylAuto);
  xmi = plo->readDoubleNumEntry("xmi");
  xma = plo->readDoubleNumEntry("xma", xmi + 15.0);
  ymi = plo->readDoubleNumEntry("ymi");
  yma = plo->readDoubleNumEntry("yma", ymi + 10.0);
  xtic = plo->readDoubleNumEntry("xtic", 5.0);
  ytic = plo->readDoubleNumEntry("ytic", 2.0);
  relsiz = plo->readDoubleNumEntry("relsiz", 1.0);
  sx = plo->readEntry("sx", "");
  sy = plo->readEntry("sy", "");
  sh = plo->readEntry("sh", "");
}

FrameItem::FrameItem(bool act, bool lgx, bool lgy, int ndx, int ndy,
                     int mtx, int mty, int gm, int ex, int ey,
                     const QString& col_f, const QString& col_g,
                     double x_0, double wx, double y_0, double hy,
                     double xmin, double xmax, double ymin,
                     double ymax, double xt, double yt, double relSize,
                     const QString& sX, const QString& sY, const QString& sH,
                     Kpl::AutoStruct* aut) :
 logx(lgx), logy(lgy), xTop(false), yRight(false), ndigx(ndx), ndigy(ndy),
 mticx(mtx), mticy(mty), gridmode(gm), iex(ex), iey(ey),
 xf(aut->xf), yf(aut->yf), w(wx), h(hy), xmi(xmin), xma(xmax),
 ymi(ymin), yma(ymax), xtic(xt), ytic(yt), relsiz(relSize), sx(sX), sy(sY),
 sh(sH)
{
  active = act;
  x0 = x_0;
  y0 = y_0;
  unsigned u;
  sscanf(col_f.latin1(), "%x", &u);
  colFrame = Utils::rgbQt(u);
  sscanf(col_g.latin1(), "%x", &u);
  colGrid = Utils::rgbQt(u);
}

FrameItem::~FrameItem()
{
}

KplItem::ItemTypes FrameItem::iType() const
{
  return Frame;
}

void FrameItem::draw(KplGraph* g)
{
  if (!g->type())
    bRect.setRect(0, 0, 0, 0);
  if (w && h && active) {
    g->format(xf, yf);
    g->setRelSize(relsiz);
    g->Window(x0, w, y0, h);
    if (!g->type()) {
      KGraph* gr = (KGraph*) g;
      bRect.setCoords(gr->minx, gr->maxy, gr->maxx, gr->miny);
    }
    g->scale(xmi, xma, ymi, yma, logx, logy);
    g->setDig(ndigx, ndigy);
    g->setColFrame(colFrame);
    g->setColGrid(colGrid);
    g->raster(xtic, ytic, mticx, mticy, gridmode, xTop, yRight);
    g->letX(sx, iex, xTop);
    g->letY(sy, iey, yRight);
    g->letH(sh, xTop);
  }
}

void FrameItem::writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                         KplDoc* m) const
{
  plo->writeEntry("Type", "FRAMEITEM");
  KplItem::writePlo(plo, url, abs, m);
  if (logx)
    plo->writeEntry("logx", logx);
  if (logy)
    plo->writeEntry("logy", logy);
  if (xTop)
    plo->writeEntry("xTop", xTop);
  if (yRight)
    plo->writeEntry("yRight", yRight);
  plo->writeEntry("ndigx", ndigx);
  plo->writeEntry("ndigy", ndigy);
  plo->writeEntry("mticx", mticx);
  plo->writeEntry("mticy", mticy);
  plo->writeEntry("gridmode", gridmode);
  plo->writeEntry("iex", iex);
  plo->writeEntry("iey", iey);
  QString s;
  plo->writeEntry("colframe", s.sprintf("%x", Utils::rgbQt1(colFrame)));
  plo->writeEntry("colgrid", s.sprintf("%x", Utils::rgbQt1(colGrid)));
  plo->writeEntry("xf", xf);
  plo->writeEntry("yf", yf);
  plo->writeEntry("xw0", x0);
  plo->writeEntry("xw", w);
  plo->writeEntry("yw0", y0);
  plo->writeEntry("yw", h);
  plo->writeEntry("xmi", xmi);
  plo->writeEntry("xma", xma);
  plo->writeEntry("ymi", ymi);
  plo->writeEntry("yma", yma);
  plo->writeEntry("xtic", xtic);
  plo->writeEntry("ytic", ytic);
  plo->writeEntry("relsiz", relsiz);
  plo->writeEntry("sx", sx);
  plo->writeEntry("sy", sy);
  plo->writeEntry("sh", sh);
}

void FrameItem::setText(KplCheckListItem* it, bool*, bool*) const
{
  it->setText(1, i18n("Frame"));
  QString s1, s2;
  it->setText(2, s1.sprintf("x = %g cm, y = %g cm, ", x0, y0) + i18n("size")
              + s2.sprintf(" %g cm x %g cm", w, h));
}

int FrameItem::editItem(QWidget* parent, KplDoc* m, int i)
{
  FrameDlg dlg(parent, m, i);
  return dlg.exec();
}

KplItem* FrameItem::copy() const
{
  return new FrameItem(*this);
}
