/***************************************************************************
                          frameitem.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Aug 29 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FRAMEITEM_H
#define FRAMEITEM_H

#include <qstring.h>
#include "kplitem.h"

class KplCheckListItem;

/**
  * Frame item class. Class for frame items with tics, grid, labels.
  * @author Werner Stille
  */

class FrameItem : public KplItem {

public:
  /** Constructor */
	FrameItem();
  /**
    * Constructor. Initializes corresponding to autoplot settings.
    * @param aut pointer to structure containing autoplot settings.
    */
  FrameItem(Kpl::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to plot file.
    * @param plo pointer to KSimpleConfig object containing item data.
    * @param aut pointer to structure containing autoplot settings.
    */
  FrameItem(KSimpleConfig* plo, Kpl::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to arguments.
    * @param active true for visible item.
    * @param logx true for logarithmic x axis.
    * @param logy true for logarithmic x axis.
    * @param ndigx number of digits for x axis.
    * @param ndigy number of digits for y axis.
    * @param mticx number of intervals between major tics of x axis.
    * @param mticy number of intervals between major tics of y axis.
    * @param gridmode 0 for frame only, 1 for axes with tics,
    * 2 for axes with tics and labels, 3 for grid, 4 for grid with labels.
    * @param iex logarithm of normalization factor for x axis.
    * @param iey logarithm of normalization factor for y axis.
    * @param colFrame color for frame and labels.
    * @param colGrid color for grids and tics.
    * @param x0 left page margin in centimeters.
    * @param x width in centimeters.
    * @param y0 bottom page margin in centimeters.
    * @param h height in centimeters.
    * @param xmin x value of left data window margin in user units.
    * @param xmax x value of right data window margin in user units.
    * @param ymin y value of bottom data window margin in user units.
    * @param ymax y value of top window data margin in user units.
    * @param xtic distance between major tics of x axis.
    * @param ytic distance between major tics of y axis.
    * @param relSize relative size of text, markers and lines.
    * @param sx x axis text.
    * @param sy y axis text.
    * @param sh heading text.
    */
	FrameItem(bool active, bool logx, bool logy, int ndigx, int ndigy,
            int mticx, int mticy, int gridmode, int iex, int iey,
            const QString& colFrame, const QString& colGrid,
            double x0, double w, double y0, double h,
            double xmin, double xmax, double ymin, double ymax,
            double xtic, double ytic, double relSize,
            const QString& sx, const QString& sy, const QString& sh,
            Kpl::AutoStruct* aut);
  /** Destructor */
	virtual ~FrameItem();
  virtual ItemTypes iType() const;
  virtual void draw(KplGraph* g) const;
  virtual void writePlo(FILE* f, const KURL& url, bool abs) const;
  virtual void setText(KplCheckListItem* it, bool* arrays, bool* funcs) const;
  virtual int editItem(QWidget* parent, KplDoc* m, int i);
  virtual KplItem* copy() const;

protected:
  /**
   * Initializes several elements.
   */
  void init();
  bool logx, logy;
  int ndigx, ndigy, mticx, mticy, gridmode, iex, iey;
  unsigned colFrame, colGrid;
  double xf, yf, xw0, xw, yw0, yw, xmi, xma, ymi, yma, xtic, ytic, relsiz;
  QString sx, sy, sh;

  friend class FrameDlg;
  friend class KplApp;
  friend KplDoc;
};

#endif
