/***************************************************************************
                          kbeartipoftoday.cpp  -  description
                             -------------------
    begin                : Sat Feb 10 2001
    copyright            : (C) 2001 by Bjrn Sahlstrm
    email                : bjorn@kbear.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qlabel.h>
#include "kbeartipoftoday.h"
//-----------------------------------------------
KBearTipOfToday::KBearTipOfToday(QWidget *parent, const char *name )
	: KBearTipOfTodayDialog(parent,name,true)
{
	tipList << i18n("\nDid you know that you can change between TopLevel Mode and ChildFrame Mode with the keyboard?\n"
								"F5 change to TopLevel Mode and F6 change to ChildFrame Mode, if already in ChildFrame Mode an auto tile will accure.\n"
								"Note: When in TopLevel Mode the main window has to be activated in order to respond to keystrokes.");
	tipList << i18n("\nWith the F1 key you can access the help system directly.");
	tipList << i18n("\nIf you work with many sites simultanously you can spread the views over several desktops. Do like this:\n"
								"First switch to toplevel mode, then make the main window and the view for your local filesystem \"sticky\". "
								"After this you can switch to a new desktop for each new site you want to open and you will have your main "
								"window and the local filesystem view at each desktop along with the remote siteview.");
	tipList << i18n("\nIn the Settings menu you can choose which parts of the Main Window you want to be visible.");
	tipList << i18n("\nWith Shift+F1 you switch to \"What's this\" mode.");
	tipList << i18n("\nIn the Quick Connection dialog you can choose to save the conection to the Sitemanager.");
	tipList << i18n("\nDid you know that you can access the ten most recently used connections directly through the FTP->Open Recent... menu ?");
	tipList << i18n("\nDid you know that by right clicking the Taskbar buttons you get a popup menu specific for that view ?");
	tipList << i18n("\nHave you noticed that the time you have been connected to a specific site is displayed at the bottom of each site view ?");
	tipList << i18n("\nDid you know that by right clicking within the file view, you get a popup menu with a lot of options.\n"
								"Notice: This popup menu is different depending on if you click on a file or not..");
	tipList << i18n("\nThe \"Home button\" moves you directly to your home directory, on a remote site this means your startup directory.");
	tipList << i18n("\nBy right clicking in the \"tree view\" you can show/hide the \"tree view\". "
								"The same functionality is available from the toolbar.");
	tipList << i18n("\nDid you know that by rightclicking on a transfer item in the transfer view you can cancel any transfer.");
	tipList << i18n("\nWith the find button you can search for specific files.\n"
								"Note: in the search dialog you can use regular expressions in the search.");
	tipList << i18n("\nThere are launch buttons for both Konqueror and KMail so you can access these applications directly from within KBear.");
	tipList << i18n("\nHave you noticed that in the right combobox with the label filter, you can use regular expressions to filter out only the files you want to see.\n"
								"For example *.cpp will only show files with the extension cpp.");
	tipList << i18n("\nYou can drag files and folders not only between views within KBear but also to and from Konqueror and some other KDE applications.");
	tipList << i18n("\nIn the settings dialog you can select if you don't want the '.part' extension to be used during transfers\n"
  														"This can solve the 'rename problem' on anonymous servers\n\n"
  														"WARNING! This setting will affect all KDE2 applications that use it, not only KBEAR.");
	numOfTip = tipList.count();
}
//-----------------------------------------------
KBearTipOfToday::~KBearTipOfToday(){
}
//-----------------------------------------------
/** No descriptions */
void KBearTipOfToday::run(){
	if( ! numOfTip > 0	)
		return;
	srand( time(0L) );
	tipNr = rand()%numOfTip;
	tipMultiLineEdit->setText( tipList[ tipNr ] );
	exec();
}
//-----------------------------------------------
/** No descriptions */
void KBearTipOfToday::next(){
	tipNr = ++tipNr%numOfTip;
	tipMultiLineEdit->clear();
	tipMultiLineEdit->setText( tipList[ tipNr ] );
}
//-----------------------------------------------
/** No descriptions */
void KBearTipOfToday::previous(){
	tipNr = --tipNr%numOfTip;
	tipMultiLineEdit->clear();
	tipMultiLineEdit->setText( tipList[ tipNr ] );
}
//-----------------------------------------------
bool KBearTipOfToday::runTipOfToday() {
	return runTipCheckBox->isChecked();
}
//-----------------------------------------------
