//**************************************************************************
//                        childframemodesettings.h  -  description
//                           -------------------
//  begin                : Thu Nov 2 2000
//  copyright            : (C) 2000 by Bjrn Sahlstrm
//  email                : bjorn@kbear.org
//**************************************************************************/

//**************************************************************************
//                                                                         *
//   This program is free software; you can redistribute it and/or modify  *
//   it under the terms of the GNU General Public License as published by  *
//  the Free Software Foundation; either version 2 of the License, or     *
//  (at your option) any later version.                                   *
//                                                                        *
//*************************************************************************/

#ifndef CHILDFRAMEMODESETTINGS_H
#define CHILDFRAMEMODESETTINGS_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qradiobutton.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "childframemodesettingsbase.h"
	
	/**
  *@author Bjrn Sahlstrm
  */

class ChildFrameModeSettings : public ChildFrameModeSettingsBase  {
   Q_OBJECT
public: 
	/** */
	ChildFrameModeSettings(QWidget *parent=0, const char *name=0)
						: ChildFrameModeSettingsBase(parent,name){}
	/** */
	~ChildFrameModeSettings(){}
	/**
	*  When using ChildFrameModeSettings dialog the enum  is used to set and get the default mode settings
	*/
	enum {
		Cascade,
		CascadeMaximized,
		ExpandVertical,
		ExpandHorizontal,
		AnodinesTile,
		PragmasTile,
		TileVertically,
		None	
	};
	/** checks the default ChildFrameMode radio button */
	void setDefaultChildFrameMode( unsigned int mode );
	/**@returns what ChildFrameMode is checked  */
	unsigned int getDefaultChildFrameMode();
};
#endif
