/***************************************************************************
                          rootdlg.h  -  description
                             -------------------
    begin                : Sam Jan 25 2003
    copyright            : (C) 2003 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ROOTDLG_H
#define ROOTDLG_H

#include <qwidget.h>
#include <kdialogbase.h>

class QComboBox;
class QPushButton;
class QTable;
class KplDoc;
class KplDoubleEdit;
class SplineItem;

/**
  *@author Werner Stille
  */

/**
  * Root dialog class. Provides a dialog for finding the roots of a smoothing
  * cubic spline or its derivatives.
  * @author Werner Stille
  */
class RootDlg : public KDialogBase
{
   Q_OBJECT
public: 
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param spl pointer to spline item.
   */
  RootDlg(QWidget* parent, KplDoc* model, SplineItem* spl);
  /** Destructor. */
  ~RootDlg();

protected:
  QComboBox *eCond;
  QPushButton *update;
  QTable* table;
  KplDoc* m;
  KplDoubleEdit *eOff;
  SplineItem *spl;

protected slots:
  /** Finds roots. */
  virtual void findRoots();
  /** Exports values. */
  virtual void slotUser1();
};

#endif
