/***************************************************************************
                          ccharacterprofile.h
                          -------------------
    description          : Character Profile Class
    begin                : Sun Oct 17 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CCHARACTERPROFILE_H
#define CCHARACTERPROFILE_H

#include <qstring.h>
#include <qdir.h>
#include <ksimpleconfig.h>

/**
  * Character Profile Class
  *@author Stephan Uhlmann
  */

struct AliasEntry
{
	QString name;
	QString definition;
	int macro;
	ButtonState modifiers;
};

struct TriggerEntry
{
	QString name;
	QString command;
	// 0 - send command
	// 1 - change matching string color
	// 2 - change entire line color
	int type;
	bool isRegEx;
	bool setFgc;
	QColor fgc;
	bool setBgc;
	QColor bgc;
	bool setFont;
	QFont font;
};

struct ToolbarEntry
{
	QString name;
	QString icon;
	QString command;
};

class CCharacterProfile {
public: 
	/** constructor */
	CCharacterProfile();
	/** destructor */
	~CCharacterProfile();


	/** returns the filename where the data are stored */
	QString getFileName();
	/** sets the filename where the data are stored */
	void setFileName(QString);

	/** reads the data of the class from its file */
	void readData();
	/** writes the data to the class to its file */
	void writeData();

	/** reads/writes aliases */
	void readAliases();
	void writeAliases();
	
	/** read/writes toolbar entries*/
	void readToolbar();
	void writeToolbar();
	
	/** gets an alias */
	AliasEntry* getAlias(QString name);
		
	AliasEntry* firstAlias();
	AliasEntry* nextAlias();
	AliasEntry* currentAlias();
	
	/** gets a toolbar entry */
	ToolbarEntry* getToolbarEntry(QString name);
	ToolbarEntry* getToolbarEntryAt(int pos);	
	
	ToolbarEntry* firstToolbarEntry();
	ToolbarEntry* nextToolbarEntry();
	ToolbarEntry* lastToolbarEntry();
	ToolbarEntry* previousToolbarEntry();
	ToolbarEntry* currentToolbarEntry();
	
	/** Remove and add aliases */
	void insertAlias(QString name, QString def, int mac, ButtonState modifiers);
	void removeAlias(QString name);
	
	/** Remove and add toolbar entries */
	void insertToolbarEntry(QString name, QString command, QString icon);
	void removeToolbarEntry(QString name);

	/** For Triggers */
	void readTriggers();
	void writeTriggers();
	TriggerEntry* getTrigger(QString);
	TriggerEntry* firstTrigger();
	TriggerEntry* nextTrigger();
	TriggerEntry* currentTrigger();
	void insertTrigger(QString name, bool isRegEx, int type, QString command, bool setFgc, QColor fgc, bool setBgc, QColor bgc, bool setFont,  QFont font);
	void removeTrigger(QString name);	

	bool getLoggingEnabled();
	void setLoggingEnabled(bool b);
	bool getLogANSIEnabled();
	void setLogANSIEnabled(bool b);
	QString getLogFilename();
	void setLogFilename(QString filename);
	
	void setMapStartX(signed int startx);
	void setMapStartY(signed int starty);
	void setMapStartLevel(signed int start_level);
	void setMapStartZone(int start_zone);
	
	signed int getMapStartX(void);
	signed int getMapStartY(void);
	signed int getMapStartLevel(void);
	int getMapStartZone(void);

	
private:

	QString filename;
	QList<AliasEntry> aliases;
	QList<TriggerEntry> triggers;
	QList<ToolbarEntry> toolbar;

	bool loggingEnabled;
	bool logANSIEnabled;
	QString logFilename;

	int currentAliasIndex;	
	signed int currentToolbarIndex;
	int currentTriggerIndex;
	
	signed int map_start_x,map_start_y,map_start_level,map_start_zone;
};

#endif
