/***************************************************************************
                          publisher.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: publisher.h
	Last generated: Mon Oct 4 03:28:08 1999

 *********************************************************************/
#ifndef Publisher_included
#define Publisher_included

#include "publisherdata.h"
#include "publisherbase.h"
#include <qpopupmenu.h>
#include <qwidget.h>
#include <kaspaurl.h>

/** GUI-class for Publishers
 */
class Publisher : public PublisherData
{
    Q_OBJECT
private:
		Publisher(const Publisher&);
		Publisher& operator=(const Publisher&);


protected:
    PublisherBase *publisher;
		void save(bool block=false);
		KaspaURL _url;
public:

    /** Load notice from WHERE clause. Must not return more than one row. Calls init().
     */
    Publisher(KaspaURL url, Sql *conn, QWidget* parent, const char* name);

    /** Updates table, if data has changed and is not read-only. Deletes toolbar and menuitems.
				Clears any messages in the statusline.
     */
    virtual ~Publisher();

    virtual const char *url() { return _url; }

    virtual void setWorkingGUI();
    virtual void setReadOnlyGUI();
    virtual void setInvalidGUI();
    virtual void setReadWriteGUI();

    /** Locks GUI, if invalid and returns status.
     */
    virtual bool isValid();
    virtual bool isWorking() { return publisher->isWorking(); }
    virtual bool isReadOnly() { return publisher->isReadOnly(); }
    virtual bool closeRequest();
    virtual void setFields();

		KToolBar *getToolBar();

public slots:

    /** Rereads data from table. Sends message with(out) timeout to statusline (if failed).
     */
    virtual void reread();

    /** Flushes data. Sends message with timeout to statusline.
     */
    virtual void flush();

    /** Deletes row. Sends permanent messages to statusline.
     */
    virtual void del();
};

#endif

















