/***************************************************************************
                          kliste.cpp  -  description
                             -------------------
    begin                : Die Aug 17 03:44:15 CEST 1999

    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// include files for QT
#include <qdir.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qmessagebox.h>
#include <qapplication.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <qevent.h>

// application specific includes
#include <kliste.h>
#include "bibtexfile.h"
#include "resource.h"
#include "author.h"
#include "note.h"
#include "selection.h"
#include "publication.h"
#include "bibliography.h"
#include "publisher.h"
#include "part.h"
#include "partmemo.h"
#include "dataview.h"
#include "authorselect.h"
#include "noteselect.h"
#include "publselect.h"
#include "backgrseldlg.h"
#include "fileiodlg.h"
#include "search.h"
#include "searchoptions.h"
#include "parser.h"
#include "export.h"
#include <sys/types.h>
#include <sys/time.h>
#include <kstdaction.h>

bool cancelRequested=false;

bool idle(void) {
  struct timeval timeout;
  timeout.tv_sec = 0;
  timeout.tv_usec = 50;
	select (0L, 0L, 0L, 0L, &timeout);
	kapp->processEvents();
	bool c=cancelRequested;
	cancelRequested=false;
	return !c;
};

#define HANDLE_CATCH(err) err.print(); \
													QMessageBox::warning(this, i18n("Error"), err.error()); \
													slotInvalidGUI(); \
													delete view; \
										  	  view=0;

#define MAX_TOOLBARS 2

KaspalisteApp::KaspalisteApp(): config(0L), view(0L)
{
		init();
		initBackForward();
}

KaspalisteApp::KaspalisteApp(QKaspaEvent *e): config(0L), view(0L)
{
		init();
	  kapp->postEvent(this, e);
}

void KaspalisteApp::init() {
	tbdock=QMainWindow::Left;
  setXMLFile("kaspalisteui.rc");
  initAction();
	currenttools=0L;
	search_masks.setAutoDelete(true);
  createGUI(0L);
  setDockEnabled(QMainWindow::Top, true);
  setDockEnabled(QMainWindow::Left, true);
  setDockEnabled(QMainWindow::Right, true);
  setDockEnabled(QMainWindow::Bottom, true);
	
	try {
    conn=new Sql(DB_NAME);
  }  catch (SqlConnectionErr) {
		// Start postgres
		throw;
  }

  config=KGlobal::config();
  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts

  initToolBar();
  initStatusBar();
//  initKeyAccel();

  forward.setAutoDelete(FALSE);
  back.setAutoDelete(FALSE);

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
  //  disableCommand(ID_FLUSH);
  //  disableCommand(ID_AUTHOR);
//  slotDisableCommand(ID_FILE_PRINT);
//  slotDisableCommand(ID_EDIT_CUT);
/*  slotDisableCommand(ID_EDIT_COPY); */
/*  slotDisableCommand(ID_EDIT_PASTE); */
  readOptions();
	if(search_checkallxdays>0&&lastcheck.isValid() &&
			lastcheck.daysTo(QDate::currentDate())>search_checkallxdays) {
    slotSetURL("kaspa://parser?rebuild", false);
		lastcheck=QDate::currentDate();
	}
	setupWallpapers();
}

KaspalisteApp::~KaspalisteApp()
{
	delete view;
	view=0;
  delete conn;
}

void KaspalisteApp::initBackForward()  {
  back.clear();
  forward.clear();
  config->setGroup("EventStackBack");
  int count=config->readNumEntry("Count");
  for(int i=count-1; i>=0; i--) {
  	QKaspaEvent *e=new QKaspaEvent();
  	QString s("Url"); s+=QString().setNum(i);
  	e->setUrl(config->readEntry(s));
	  back.append(e);
	}
  config->setGroup("EventStackForward");
  count=config->readNumEntry("Count");
  for(int i=count-1; i>=0; i--) {
  	QKaspaEvent *e=new QKaspaEvent();
  	QString s("Url"); s+=QString().setNum(i);
  	e->setUrl(config->readEntry(s));
	  forward.append(e);
	}

	config->setGroup("CurrentEvent");
	QKaspaEvent *e=new QKaspaEvent(config->readEntry("Url"));
	kapp->postEvent(this, e);
}


void KaspalisteApp::initAction()
{
  actCopy  = KStdAction::copy(this, SLOT(slotEditCopy()), actionCollection());
  actCut   = KStdAction::cut(this, SLOT(slotEditCut()), actionCollection());
  actPaste = KStdAction::paste(this, SLOT(slotEditPaste()), actionCollection());
  actClose = KStdAction::close(this, SLOT(slotClose()), actionCollection());
  actQuit  = KStdAction::quit(this, SLOT(slotQuit()), actionCollection());

  actCreateBibTex = new KAction( "Create BibTex", 0, this, SLOT(slotCreateBibTex()), actionCollection(), "create_bibtex");
  actExport = new KAction( "Export", 0, this, SLOT(slotExport()), actionCollection(), "export");

  actAuthorOverview = new KAction( "Author Overview", 0, this, SLOT(slotAuthorOverview()), actionCollection(), "author_overview");
  actNoteOverview = new KAction( "Note Overview", 0, this, SLOT(slotNoteOverview()),  actionCollection(), "note_overview");
  actPublOverview = new KAction( "Publication Overview", 0, this, SLOT(slotPublOverview()), actionCollection(), "publ_overview");

  actNewAuthor = new KAction( "New Author", 0, this, SLOT(slotNewAuthor()), actionCollection(), "new_author");
  actNewNote   = new KAction( "New Note", 0, this, SLOT(slotNewNote()),  actionCollection(), "new_note");
  actNewPublication = new KAction( "New Publication", 0, this, SLOT(slotNewPublication()), actionCollection(), "new_publication");
  actNewPublisher   = new KAction( "New Publisher", 0, this, SLOT(slotNewPublisher()), actionCollection(), "new_publisher");

  actSearch     = new KAction( "Search", 0, this, SLOT(slotSearch()), actionCollection(), "start_search");
  actBuildIndex = new KAction( "Build Index", 0, this, SLOT(slotBuildIndex()), actionCollection(), "build_index");

  actOptionBackground = new KAction( "Background", 0, this, SLOT(slotChooseBackground()), actionCollection(), "options_background");
  actOptionSearch = new KAction( "Search", 0, this, SLOT(slotSearchOptions()), actionCollection(), "options_search");

  actNewWindow = new KAction( "New Window", 0, this, SLOT(slotNewWindow()), actionCollection(), "new_window");
  actToolBar   = new KAction( "Show Toolbar", 0, this, SLOT(slotViewToolBar()),  actionCollection(), "show_toolbar");
  actStatusBar = new KToggleAction( "Show Statusbar", 0, this, SLOT(slotViewStatusBar()), actionCollection(), "show_statusbar");

  actBack    = new KAction( "Back", "back.png", 0, this, SLOT(slotBack()),  actionCollection(), "back");
  actForward = new KAction( "Forward", "forward.png", 0, this, SLOT(slotForward()), actionCollection(), "forward");

  actBack->setEnabled(false);
  actForward->setEnabled(false);
}

void KaspalisteApp::initToolBar()
{
 	toolBar()->insertLined("", ID_URLLINE, SIGNAL(returnPressed()), this, SLOT(slotSetToolbarURL()));
 	urlline=toolBar()->getLined(ID_URLLINE);
	connect(urlline, SIGNAL(completion(void)),SLOT(slotNextFocus(void)));
	toolBar()->setItemAutoSized(ID_URLLINE);
}

void KaspalisteApp::initStatusBar()
{
  statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG );
}


void KaspalisteApp::slotEnableCommand(int id_)
{
  menuBar()->setItemEnabled(id_,true);
	toolBar()->setItemEnabled(id_,true);
	if(currenttools) currenttools->setItemEnabled(id_,true);
}

void KaspalisteApp::slotDisableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
	toolBar()->setItemEnabled(id_,false);
	if(currenttools) currenttools->setItemEnabled(id_,false);
}

void KaspalisteApp::slotSearchOptions() {
	SearchOptions dlg(this, "searchoptions");
	dlg.setCheckAllXDays(search_checkallxdays);
	dlg.setMasks(search_masks);
	dlg.setWordLimit(search_wordlimit);
	if(dlg.exec()) {
		search_checkallxdays=dlg.checkAllXDays();
		search_wordlimit=dlg.wordLimit();
		search_masks.clear();
		search_masks=dlg.masks();
		Parser *p=dynamic_cast<Parser*>(view);
		if(p) {
			p->setMasks(search_masks);
			p->setLimit(search_wordlimit);
		}
	}
}
		

void KaspalisteApp::slotChooseBackground() {
  ///////////////////////////////////////////////////////////////////
  // Choose Wallpapers
	BackgrSelDlg dlg(this, "choosebackgrdlg");
	dlg.setAuthor(authorbackgrpath);
	dlg.setPubl(selbackgrpath);
	dlg.setPart(partbackgrpath);
	dlg.setPartMemo(partmemobackgrpath);
	dlg.setNote(notebackgrpath);
	dlg.setHTML(htmlbackgrpath);
	dlg.setBiblio(bibliobackgrpath);
	dlg.setPublisher(publisherbackgrpath);
	dlg.setSelect(selbackgrpath);
	dlg.setSearch(searchbackgrpath);
	dlg.setParser(parserbackgrpath);
	dlg.setEditPartData(editpartdatabackgrpath);
	if(dlg.exec()) {
		authorbackgrpath=dlg.getAuthor();
		partbackgrpath=dlg.getPart();
		partmemobackgrpath=dlg.getPartMemo();
		publbackgrpath=dlg.getPubl();
		publisherbackgrpath=dlg.getPublisher();
		bibliobackgrpath=dlg.getBiblio();
		htmlbackgrpath=dlg.getHTML();
		notebackgrpath=dlg.getNote();
		selbackgrpath=dlg.getSelect();
		searchbackgrpath=dlg.getSearch();
		parserbackgrpath=dlg.getParser();
		editpartdatabackgrpath=dlg.getEditPartData();
		setupWallpapers();
	}
}

void KaspalisteApp::setupWallpapers() {
		authorbackgr.load(authorbackgrpath);
		partbackgr.load(partbackgrpath);
		partmemobackgr.load(partmemobackgrpath);
		publbackgr.load(publbackgrpath);
		publisherbackgr.load(publisherbackgrpath);
		bibliobackgr.load(bibliobackgrpath);
		htmlbackgr.load(htmlbackgrpath);
		notebackgr.load(notebackgrpath);
		selbackgr.load(selbackgrpath);
		searchbackgr.load(searchbackgrpath);
		parserbackgr.load(parserbackgrpath);
		editpartdatabackgr.load(editpartdatabackgrpath);
}



void KaspalisteApp::saveOptions()
{	
	if(!config) return;
  config->setGroup("General Options");
  config->writeEntry("Geometry", size() );
  config->writeEntry("Show Toolbar", toolBar()->isVisible());
  config->writeEntry("Show Statusbar",statusBar()->isVisible());
//  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBarPos",  (int)toolBar()->barPos());
  config->writeEntry("CustomToolBarPos",  (int)tbdock);

  config->writeEntry("AuthorWallpaper", authorbackgrpath);
  config->writeEntry("PartWallpaper", partbackgrpath);
  config->writeEntry("PartMemoWallpaper", partmemobackgrpath);
  config->writeEntry("PublicationWallpaper", publbackgrpath);
  config->writeEntry("SelectionWallpaper", selbackgrpath);
  config->writeEntry("NoteWallpaper", notebackgrpath);
  config->writeEntry("HTMLWallpaper", htmlbackgrpath);
  config->writeEntry("BiblioWallpaper", bibliobackgrpath);
  config->writeEntry("PublisherWallpaper", publisherbackgrpath);
	config->writeEntry("SearchWallpaper", searchbackgrpath);
	config->writeEntry("ParserWallpaper", parserbackgrpath);
	config->writeEntry("EditPartDataWallpaper", editpartdatabackgrpath);


  config->writeEntry("CheckAllXDays", search_checkallxdays);
  config->writeEntry("WordLimit", search_wordlimit);
	config->writeEntry("Masks", search_masks);
	config->writeEntry("LastCheckYear", lastcheck.year());
	config->writeEntry("LastCheckMonth", lastcheck.month());
	config->writeEntry("LastCheckDay", lastcheck.day());

  config->setGroup("EventStackBack");
  int c=back.count()<=10?back.count():10;
  config->writeEntry("Count", c);
  for(int i=0; i<c; i++) {
  	QKaspaEvent *e=back.getLast();
  	back.removeLast();
	  QString s("Url"); s+=QString().setNum(i);
	  config->writeEntry(s, (const char*) e->url());
	  delete e;
	}
  config->setGroup("EventStackForward");
  c=forward.count()<=10?forward.count():10;
  config->writeEntry("Count", c);
  for(int i=0; i<c; i++) {
  	QKaspaEvent *e=forward.getLast();
  	forward.removeLast();
	  QString s("Url"); s+=QString().setNum(i);
	  config->writeEntry(s, (const char*) e->url());
	  delete e;
	}

	config->setGroup("CurrentEvent");
	if(view && view->getState()==INVALID)
		config->writeEntry("Url", "kaspa://overview");
	else
		config->writeEntry("Url", view?view->url():"kaspa://overview");
}


void KaspalisteApp::readOptions()
{
  config->setGroup("General Options");

  // bar status settings
  /*
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  if(!bViewToolbar && toolBar())
    toolBar()->hide();
*/
  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  if(!bViewStatusbar && statusBar()) {
    statusBar()->hide();
 		actStatusBar->setChecked(false);
 	}
 	else {
    statusBar()->show();
 		actStatusBar->setChecked(true);
	}
	
  // bar position settings
  KToolBar::BarPosition tool_bar_pos;
  tool_bar_pos=(KToolBar::BarPosition)config->readNumEntry("ToolBarPos", KToolBar::Top);

  toolBar()->setBarPos(tool_bar_pos);

  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
    resize(size);

	tbdock=QMainWindow::ToolBarDock(config->readNumEntry("CustomToolBarPos", QMainWindow::Left));

	// Wallpapers
  authorbackgrpath=config->readEntry("AuthorWallpaper");
  partbackgrpath=config->readEntry("PartWallpaper");
  partmemobackgrpath=config->readEntry("PartMemoWallpaper");
  publbackgrpath=config->readEntry("PublicationWallpaper");
  selbackgrpath=config->readEntry("SelectionWallpaper");
  notebackgrpath=config->readEntry("NoteWallpaper");
  htmlbackgrpath=config->readEntry("HTMLWallpaper");
  bibliobackgrpath=config->readEntry("BiblioWallpaper");
  publisherbackgrpath=config->readEntry("PublisherWallpaper");
	searchbackgrpath=config->readEntry("SearchWallpaper");
	parserbackgrpath=config->readEntry("ParserWallpaper");
	editpartdatabackgrpath=config->readEntry("EditPartDataWallpaper");
  search_checkallxdays=config->readNumEntry("CheckAllXDays");
  search_wordlimit=config->readNumEntry("WordLimit");
	config->readListEntry("Masks", search_masks);
	lastcheck.setYMD(config->readNumEntry("LastCheckYear"),
									 config->readNumEntry("LastCheckMonth"),
									 config->readNumEntry("LastCheckDay") );

}

void KaspalisteApp::saveProperties(KConfig* )
{
}

void KaspalisteApp::readProperties(KConfig*)
{
}		

bool KaspalisteApp::queryClose()
{	
  return view ? view->close() : TRUE;
}

bool KaspalisteApp::queryExit()
{
  saveOptions();
  return true;
}

bool KaspalisteApp::cleanupView() {

	if(view&&!view->close()) return false;
	else {
		delete view;
		view=0;
	}

	return true;
}

void KaspalisteApp::setupView(const QPixmap &pm) {
	ASSERT(view);
	int i;
	bool n;
	int j;
	if(currenttools) {
	  getLocation(currenttools, tbdock, i, n, j);
		delete currenttools; currenttools=0;
	}
	
	menuBar()->setUpdatesEnabled(false);
	view->setBackgroundPixmap(pm);
	kaspaConnections(view);
	setCentralWidget(view);

	currenttools=view->getToolBar();
  if(currenttools)
		addToolBar(currenttools, tbdock);

	menuBar()->setUpdatesEnabled(true);

	menuBar()->repaint();
	view->show();
	view->setFields();
	if(currenttools)
    moveToolBar(currenttools, tbdock);
}

////////////////////////////////////////////////////////////////////
//  build up views...
////////////////////////////////////////////////////////////////////

void KaspalisteApp::slotAuthorOverview() {
  slotSetURL("kaspa://authoroverview#order by lastname", false);
}

void KaspalisteApp::slotNoteOverview() {
  slotSetURL("kaspa://noteoverview#where type=0 order by title", false);
}

void KaspalisteApp::slotPublOverview() {
  slotSetURL("kaspa://publicationoverview#order by title", false);
}

void KaspalisteApp::slotNewAuthor() {
  slotSetURL("kaspa://author?new", false);
}

void KaspalisteApp::slotNewNote() {
  slotSetURL("kaspa://note?new", false);
}

void KaspalisteApp::slotNewPublication() {
  slotSetURL("kaspa://publication?new", false);
}

void KaspalisteApp::slotNewPublisher() {
  slotSetURL("kaspa://publisher?new", false);
}

void KaspalisteApp::slotSearch() {
  slotSetURL("kaspa://search", false);
}

void KaspalisteApp::slotBuildIndex() {
  slotSetURL("kaspa://parser", false);
}

bool KaspalisteApp::showAuthorOverview(KaspaURL url, const char *caption) {
  try {
		if(!cleanupView()) return false;
    view = new AuthorSelect(url, conn, caption?caption:"Authors", this);
		setupView(selbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showPublOverview(KaspaURL url, const char *caption) {
  try {
		if(!cleanupView()) return false;
    view = new PublSelect(url, conn, caption?caption:"Publications", this);
		setupView(selbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}


bool KaspalisteApp::showNoteOverview(KaspaURL url, const char *caption=0) {
  try {
		if(!cleanupView()) return false;
    view = new NoteSelect(url, conn, caption?caption:"Links", this);
		setupView(selbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showAuthor(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new Author(url, conn, this, "Author");
		setupView(authorbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showPart(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new Part(url, conn, this, "Part");
		setupView(partbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showPublication(KaspaURL url) {
  try {
		debug("KaspalisteApp::showPublication() - url=%s", (const char *) url);
		
		if(!cleanupView()) return false;
    view = new Publication(url, conn, this, "Publication");
		setupView(publbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}


bool KaspalisteApp::showPartMemo(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new PartMemo(url, conn, this, "PartMemo");
		setupView(partmemobackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}


bool KaspalisteApp::showBibliography(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new Bibliography(url, conn, this, "Bibliography");
		setupView(bibliobackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showNote(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new Note(url, conn, this, "Note");
		setupView(notebackgr);
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showDataView(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new DataView(url, conn, this, "Data");
		setupView(htmlbackgr);
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}


bool KaspalisteApp::showPublisher(KaspaURL url) {
  try {
		if(!cleanupView()) return false;

    view = new Publisher(url, conn, this, "Publisher");
		setupView(publisherbackgr);
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showEditPartData(KaspaURL url) {
  try {
		if(!cleanupView()) return false;

    view = new FileIODlg(url, conn, this, "EditPartData");
		setupView(editpartdatabackgr); // <-- another Background???
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}


bool KaspalisteApp::showSearch(KaspaURL url) {
  try {
		if(!cleanupView()) return false;

    view = new Search(url, conn, this, "Search");
		setupView(searchbackgr); // <-- another Background???
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showParser(KaspaURL url) {
  try {
		if(!cleanupView()) return false;

    view = new Parser(search_wordlimit, search_masks, url, conn, this, "Parser");
		setupView(parserbackgr); // <-- another Background???
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

///////////////////////////////////////////////////////////////
// event handling
//////////////////////////////////////////////////////////////
bool KaspalisteApp::event(QEvent *e) {
	//	debug("KaspalisteApp::event()");
	if(e->type()==QEvent::User) {
		QKaspaEvent *k=static_cast<QKaspaEvent*>(e);
		ASSERT(e);
		KaspaURL url(k->url());
		toolBar()->setLinedText(ID_URLLINE, url);
		debug("KaspalisteApp::event(QEvent*) - url=%s", (const char *)url);
//		debug("KaspalisteApp::event(QEvent*) - table=%s", (const char *)url.table());
    if(!strcmp(url.table(), "author")) showAuthor(url);
		
    if(!strcmp(url.table(), "publication")) showPublication(url);

    if(!strcmp(url.table(), "publisher")) showPublisher(url);
		
    if(!strcmp(url.table(), "bibliography")) showBibliography(url);
		
    if(!strcmp(url.table(), "partmemo")) showPartMemo(url);
		
    if(!strcmp(url.table(), "part")) showPart(url);
		
    if(!strcmp(url.table(), "partdata")) showDataView(url);
		
    if(!strcmp(url.table(), "authoroverview")) showAuthorOverview(url, "Author Overview");

    if(!strcmp(url.table(), "note")) showNote(url);
		
    if(!strcmp(url.table(), "noteoverview")) showNoteOverview(url, "Note Overview");

    if(!strcmp(url.table(), "publicationoverview")) showPublOverview(url, "Publication Overview");

    if(!strcmp(url.table(), "editpartdata")) showEditPartData(url);

    if(!strcmp(url.table(), "search")) showSearch(url);

    if(!strcmp(url.table(), "parser")) showParser(url);

		setupBackForward();
    return TRUE;
  }	
  return MainWindow::event(e);			
}				

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KaspalisteApp::setupBackForward() {
  if(back.count()<1 || (view && view->getState()==WORKING))
    actBack->setEnabled(false);
  else
    actBack->setEnabled(true);

  if(forward.isEmpty() || (view && view->getState()==WORKING))
	  actForward->setEnabled(false);
	else
    actForward->setEnabled(true);
}

void KaspalisteApp::slotNextFocus() {
	focusNextPrevChild(true);
}

void KaspalisteApp::slotBack() {
  qDebug("\nKaspalisteApp::slotBack() - count back=%i", back.count());
	if(view && view->getState()!=INVALID)
		forward.append(new QKaspaEvent(view->url(), view->caption()));
  QEvent *ev= back.getLast();
  if(ev)
    kapp->postEvent(this, ev);
  back.removeLast();
	setupBackForward();
}

void KaspalisteApp::slotForward() {
	if(view && view->getState()!=INVALID)
		back.append(new QKaspaEvent(view->url(), view->caption()));
  kapp->postEvent(this, forward.getLast());
  forward.removeLast();
	setupBackForward();
}	


void KaspalisteApp::slotSetURL(const char *url, bool newwin) {
	slotSetURL(url, newwin, "");
}

void KaspalisteApp::slotSetURL(const char *url, bool newwin, const char *caption) {
	if(!newwin && view && view->getState()!=INVALID)
		back.append(new QKaspaEvent(view->url(), view->caption()));

	QKaspaEvent *e = new QKaspaEvent();
	e->setUrl(url);
	e->setCaption(caption);
	if(newwin) {
		KaspalisteApp* new_window= new KaspalisteApp(e);
		new_window->show();
	}
	else {
		kapp->postEvent(this, e);
		forward.clear();
		slotDisableCommand(ID_FORWARD);
	}
}

void KaspalisteApp::slotNewWindow()
{
  slotStatusMsg(i18n("Opening a new Application window..."));

  KaspalisteApp* new_window=new KaspalisteApp();
  new_window->show();
}


void KaspalisteApp::slotClose()
{
  slotStatusMsg(i18n("Closing file..."));
  close();
}

void KaspalisteApp::slotPrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this)){
    //			view->print(&printer);
  }

}

void KaspalisteApp::slotQuit()
{
  // saveOptions();
  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
  KMainWindow* w;
  if(memberList){
    for(w=memberList->first(); w; w=memberList->first()){
      // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
      // the window and the application stay open.
      if(!w->close())
	break;
    }
  }	
}

void KaspalisteApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));
  if(view) view->cut();
}

void KaspalisteApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to Clipboard..."));
  if(view) view->copy();
}

void KaspalisteApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting Clipboard contents..."));
  if(view) view->paste();
}

void KaspalisteApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  /*
  if( view_menu->isItemChecked(ID_VIEW_TOOLBAR))
    view_menu->setItemChecked(ID_VIEW_TOOLBAR, false);
  else
    view_menu->setItemChecked(ID_VIEW_TOOLBAR, true);
*/
  // enableToolBar();
}

void KaspalisteApp::slotViewStatusBar()
{
  if(statusBar() && statusBar()->isVisible()) {
		statusBar()->hide();
		actStatusBar->setChecked(false);
  }
  else {
		statusBar()->show();
		actStatusBar->setChecked(true);
  }
  	


  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  /*
  if( view_menu->isItemChecked(ID_VIEW_STATUSBAR))
    view_menu->setItemChecked(ID_VIEW_STATUSBAR, false);
  else
    view_menu->setItemChecked(ID_VIEW_STATUSBAR, true);
*/
  // enableStatusBar();
}


void KaspalisteApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void KaspalisteApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}

void KaspalisteApp::slotSetToolbarURL() {
	slotSetURL(toolBar()->getLinedText(ID_URLLINE), false);
}

void KaspalisteApp::slotInvalidGUI() {
  actCopy->setEnabled(true);
	actCut->setEnabled(true);
	actPaste->setEnabled(false);
	actClose->setEnabled(true);
	actQuit->setEnabled(true);
	
	actCreateBibTex->setEnabled(true);
	actExport->setEnabled(true);
	actAuthorOverview->setEnabled(true);
	actNoteOverview->setEnabled(true);
	actPublOverview->setEnabled(true);
	actNewAuthor->setEnabled(true);
	actNewNote->setEnabled(true);
	actNewPublication->setEnabled(true);
	actNewPublisher->setEnabled(true);
	actSearch->setEnabled(true);
	actBuildIndex->setEnabled(true);
	actOptionBackground->setEnabled(true);
	actOptionSearch->setEnabled(true);
	actNewWindow->setEnabled(true);
	actToolBar->setEnabled(true);
	actStatusBar->setEnabled(true);
	
	urlline->setEnabled(true);
	slotStatusMsg(i18n("Invalid!"));
	setupBackForward();
}

void KaspalisteApp::slotWorkingGUI() {
  actCopy->setEnabled(true);
	actCut->setEnabled(true);
	actPaste->setEnabled(true);
	actClose->setEnabled(false);
	actQuit->setEnabled(false);

	actCreateBibTex->setEnabled(false);
	actExport->setEnabled(false);
	actAuthorOverview->setEnabled(false);
	actNoteOverview->setEnabled(false);
	actPublOverview->setEnabled(false);
	actNewAuthor->setEnabled(false);
	actNewNote->setEnabled(false);
	actNewPublication->setEnabled(false);
	actNewPublisher->setEnabled(false);
	actSearch->setEnabled(false);
	actBuildIndex->setEnabled(false);
	actOptionBackground->setEnabled(false);
	actOptionSearch->setEnabled(false);
	actNewWindow->setEnabled(true);
	actToolBar->setEnabled(false);
	actStatusBar->setEnabled(false);
	
	urlline->setEnabled(false);
	slotStatusMsg(i18n("Working..."));
	setupBackForward();
}

void KaspalisteApp::slotReadWriteGUI() {
  actCopy->setEnabled(true);
	actCut->setEnabled(true);
	actPaste->setEnabled(true);
	actClose->setEnabled(true);
	actQuit->setEnabled(true);
	
	actCreateBibTex->setEnabled(true);
	actExport->setEnabled(true);
	actAuthorOverview->setEnabled(true);
	actNoteOverview->setEnabled(true);
	actPublOverview->setEnabled(true);
	actNewAuthor->setEnabled(true);
	actNewNote->setEnabled(true);
	actNewPublication->setEnabled(true);
	actNewPublisher->setEnabled(true);
	actSearch->setEnabled(true);
	actBuildIndex->setEnabled(true);
	actOptionBackground->setEnabled(true);
	actOptionSearch->setEnabled(true);
	actNewWindow->setEnabled(true);
	actToolBar->setEnabled(true);
	actStatusBar->setEnabled(true);

	urlline->setEnabled(true);
	slotStatusMsg(i18n("Ready..."));
	setupBackForward();
}

void KaspalisteApp::slotReadOnlyGUI() {
  actCopy->setEnabled(true);
	actCut->setEnabled(true);
	actPaste->setEnabled(false);
	actClose->setEnabled(true);
	actQuit->setEnabled(true);
	
	actCreateBibTex->setEnabled(true);
	actExport->setEnabled(true);
	actAuthorOverview->setEnabled(true);
	actNoteOverview->setEnabled(true);
	actPublOverview->setEnabled(true);
	actNewAuthor->setEnabled(true);
	actNewNote->setEnabled(true);
	actNewPublication->setEnabled(true);
	actNewPublisher->setEnabled(true);
	actSearch->setEnabled(true);
	actBuildIndex->setEnabled(true);
	actOptionBackground->setEnabled(true);
	actOptionSearch->setEnabled(true);
	actNewWindow->setEnabled(true);
	actToolBar->setEnabled(true);
	actStatusBar->setEnabled(true);

	urlline->setEnabled(true);
	slotStatusMsg(i18n("Read-Only..."));
	setupBackForward();
}


void KaspalisteApp::kaspaConnections(KaspaWidget *w) {
	connect(w, SIGNAL(statusMessage(const char*)), SLOT(slotStatusHelpMsg(const char *)));
	connect(w, SIGNAL(enableCommand(int)), SLOT(slotEnableCommand(int)));
	connect(w, SIGNAL(enableCommand(int,bool)), SLOT(slotEnableCommand(int,bool)));
	connect(w, SIGNAL(disableCommand(int)), SLOT(slotDisableCommand(int)));
	connect(w, SIGNAL(requestURL(const char *,bool)), SLOT(slotSetURL(const char *,bool)));
	connect(w, SIGNAL(requestURL(const char *,bool, const char *)),
						 SLOT(slotSetURL(const char *, bool, const char *)));
  connect(w, SIGNAL(workingGUI()), SLOT(slotWorkingGUI()));
  connect(w, SIGNAL(invalidGUI()), SLOT(slotInvalidGUI()));
  connect(w, SIGNAL(readOnlyGUI()), SLOT(slotReadOnlyGUI()));
  connect(w, SIGNAL(readWriteGUI()), SLOT(slotReadWriteGUI()));

  connect(w, SIGNAL(modifyGUI(KParts::Part *)), SLOT(createGUI(KParts::Part *)));
}


void KaspalisteApp::slotCreateBibTex() {
	try {
		if(view) view->flush();
		BibTexFile b;
		b.exec();
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
  }
}

void KaspalisteApp::slotExport() {
	try {
 		Export e;
		e.exec();
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
  }
}
