/***************************************************************************
                          bibtexfile.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: bibtexfile.cpp
	Last generated: Sat Jul 29 01:20:05 2000

 *********************************************************************/

#include <kmessagebox.h>
#include <kapp.h>
#include <qfile.h>

#include "bibtexfile.h"
#include "resource.h"

#define Inherited BibTexFileData

BibTexFile::BibTexFile(QWidget* parent,	const char* name)	:
	Inherited( parent, name ), Sql(DB_NAME), cancelaction(false) {
	cancelbutton->setEnabled(false);
	startbutton->setEnabled(true);
}

void BibTexFile::start() {
	startbutton->setEnabled(false);
	cancelbutton->setEnabled(true);
	QString filename=filenameline->text();

	QFile f(filename);
	if(!f.open(IO_WriteOnly)) {
		KMessageBox::error(this, "Can't open file!", "Error");
		reject();
		return;
	}

	progress->setTotalSteps(1000);
	Sql::exec("begin");
	Sql::exec("select bibtex from part where createbibtex='t' and bibtex!=0");
	for(int i=0; i<tuples(); i++) {
		const char *buf=getValue(i, "bibtex");
		if(!f.writeBlock(buf, strlen(buf))==-1) {
			Sql::exec("rollback");
			KMessageBox::error(this, "Can't write file!", "Error");
			reject();
			return;
		}

    if(cancelaction) {
      Sql::exec("rollback");
			reject();
			return;
		}
		
		kapp->processEvents();
		progress->setProgress(i*500/tuples());
	}
	Sql::exec("select bibtex from publication where createbibtex='t' and bibtex!=0");
	for(int i=0; i<tuples(); i++) {
		const char *buf=getValue(i, "bibtex");
		if(!f.writeBlock(buf, strlen(buf))==-1) {
			Sql::exec("rollback");
			KMessageBox::error(this, "Can't write file!", "Error");
			reject();
			return;
		}

    if(cancelaction) {
      Sql::exec("rollback");
			reject();
			return;
		}

		kapp->processEvents();
		progress->setProgress(i*500/tuples()+500);
	}

	f.close();
	accept();
}

void BibTexFile::cancel() {
	cancelaction=true;
	cancelbutton->setEnabled(false);
}

BibTexFile::~BibTexFile() {
}



