/***************************************************************************
                          sysinfo.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Jun  9 13:11:44 CEST 1999
                                           
    copyright            : (C) 1999 by Enrico Schulz                         
    email                : emmy@online.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#define VERSION "0.1"
#include "sysinfo.h"
#include <kmsgbox.h>

Sysinfo::Sysinfo(QWidget*parent,const char* name):QWidget(parent,name){
initializewindow();
}
Sysinfo::~Sysinfo(){
system("echo end of program");
}

void Sysinfo::initializewindow()
{
// Install the Timmer (running)
  system("echo initializewindow");
  this->resize(345, 150);
  timer = new QTimer(this);
  timer->start(10, false);
  connect(timer, SIGNAL(timeout()), SLOT(updateall()));

  getmeminfo();

  swapprogress = new KProgress(0, (info.totalswap/(1024)),(info.freeswap/(1024)),KProgress::Horizontal, this, "swapprogress");
  swapprogress->setGeometry(270, 0, 60, 30);

  ramprogress = new KProgress(0,(info.totalram/(1024)),(info.freeram/(1024)), KProgress::Horizontal, this, "ramprogress");
  ramprogress->setGeometry(90, 0, 60, 30);

  totalram = new QLabel(this, "physical");
  totalram->setGeometry(0, 0, 90,30);
  totalram->setText(i18n("physical"));

  totalram = new QLabel(this, "totallabel");
  totalram->setGeometry(0, 30, 90, 30);
  totalram->setText(i18n("Total Ram"));

  totalram = new QLabel(this, "totalram");
  totalram->setGeometry(90, 30, 90, 30);
  totalram->setText(format(info.totalram));

  swapram = new QLabel(this, "virtual");
  swapram->setGeometry(180, 0, 90, 30);
  swapram->setText(i18n("virtual"));

  swapram = new QLabel(this, "swaplabel");
  swapram->setGeometry(180, 30, 90, 30);
  swapram->setText(i18n("Total Swap"));

  swapram = new QLabel(this, "totalswap");
  swapram->setGeometry(270, 30, 90, 30);
  swapram->setText(format(info.totalswap));

  freeswapram = new QLabel(this, "freeswaplabel");
  freeswapram->setGeometry(180, 60, 90, 30);
  freeswapram->setText(i18n("Free Swap"));

  freeswapram = new QLabel(this, "freeswap");
  freeswapram->setGeometry(270, 60, 90, 30);
  freeswapram->setText(format(info.freeswap));

  freeram = new QLabel(this, "freeramlabel");
  freeram->setGeometry(0, 60, 90, 30);
  freeram->setText(i18n("Free Ram"));

  freeram = new QLabel(this, "freeram");
  freeram->setGeometry(90, 60, 90, 30);
  freeram->setText(format(info.freeram));

  sharedram = new QLabel(this, "sharedramlabel");
  sharedram->setGeometry(0, 90, 90, 30);
  sharedram->setText(i18n("Shared Ram"));

  sharedram = new QLabel(this, "sharedram");
  sharedram->setGeometry(90, 90, 90, 30);
  sharedram->setText(format(info.sharedram));

  bufferedram = new QLabel(this, "bufferedramlabel");
  bufferedram->setGeometry(180, 90, 90, 30);
  bufferedram->setText("Buffered Ram");

  bufferedram = new QLabel(this, "bufferedram");
  bufferedram->setGeometry(270, 90, 90, 30);
  bufferedram->setText(format(info.bufferram));

  infobutton = new QPushButton(this, "infobutton");
  infobutton->setGeometry(0, 120, 60, 30);
  infobutton->setText(i18n("&Info"));
  connect(infobutton, SIGNAL(clicked()), SLOT(infoclicked()));

  quitbutton = new QPushButton(this, "quitbutton");
  quitbutton->setGeometry(240, 120, 60, 30);
  quitbutton->setText(i18n("&Exit"));
  connect(quitbutton, SIGNAL(clicked()), SLOT(exitthis()));

  system("echo end of initialization");
}

void Sysinfo::getmeminfo()
{
  syscall(SYS_sysinfo, &info);
}

void Sysinfo::updateall()
{
  getmeminfo();
  ramprogress->setValue((info.freeram/(1024)));
  swapprogress->setValue((info.freeswap/(1024)));
  totalram->setText(format(info.totalram));
  swapram->setText(format(info.totalswap));
  freeswapram->setText(format(info.freeswap));
  freeram->setText(format(info.freeram));
  sharedram->setText(format(info.sharedram));
  bufferedram->setText(format(info.bufferram));
}

QString Sysinfo::format(unsigned long value)
{
  QString  text;
  text.sprintf("%10ld", value);
  return text;
}

void Sysinfo::infoclicked()
{
  system("echo info clicked");
  KMsgBox::message(this, i18n("Info to Sysinfo"), i18n("Sysinfo show your Memoryinfo\n\nVersion 0.1"));
}

void Sysinfo::exitthis()
{
  system("echo exitthis clicked");
  close();
}