// Local includes
#include "startupwizard.h"
#include "wizardpage.h"
#include "modintro.h"
#include "modcolumns.h"
#include "moddlgproperties.h"
#include "modstartdatabase.h"
#include "modstartlistview.h"
#include "moddefaultsdatabase.h"

// Stdlib includes
// QT includes
#include <qfont.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qwidget.h>

// KDE includes
#include <kiconloader.h>
#include <kapp.h>
#include <kconfig.h>

#include <iostream.h>

StartupWizard::StartupWizard(QWidget* parent, const char* name) : KWizard(parent, name, true)
{
  setCaption("PeopleSpace Startup Wizard");
 
  setOkButton(i18n("&Finish"));
  connect(this, SIGNAL( okclicked() ), this, SLOT( slotOkClicked() ));

  resize(440, 460);

  fModuleList.setAutoDelete( true );

  initModules();
 
}

StartupWizard::~StartupWizard()
{
  fModuleList.clear();
}

void StartupWizard::slotOkClicked()
{
  saveAllOptions();

  accept();
}

void StartupWizard::initModules()
{
   WizardPage* psWizardPage;
   
   psWizardPage = new WizardPage(this);
   ModIntro* module1 = new ModIntro(psWizardPage, "module_intro");
   createWizardPage(psWizardPage, module1);

   psWizardPage = new WizardPage(this);
   ModColumns *module2 = new ModColumns(psWizardPage, "module_columns");
   createWizardPage(psWizardPage, module2);
   
   psWizardPage = new WizardPage(this);
   ModDlgProperties *module3 = new ModDlgProperties(psWizardPage, "module_dlgproperties");
   createWizardPage(psWizardPage, module3);

   psWizardPage = new WizardPage(this);
   ModStartDatabase *module4 = new ModStartDatabase(psWizardPage, "module_startdatabase");
   createWizardPage(psWizardPage, module4);

   psWizardPage = new WizardPage(this);
   ModStartListView *module5 = new ModStartListView(psWizardPage, "module_startlistview");
   createWizardPage(psWizardPage, module5);

   psWizardPage = new WizardPage(this);
   ModDefaultsDatabase *module6 = new ModDefaultsDatabase(psWizardPage, "module_defaultsdatabase");
   createWizardPage(psWizardPage, module6);
}

void StartupWizard::createWizardPage(WizardPage* psWizardPage, ConfigModuleBase* module)
{
  fModuleList.append(module);

  psWizardPage->setContents(module);

  KWizardPage* wizardPage = new KWizardPage;
  wizardPage->title = i18n(module->sectionAndTitle());
  wizardPage->enabled = true;
  wizardPage->w = psWizardPage;

  addPage(wizardPage);
}

void StartupWizard::saveAllOptions()
{
 ConfigModuleBase* module;
  
  module = fModuleList.first();
  while (module != NULL)
    {
      module->saveOptions();
      module = fModuleList.next();
    }

  // Make sure the config file is synced
  KConfig* config =  kapp->getConfig();
  config->sync();
}



#include "startupwizard.moc"
