// KDE includes
#include <kconfig.h>
#include <kapp.h>
#include <knewpanner.h>

// QT includes
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qcombobox.h>
#include <qsplitter.h>

// Local includes
#include "psentryviewer.h"
#include "psentry.h"
#include "upperwidget.h"
#include "lowerwidget.h"
#include "psdatabasemanager.h"

// Stdlib includes
#include <iostream.h>

PSEntryViewer::PSEntryViewer(PSDatabaseManager* databaseManager, QWidget *parent, const char *name)
        : QWidget(parent, name)
{
  fPSDatabaseManager = databaseManager;
  connect(fPSDatabaseManager, SIGNAL( setViewedEntry(PSEntry*, bool, bool) ), this, SLOT( slotSetViewedEntry(PSEntry*, bool, bool) ));

  fSplitter = new QSplitter(QSplitter::Vertical, this, "HorizSplitter");
  fSplitter->setGeometry(0, 0, this->width(), this->height());

  // Create the two widgets to be the top and bottom elements of the panner
  fUpperWidget = new UpperWidget(fSplitter, "UpperWidget");
  fLowerWidget = new LowerWidget(fSplitter, "LowerWidget");
  connect(fUpperWidget, SIGNAL( unsavedDataExists() ), this, SLOT( slotUnsavedDataExists() ));
  connect(fLowerWidget, SIGNAL( unsavedDataExists() ), this, SLOT( slotUnsavedDataExists() ));

  fViewedEntry = NULL;
  fViewedEntryModified = false;

  thereIsASelectedEntry( false );
}

PSEntryViewer::~PSEntryViewer()
{
  delete(fUpperWidget);
  delete(fLowerWidget);

  delete(fSplitter);
}

void PSEntryViewer::saveYourself()
{
}

void PSEntryViewer::thereIsASelectedEntry(bool state)
{
  
      fUpperWidget->thereIsASelectedEntry(state);
      fLowerWidget->thereIsASelectedEntry(state);
   
}

void PSEntryViewer::saveCurrentlyViewedEntry()
{
  if (!fViewedEntryModified)
    return;

  fViewedEntryModified = FALSE; 
  
  if (fViewedEntry == NULL)
    return;
  
  //cout << "Saving current entry" << endl;

  fUpperWidget->saveCurrentlyViewedEntry(fViewedEntry);
  fLowerWidget->saveCurrentlyViewedEntry(fViewedEntry);
}


void PSEntryViewer::setCurrentlyViewedEntry(PSEntry* entry)
{
   if (fViewedEntryModified)
    saveCurrentlyViewedEntry();
  
  if (entry == NULL)
    {
      thereIsASelectedEntry( FALSE );
      fViewedEntry = NULL;
      return;
    }

  if (fViewedEntry == NULL)
    thereIsASelectedEntry( TRUE );
  fViewedEntry = entry;

  //cout << "Setting view to: " << entry->key() << endl;

  fUpperWidget->setCurrentlyViewedEntry(entry);
  fLowerWidget->setCurrentlyViewedEntry(entry);
  
}

void PSEntryViewer::setCurrentlyViewedEntryDeleted()
{
  fUpperWidget->setCurrentlyViewedEntryDeleted(!fViewedEntry->deleteMe());

  fViewedEntry->setDeleteMe(!fViewedEntry->deleteMe());
}

void PSEntryViewer::resizeEvent ( QResizeEvent * e) 
{
  QWidget::resizeEvent(e);
  
  //fPanner->setGeometry(0, 0, this->width(), this->height());
  fSplitter->setGeometry(0, 0, this->width(), this->height());
  //cout << "Resizing to " << "Width: " << this->width() << "  Height: " << this->height() << endl;
}


///////////////////////////////////////////////
/////////////////  SLOTS //////////////////////
void PSEntryViewer::slotUnsavedDataExists()
{
  if (!gUnsavedData)
    emit unsavedDataExists();

  fUpperWidget->setCurrentlyViewedEntryModified();
  gUnsavedData = TRUE;
  fViewedEntryModified = TRUE;
}

void PSEntryViewer::slotSetViewedEntry(PSEntry* entry, bool, bool)
{
  if (fViewedEntryModified)
    saveCurrentlyViewedEntry();
  
  if (entry == NULL)
    {
      thereIsASelectedEntry( FALSE );
      fViewedEntry = NULL;
      return;
    }

  thereIsASelectedEntry( TRUE );
  fViewedEntry = entry;

  setCurrentlyViewedEntry(entry);
}

#include "psentryviewer.moc"
