#ifndef DATEPICKERDIALOG_H
#define DATEPICKERDIALOG_H

// KDE includes
class KDatePicker;

// QT includes
#include <qdialog.h>
#include <qwidget.h>
#include <qdatetime.h>
class QPushButton;

/** Provides a Date pick dialog which allows user to pick a date. This class
 * uses the KDatePicker class
 *
 * @author Mike Pilone
 */
class DatePickerDialog : public QDialog
{
  Q_OBJECT

public:
  DatePickerDialog(QWidget* parent, const char* name, QDate date = QDate::currentDate());
  ~DatePickerDialog();

  /** Returns the QDate that was chosen
   */
  QDate selectedDate();

private:
  /** The actual KDatePicker widget
   */
  KDatePicker* fDatePicker;

  /** The date will be stored here. This allows it to be retrieved later when the 
   * dialog is closed
   */
  QDate fPickedDate;

  QPushButton* fOk;

public slots:
  /** This slot will be triggered when the dateSelected signal is transmitted
   * from the KDatePicker
   */
  void slotDateSelected(QDate);
};

#endif
