#ifndef __CONFIGMODULEBASE_H_
#define __CONFIGMODULEBASE_H_

// QT includes
#include <qwidget.h>
#include <qstring.h>

class ConfigModuleBase : public QWidget
{
Q_OBJECT

public:
  ConfigModuleBase(QString title, QString section, QWidget* parent, const char* name);
  ~ConfigModuleBase() {};

  virtual void saveOptions() {};
  
  /** Returns the section this module should be in
   */
  QString section() { return fSection; };
  
  /** Returns the title of this module
   */
  QString title() { return fTitle; };

  /** Returns the section and title in one string, with the format: "Section - Title"
   */
  QString sectionAndTitle() { return fSection + " - " + fTitle; };

  
private:
  QString fTitle, fSection;
};

#endif
