#ifndef __COM_MANAGER_H_
#define __COM_MANAGER_H_

// QT includes
#include <qobject.h>

// KDE includes
class KSocket;

/** This is the communication manager. Basically it will listen to a socket and
 * read the data off the socket. It will then try to figure out what the information
 * and respond top it.
 */
class ComManager : public QObject
{
  Q_OBJECT

public:
  ComManager(KSocket* socket);
  ComManager();

  ~ComManager();

  /** Sets the socket to listen too
   */
  void setSocket(KSocket* socket);

  /** Writes 'command' to the socket if it is open. It will also send 'param' as a
   * parameter to the command if needed.
   */
  void sendCommand(int commandId, QString param = "");

  /** Returns weather the comManager is connected to anything through
   * it's socket. This method basically just checks to see if fSocket is NULL
   */
  bool connected();
   

private:
  KSocket* fSocket;

public slots:
  void slotReadEvent(KSocket*);

  void slotConnectionBroken();

signals:
  /** Emitted when the connection to the socket is broken. 
   */
  void connectionBroken();

  /** Emitted when data is read from the socket
   */
  void receiveCommand(int, QString);

};

#endif
