/***************************************************************************
                          dlgnew.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    kweather - a program for recording weather events
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    
#include "dlgnew.h"
#include <qmessagebox.h>
#include <kcolordlg.h>
#include <qapplication.h>
#include <stdlib.h>

#define XL 200      // X-Position der Labels
#define XF 310      // x-Position der Edit-Felder

extern char* MonName[];
extern struct GridSettingsType GridDefaults;

NewDlg::NewDlg(QWidget* parent=0, const char* name=0):
     QDialog (parent, name, WStyle_DialogBorder)
{
int Lauf;
QDate date;
KIconLoader iconloader;

   setFixedSize(500,500);
   setCaption(i18n("Create new File"));
   CurrItem=NULL;
   Chart=(TChart*)parent;
debug("CHART %s",GridDefaults.LineUnits);

   SigMap = new QSignalMapper(this,"SigMap");
   connect(SigMap, SIGNAL(mapped(int)), this, SLOT(TimeBtnClick(int)));

   // Icons fr den Treeview laden
   IconArr[TYP_GROUP] = iconloader.loadIcon("kweather//f_group.xpm");
   IconArr[TYP_LINE] = iconloader.loadIcon("kweather//f_chart.xpm");
   IconArr[TYP_PRESSURE] = iconloader.loadIcon("kweather//f_druck.xpm");
   IconArr[TYP_LEVEL] = iconloader.loadIcon("kweather//f_pegel.xpm");
   IconArr[TYP_WEATHER] = iconloader.loadIcon("kweather//f_wetter.xpm");
   IconArr[TYP_WIND] = iconloader.loadIcon("kweather//f_wind.xpm");
   IconArr[TYP_TEXT] = iconloader.loadIcon("kweather//f_text.xpm");
   IconArr[TYP_DIV] = iconloader.loadIcon("kweather//f_unbekannt.xpm");
   
   DataGrp = new QWidget(this, "DataGrp");
   DataGrp->setGeometry(10,10,480,370);

   Lst = new QListView(DataGrp,"Lst");
   Lst->setGeometry(10,10,180,350);
   Lst->addColumn(i18n("Type"),50);
   Lst->addColumn("Number",0);
   Lst->addColumn(i18n("Name"),115);
   connect(Lst, SIGNAL(selectionChanged(QListViewItem*)), SLOT(ListSelectionChanged(QListViewItem *)));
   
   // Name Edit
   QLabel *NameLab = new QLabel(i18n("Itemname"), DataGrp, "NameLab");
   NameLab->setGeometry(XL,10,75,20);
   NameLab->setAutoResize(TRUE);
   NameEdit = new QLineEdit(DataGrp, "NameEdit");
   NameEdit->setGeometry(XF,10,180,22);
   NameEdit->setMaxLength(29);
   
   // Beschreibung Edit
   QLabel *DescLab = new QLabel(i18n("Description"), DataGrp, "Desclab");
   DescLab->setGeometry(XL,40,75,22);
   DescLab->setAutoResize(TRUE);
   DescEdit = new QLineEdit(DataGrp, "DescEdit");
   DescEdit->setGeometry(XF,40,180,22);
   DescEdit->setMaxLength(127);
   
   // Lnge/Breite fr Groupheader
   XLab = new QLabel(i18n("Latitude"), DataGrp, "XLab");
   XLab->setGeometry(XL,70,75,22);
   XLab->setAutoResize(TRUE);
   XEdit = new KRestrictedLine(DataGrp, "XEdit");
   XEdit->setGeometry(XF,70,125+20,22);
   XEdit->setValidChars("0123456789.+-");
   YLab = new QLabel(i18n("Longitude"), DataGrp, "YLab");
   YLab->setGeometry(XL,100,75,22);
   YLab->setAutoResize(TRUE);
   YEdit = new KRestrictedLine(DataGrp, "YEdit");
   YEdit->setGeometry(XF,100,125+20,22);
   YEdit->setValidChars("0123456789.+-");
   
   // Typ Combo
   TypLab = new QLabel(i18n("Typ"), DataGrp, "TypLab");
   TypLab->setGeometry(XL,70,75,22);
   TypLab->setAutoResize(TRUE);
   TypLab->hide();
   TypCombo = new QComboBox(DataGrp, "TypCombo");
   TypCombo->setGeometry(XF,70,125,22);
   TypCombo->insertItem(i18n("Line"));
   TypCombo->insertItem(i18n("Air Pressure"));
   TypCombo->insertItem(i18n("Level"));
   TypCombo->insertItem(i18n("Weather"));
   TypCombo->insertItem(i18n("Wind"));
   //TypCombo->insertItem(i18n("Text"));
   //TypCombo->insertItem(i18n("Misc"));
   TypCombo->hide();
   connect(TypCombo, SIGNAL(highlighted(int)), SLOT(TypComboChange(int)));
   
   // Einheit Combo
   EinheitLab = new QLabel(i18n("Unity"), DataGrp, "EinheitLab");
   EinheitLab->setGeometry(XL,100,75,22);
   EinheitLab->hide();
   EinheitLab->setAutoResize(TRUE);
   EinheitCombo = new QComboBox(TRUE, DataGrp, "EinheitCombo");
   EinheitCombo->setGeometry(XF,100,125,25);
   /*EinheitCombo->insertItem("C");
   EinheitCombo->insertItem("K");
   EinheitCombo->insertItem("mB");
   EinheitCombo->insertItem("m/s");
   EinheitCombo->insertItem("Km/h");
   EinheitCombo->insertItem("Bft");
   EinheitCombo->insertItem("mm");
   EinheitCombo->insertItem("cm");*/
   EinheitCombo->hide();
   
   Einheit2Lab = new QLabel(i18n("Unit W.Strength"), DataGrp, "Einheit2Lab");
   Einheit2Lab->setGeometry(XL,130,75,22);
   Einheit2Lab->hide();
   Einheit2Lab->setAutoResize(TRUE);
   Einheit2Combo = new QComboBox(TRUE, DataGrp, "Einheit2Combo");
   Einheit2Combo->setGeometry(XF,130,125,25);
   Einheit2Combo->hide();

   ColorLab = new QLabel(i18n("Color"), DataGrp, "ColorLab");
   ColorLab->setGeometry(XL,130,75,22);
   ColorLab->hide();
   ColorLab->setAutoResize(TRUE);
   ColorRect = new QWidget(DataGrp, "ColorRect");
   ColorRect->setGeometry(XF,130,50,22);
   ColorRect->setBackgroundColor(QRgb(0));
   ColorRect->hide();
   ColorBtn = new QPushButton(i18n("Select"), DataGrp, "ColorBtn");
   ColorBtn->setGeometry(XF+65,130,60,22);
   connect(ColorBtn, SIGNAL(clicked()), SLOT(ColorBtnClick()));
   ColorBtn->hide();

   OwnScaleChk = new QCheckBox(i18n("Own Scaling"), DataGrp, "OwnScaleChk");
   OwnScaleChk->setGeometry(XF,170,120,15);
   OwnScaleChk->hide();
   OwnScaleChk->setAutoResize(TRUE);

   ScaleLab = new QLabel(i18n("Units per Grid"), DataGrp, "ScaleLab");
   ScaleLab->setGeometry(XL,190, 75,20);
   ScaleLab->hide();
   ScaleLab->setAutoResize(TRUE);
   ScaleEdit = new KRestrictedLine(DataGrp,"ScaleEdit");
   ScaleEdit->setGeometry(XF,190,80,22);
   ScaleEdit->setValidChars("0123456789.+-");
   ScaleEdit->hide();
   ZeroLab = new QLabel(i18n("Zeroline"), DataGrp, "ZeroLab");
   ZeroLab->setGeometry(XL,220, 75,20);
   ZeroLab->hide();
   ZeroLab->setAutoResize(TRUE);
   ZeroEdit = new KRestrictedLine(DataGrp,"ZeroEdit");
   ZeroEdit->setGeometry(XF,220,80,22);
   ZeroEdit->setValidChars("0123456789.+-");
   ZeroEdit->hide();
   
   StrLenLab = new QLabel(i18n("Char Length"), DataGrp, "StrlenLab");
   StrLenLab->setGeometry(XL,100,75,20);
   StrLenLab->hide();
   StrLenLab->setAutoResize(TRUE);
   StrLenSpin = new KNumericSpinBox(DataGrp, "StrLenSpin");
   StrLenSpin->setGeometry(XF,100,80,22);
   StrLenSpin->setEditable(TRUE);
   StrLenSpin->setRange(1,65536);
   StrLenSpin->hide();

   CountLab = new QLabel(i18n("Count"), DataGrp, "CountLab");
   CountLab->setGeometry(XL,250,75,22);
   CountLab->hide();
   CountLab->setAutoResize(TRUE);
   CountSpin = new KNumericSpinBox(DataGrp, "CountSpin");
   CountSpin->setGeometry(XF,250,50,22);
   CountSpin->setRange(1,8);
   CountSpin->hide();
   connect(CountSpin, SIGNAL(valueIncreased()), SLOT(CountSpinChange()));
   connect(CountSpin, SIGNAL(valueDecreased()), SLOT(CountSpinChange()));

   AvgCheck = new QCheckBox(i18n("average"), DataGrp, "AvgCheck");
   AvgCheck->setGeometry(XF+70,253,80,15);
   AvgCheck->hide();
   AvgCheck->setAutoResize(TRUE);
   
   TimeLab = new QLabel(i18n("Times"), DataGrp, "TimeLab");
   TimeLab->setGeometry(XL,280,75,22);
   TimeLab->hide();
   TimeLab->setAutoResize(TRUE);
   for (Lauf=0; Lauf<MAXCOUNT; Lauf++) {
      ZeitenBtn[Lauf] = new QPushButton("00:00", DataGrp, "");
      ZeitenBtn[Lauf]->setGeometry(XF+40*(Lauf%4), 280+20*(Lauf/4),40,20);
      SigMap->setMapping(ZeitenBtn[Lauf], Lauf);
      connect(ZeitenBtn[Lauf], SIGNAL(clicked()), SigMap, SLOT(map()));
      ZeitenBtn[Lauf]->hide();
      Zeiten[Lauf]=0;
   }


   ReadStructureBtn = new QPushButton(i18n("Import Structure"), DataGrp, "ReadStructureBtn");
   ReadStructureBtn->setGeometry(20,370,150,30);
   connect(ReadStructureBtn, SIGNAL(clicked()), SLOT(ReadStructureBtnClick()));


   ApplyBtn = new QPushButton(i18n("Apply"), DataGrp, "ApplyBtn");
   ApplyBtn->setGeometry(200,330,120,30);
   connect(ApplyBtn, SIGNAL(clicked()), SLOT(ApplyBtnClick()));

   DeleteBtn = new QPushButton(i18n("Delete"), DataGrp, "DeleteBtn");
   DeleteBtn->setGeometry(330,330,120,30);
   connect(DeleteBtn, SIGNAL(clicked()), SLOT(DeleteBtnClick()));

   AddGrpBtn = new QPushButton(i18n("Add Dataset"), DataGrp, "AddGrpBtn");
   AddGrpBtn->setGeometry(200,370,120,30);
   connect(AddGrpBtn, SIGNAL(clicked()), SLOT(AddGrpBtnClick()));

   AddItemBtn = new QPushButton(i18n("Add Item"), DataGrp, "AddItemBtn");
   AddItemBtn->setGeometry(330,370,120,30);
   connect(AddItemBtn, SIGNAL(clicked()), SLOT(AddItemBtnClick()));

   connect(EinheitCombo, SIGNAL(activated(const char*)), SLOT(EinheitComboChange(const char *)));

   FileGrp = new QWidget(this, "FileGrp");
   FileGrp->setGeometry(10,390,300,100);

   // DateiName
   QLabel *DateiLab = new QLabel(i18n("Filename"), FileGrp, "DateiLab");
   DateiLab->setGeometry(10,5,100,20);
   DateiEdit = new QLineEdit(FileGrp, "DateiEdit");
   DateiEdit->setGeometry(10,25,240,20);
 
   QPushButton *SuchenBtn = new QPushButton("", FileGrp, "SuchenBtn");
   SuchenBtn->setGeometry(260,25,20,20);
   SuchenBtn->setPixmap(kapp->getIconLoader()->loadIcon("viewmag.xpm"));
   connect(SuchenBtn, SIGNAL(clicked()), SLOT(SuchenBtnClick()));
   
   // Anfangsmonat
   QLabel *MonatLab = new QLabel(i18n("Month"), FileGrp, "MonatLab");
   MonatLab->setGeometry(10,50,100,20);
   QLabel *JahrLab = new QLabel(i18n("Year"), FileGrp, "JahrLab");
   JahrLab->setGeometry(130,50,100,20);
   
   MonatCombo = new QComboBox(FileGrp, "MonatCombo");
   MonatCombo->setGeometry(10,70,100,20);
   for (Lauf=0; Lauf<12; Lauf++)
      MonatCombo->insertItem(i18n(MonName[Lauf]));
      
   JahrSpin = new KNumericSpinBox(FileGrp, "JahrSpin");
   JahrSpin->setGeometry(130,70,50,20);
   JahrSpin->setEditable(TRUE);
   JahrSpin->setRange(0,10000); // Wer das Programm danach benutzt, ist selber schuld!
   
   // aktuelles Datum setzen
   date = QDate::currentDate();
   MonatCombo->setCurrentItem(date.month()-1);
   JahrSpin->setValue(date.year());
      
   
   TabCtl = new KTabCtl(this, "TabCtl");
   TabCtl->setGeometry(0,0,500,height()-60);
   TabCtl->addTab(FileGrp, i18n("File"));
   TabCtl->addTab(DataGrp, i18n("Datastructure"));

   OkBtn = new QPushButton(i18n("Ok"), this, "OkBtn");
   OkBtn->setGeometry(width()-200,height()-40,80,30);
   OkBtn->setDefault(TRUE);
   connect(OkBtn, SIGNAL(clicked()), SLOT(OkBtnClick()));

   CancelBtn = new QPushButton(i18n("Cancel"), this, "CancelBtn");
   CancelBtn->setGeometry(width()-100,height()-40,80,30);
   connect(CancelBtn, SIGNAL(clicked()), SLOT(CancelBtnClick()));
}

void NewDlg::SuchenBtnClick() {
QString DateiName = KFileDialog::getSaveFileName(DateiEdit->text(), "*.kwd", this );
   if (!DateiName.isEmpty())
      DateiEdit->setText(DateiName);
}

void NewDlg::AddGrpBtnClick() {
  AddGrp("NewGrp");
}

DataPtr NewDlg::AddGrp(char* Caption) {
QListViewItem * QL;
DataPtr DP;
QString Strg;

   debug("AddGrpBtnClick Curr=%s",CurrItem->Name);
   Update(CurrItem);
   CurrItem=NULL;  // keine weiteren Updates durch das Einfgen in die Liste

   DP = (DataPtr)malloc(sizeof (struct DataDef));
   memset(DP, 0, sizeof(struct DataDef));

   if (DP) {
     Initialisize(DP, TYP_GROUP);
     Strg.setNum((unsigned long int)(DP));

     if (Lst->currentItem()==NULL)
       QL = new QListViewItem(Lst);
     else {
       if (Lst->currentItem()->depth()==0) {
         // Groupitem, hinter diesem einfgen
         QL = new QListViewItem(Lst,Lst->currentItem());
       } else
       { 
         QL = new QListViewItem(Lst,Lst->currentItem()->parent());
       }
     }
     QL->setPixmap(0, IconArr[TYP_GROUP]);
     QL->setText(1, Strg);
     QL->setText(2, "NewGroup");
     //QL->setExpandable(TRUE);
     
     //Update(CurrItem);
     Lst->setCurrentItem(QL);
     Lst->setSelected(QL,TRUE);
     CurrItem=DP;
     Refresh(CurrItem);
   }
  return DP;
}

void NewDlg::AddItemBtnClick() {
  AddItem("NewItem");
}

DataPtr NewDlg::AddItem(char* Caption, int Type = TYP_LINE) {
// einen neuen Item anlegen
// Captin und Type werden verwendet, um die Stringliste zu initialisieren (nicht das Item selbst)
// Rckgabe: Zeiger auf die Itemdaten (DataPtr)
QListViewItem *QL, *New;
QString Strg;
DataPtr DP,CI;

   if (!CurrItem) return NULL;

   CI=CurrItem;
   Update(CurrItem);
   debug("AddItemBtnClick Curr=%s  %s  %d",CurrItem->Name, CurrItem->Einheit, CurrItem->Times[0]);
   CurrItem=NULL;

   QL = Lst->currentItem();
   if (!QL) return NULL;
   DP = (DataPtr)malloc(sizeof (struct DataDef));
   memset(DP, 0, sizeof(struct DataDef));

   if (DP) {
     debug("depth=%d",QL->depth());
     if (QL->depth()==0) {  // Groupitem
       debug("GroupItem");
       New = new QListViewItem(QL);
     } else {   // DetailItem
       debug("DataItem");
       New = new QListViewItem(QL->parent(), QL);
     }

     Initialisize(DP, TYP_LINE);
     Strg.setNum((unsigned long int)(DP));
     New->setPixmap(0, IconArr[Type]);
     New->setText(1, Strg);
     New->setText(2, Caption);

     QL->setOpen(TRUE);
     //Update(CI);
   debug("AddItemBtnClick Curr=%s  %s  %d",CI->Name, CI->Einheit, CI->Times[0]);
     Lst->setCurrentItem(New);
     Lst->setSelected(New,TRUE);
     CurrItem=DP;
     Refresh(CurrItem);
   }
debug("ADD: S=%s  DP=%p",Strg.data(),DP);
  return DP;
}

void NewDlg::DeleteEntry(QListViewItem *QL) {
// Eintrag + Datenblock lschen
QString Strg;
DataPtr DP;

  Strg = QL->text(1);
  DP = (DataPtr)(Strg.toULong());
debug("S=%s  DP=%p",Strg.data(),DP);
  if (DP) {
debug("Name=%s\nDesc=%s",DP->Name,DP->Description);
    free(DP);
  }
  delete QL;
  QL=NULL;
}

void NewDlg::DeleteBtnClick() {
QListViewItem *QL,*QN;
int Cnt=0;

  QL = Lst->currentItem();
  if (!QL) return;
  if (QL->childCount()>0) {  // Nachfragen, kompletten Eintrag lschen
    if (QMessageBox::warning(this,i18n("Delete Datagroup"), i18n("Delete datagroup with all items?"),
                         i18n("OK"),i18n("Abort"),"",0,1)==0) {
      debug("Lschen");
      QL->setOpen(TRUE);
      do {
        QN=QL->firstChild();
        DeleteEntry(QN);
        Cnt++;
        if (Cnt>100) break; // emergency exit
      } while (QL->childCount()>0);
    }
    DeleteEntry(QL);
  } else
    DeleteEntry(QL);
  CurrItem=NULL;
}

void NewDlg::ApplyBtnClick() {
  Update(CurrItem);
  Refresh(CurrItem);
}

void NewDlg::ReadStructureBtnClick() {
// Importieren der Datenstruktur von einer vorhandenen Datei
DataFile * RDF;
struct GridSettingsType RGS;
int Lauf;
DataPtr DP;

QString DateiName = KFileDialog::getSaveFileName(DateiEdit->text(), "*.kwd", this );

  debug("Structure");
  if (DateiName != "") {
    debug("%s",DateiName.data());
  }

  RDF = new DataFile(DateiName.data());
  RDF->Open(&RGS);

  Lauf=0;
  while (Lauf<MAXDATA) {
    if (RDF->DataArr[Lauf]) {
      //debug("%s",RDF->DataArr[Lauf]->Name);
      if (RDF->DataArr[Lauf]->Type == TYP_GROUP)
        DP=AddGrp(RDF->DataArr[Lauf]->Name);
      else
        DP=AddItem(RDF->DataArr[Lauf]->Name,RDF->DataArr[Lauf]->Type);
      memcpy(DP, RDF->DataArr[Lauf], sizeof(struct DataDef));
      // Wenn die Einheiten verschieden sind, 'ownscaling' aktivieren
      if (!(DP->Flags1 & FLG_OWNSCALING)) {
        switch (DP->Type) {
          case TYP_LINE :     if (strcmp(DP->Einheit, GridDefaults.LineUnits))
                                 DP->Flags1 |= FLG_OWNSCALING;
                              break;
          case TYP_PRESSURE : if (strcmp(DP->Einheit, GridDefaults.PrsUnits))
                                 DP->Flags1 |= FLG_OWNSCALING;
                               debug("Units %s  %s",DP->Einheit, GridDefaults.PrsUnits);
                              break;
          case TYP_LEVEL :    if (strcmp(DP->Einheit, GridDefaults.LevelUnits))
                                 DP->Flags1 |= FLG_OWNSCALING;
                              break;
        }
      }
      Refresh(CurrItem);
      debug("ReadStructure: Name=>%s<>%s<",DP->Name,DP->Description);
    } else
       break;
    Lauf++;
  }

  delete RDF;
}

void NewDlg::Initialisize(DataPtr DP, int Type, int FullInit=TRUE) {
int Lauf;

   if (!DP) return;
   
   // allgemeine Initialisierungen
   DP->Type = Type;
   DP->Count= 1;
   DP->Description[0]=0;
   
   for (Lauf=0; Lauf<MAXCOUNT; Lauf++) {
      DP->Times[Lauf]=0;
      Zeiten[Lauf]=0;
   }
   DP->CalcAvg=FALSE;

   // Typabhngige Initialisierung
   switch (Type) {
      case TYP_GROUP : strcpy(DP->Name,"NewGroup");
                       DP->Einheit[0]=0;
                       DP->Farbe=0;
                       DP->Scale=0;
                       DP->Zero=0;
                       break;
      /*case TYP_LINE*/
      default       :  strcpy(DP->Einheit, GridDefaults.LineUnits);
                       strcpy(DP->Name,"NewItem");
                       DP->Farbe=qRgb(0,0,0xA0);
                       EinheitCombo->clear();
   										 for (Lauf=0; Lauf<CNT_TEMPUNITS; Lauf++)
                         EinheitCombo->insertItem(TempUnits[Lauf]);
                       DP->Scale=GridDefaults.LineGrids;
                       DP->Zero=GridDefaults.LineZero;
                       break;
   }
}

void NewDlg::ShowFields(int Type) {
// Sichtbarkeit der Eingabefelder abhngig vom Typ setzen

   switch(Type) {
      case TYP_GROUP : XLab->show();
                       XEdit->show();
                       YLab->show();
                       YEdit->show();
                       TypCombo->hide();
                       TypLab->hide();
                       EinheitLab->hide();
                       EinheitCombo->hide();
                       Einheit2Lab->hide();
                       Einheit2Combo->hide();
                       ColorLab->hide();
                       ColorRect->hide();
                       ColorBtn->hide();
                       CountLab->hide();
                       CountSpin->hide();
                       AvgCheck->hide();
                       ShowTimeButtons(0); // keinen anzeigen
                       TimeLab->hide();
                       ScaleEdit->hide();
                       OwnScaleChk->hide();
                       ScaleLab->hide();
                       ZeroLab->hide();
                       ZeroEdit->hide();
                       StrLenLab->hide();
                       StrLenSpin->hide();
                       break;
      case TYP_WIND:   XLab->hide();
                       XEdit->hide();
                       YLab->hide();
                       YEdit->hide();
                       TypCombo->show();
                       TypLab->show();
                       EinheitLab->show();
                       EinheitCombo->show();
                       Einheit2Lab->show();
                       Einheit2Combo->show();
                       ColorLab->hide();
                       ColorRect->hide();
                       ColorBtn->hide();
                       CountLab->show();
                       CountSpin->show();
                       AvgCheck->hide();
                       ShowTimeButtons(CountSpin->getValue());
                       TimeLab->show();
                       ScaleEdit->hide();
                       OwnScaleChk->hide();
                       ScaleLab->hide();
                       ZeroLab->hide();
                       ZeroEdit->hide();
                       StrLenLab->hide();
                       StrLenSpin->hide();
                       break;
      case TYP_WEATHER:XLab->hide();
                       XEdit->hide();
                       YLab->hide();
                       YEdit->hide();
                       TypCombo->show();
                       TypLab->show();
                       EinheitLab->hide();
                       EinheitCombo->hide();
                       Einheit2Lab->hide();
                       Einheit2Combo->hide();
                       ColorLab->hide();
                       ColorRect->hide();
                       ColorBtn->hide();
                       CountLab->show();
                       CountSpin->show();
                       AvgCheck->hide();
                       ShowTimeButtons(CountSpin->getValue());
                       TimeLab->show();
                       ScaleEdit->hide();
                       OwnScaleChk->hide();
                       ScaleLab->hide();
                       ZeroLab->hide();
                       ZeroEdit->hide();
                       StrLenLab->hide();
                       StrLenSpin->hide();
                       break;
      case TYP_TEXT:   XLab->hide();
                       XEdit->hide();
                       YLab->hide();
                       YEdit->hide();
                       TypCombo->show();
                       TypLab->show();
                       EinheitLab->hide();
                       EinheitCombo->hide();
                       Einheit2Lab->hide();
                       Einheit2Combo->hide();
                       ColorLab->hide();
                       ColorRect->hide();
                       ColorBtn->hide();
                       CountLab->show();
                       CountSpin->show();
                       AvgCheck->hide();
                       ShowTimeButtons(0);
                       TimeLab->hide();
                       ScaleEdit->hide();
                       OwnScaleChk->hide();
                       ScaleLab->hide();
                       ZeroLab->hide();
                       ZeroEdit->hide();
                       StrLenLab->show();
                       StrLenSpin->show();
                       break;
      default :        XLab->hide();
                       XEdit->hide();
                       YLab->hide();
                       YEdit->hide();
                       TypCombo->show();
                       TypLab->show();
                       EinheitLab->show();
                       EinheitCombo->show();
                       Einheit2Lab->hide();
                       Einheit2Combo->hide();
                       ColorLab->show();
                       ColorRect->show();
                       ColorBtn->show();
                       CountLab->show();
                       CountSpin->show();
                       AvgCheck->show();
                       ShowTimeButtons((CountSpin->getValue()));
                       TimeLab->show();
                       ScaleEdit->show();
                       OwnScaleChk->show();
                       ScaleLab->show();
                       ZeroLab->show();
                       ZeroEdit->show();
                       StrLenLab->hide();
                       StrLenSpin->hide();
   }
}

void NewDlg::Refresh(DataPtr DP) {
// Die Daten aus dem Eintrag DP in die Eingabefelder bertragen (anzeigen)
int Lauf;
char Strg[10];

   if (!DP) return;

   // Zeiten temporr bernehmen
   for (Lauf=0; Lauf<MAXCOUNT; Lauf++)
      Zeiten[Lauf] = DP->Times[Lauf];
      
   NameEdit->setText(DP->Name);
   DescEdit->setText(DP->Description);

   switch(DP->Type) {
      case TYP_GROUP : XLab->show();
                       XEdit->show();
                       YLab->show();
                       YEdit->show();
                       sprintf(Strg,"%0.3f", DP->Scale);  // Geographische Koordinaten
                       XEdit->setText(Strg);                    // der Station
                       sprintf(Strg,"%0.3f", DP->Zero);
                       YEdit->setText(Strg);
                       TypCombo->hide();
                       TypLab->hide();
                       EinheitLab->hide();
                       EinheitCombo->hide();
                       Einheit2Lab->hide();
                       Einheit2Combo->hide();
                       ColorLab->hide();
                       ColorRect->hide();
                       ColorBtn->hide();
                       CountLab->hide();
                       CountSpin->hide();
                       AvgCheck->hide();
                       ShowTimeButtons(0); // keinen anzeigen
                       TimeLab->hide();
                       ScaleEdit->hide();
                       OwnScaleChk->hide();
                       ScaleLab->hide();
                       ZeroLab->hide();
                       ZeroEdit->hide();
                       StrLenLab->hide();
                       StrLenSpin->hide();
                       break;
      case TYP_WIND:   XLab->hide();
                       XEdit->hide();
                       YLab->hide();
                       YEdit->hide();
                       TypCombo->setCurrentItem(DP->Type-1);
                       TypCombo->show();
                       TypLab->show();
                       EinheitCombo->setEditText(DP->Einheit);
                       EinheitLab->show();
                       EinheitCombo->show();
                       Einheit2Lab->show();
                       Einheit2Combo->show();
                       ColorLab->hide();
                       ColorRect->hide();
                       ColorBtn->hide();
                       CountLab->show();
                       CountSpin->show();
                       AvgCheck->hide();
                       CountSpin->setValue(DP->Count);
                       ShowTimeButtons(DP->Count);
                       TimeLab->show();
                       ScaleEdit->hide();
                       OwnScaleChk->hide();
                       ScaleLab->hide();
                       ZeroLab->hide();
                       ZeroEdit->hide();
                       StrLenLab->hide();
                       StrLenSpin->hide();
                       //StrLenSpin->setValue(DP->Scale);
                       break;
      case TYP_WEATHER:XLab->hide();
                       XEdit->hide();
                       YLab->hide();
                       YEdit->hide();
                       TypCombo->setCurrentItem(DP->Type-1);
                       TypCombo->show();
                       TypLab->show();
                       //EinheitCombo->setEditText(DP->Einheit);
                       EinheitLab->hide();
                       EinheitCombo->hide();
                       ColorLab->hide();
                       ColorRect->hide();
                       ColorBtn->hide();
                       CountLab->show();
                       CountSpin->show();
                       AvgCheck->hide();
                       CountSpin->setValue(DP->Count);
                       ShowTimeButtons(DP->Count);
                       TimeLab->show();
                       ScaleEdit->hide();
                       OwnScaleChk->hide();
                       ScaleLab->hide();
                       ZeroLab->hide();
                       ZeroEdit->hide();
                       StrLenLab->hide();
                       StrLenSpin->hide();
                       //StrLenSpin->setValue(DP->Scale);
                       break;
      case TYP_TEXT:   XLab->hide();
                       XEdit->hide();
                       YLab->hide();
                       YEdit->hide();
                       TypCombo->setCurrentItem(DP->Type-1);
                       TypCombo->show();
                       TypLab->show();
                       EinheitLab->hide();
                       EinheitCombo->hide();
                       Einheit2Lab->hide();
                       Einheit2Combo->hide();
                       ColorLab->hide();
                       ColorRect->hide();
                       ColorBtn->hide();
                       CountLab->show();
                       CountSpin->show();
                       CountSpin->setValue(DP->Count);
                       AvgCheck->hide();
                       ShowTimeButtons(0);
                       TimeLab->hide();
                       ScaleEdit->hide();
                       OwnScaleChk->hide();
                       ScaleLab->hide();
                       ZeroLab->hide();
                       ZeroEdit->hide();
                       StrLenLab->show();
                       StrLenSpin->show();
                       StrLenSpin->setValue(DP->Scale);
                       break;
      default :        XLab->hide();
                       XEdit->hide();
                       YLab->hide();
                       YEdit->hide();
                       TypCombo->setCurrentItem(DP->Type-1);
                       TypCombo->show();
                       TypLab->show();
                       EinheitCombo->setEditText(DP->Einheit);
                       EinheitLab->show();
                       EinheitCombo->show();
                       Einheit2Lab->hide();
                       Einheit2Combo->hide();
                       ColorLab->show();
                       ColorRect->show();
                       ColorRect->setBackgroundColor(QRgb(DP->Farbe));
                       ColorBtn->show();
                       CountLab->show();
                       CountSpin->show();
                       AvgCheck->show();
                       AvgCheck->setChecked(DP->CalcAvg);
                       AvgCheck->setChecked(DP->CalcAvg);
                       CountSpin->setValue(DP->Count);
                       ShowTimeButtons(DP->Count);
                       TimeLab->show();
                       ScaleEdit->show();
                       OwnScaleChk->show();
                       OwnScaleChk->setChecked(DP->Flags1 & FLG_OWNSCALING);
                       ScaleLab->show();
                       ZeroLab->show();
                       ZeroEdit->show();
                       sprintf(Strg,"%0.1f", DP->Scale);
                       ScaleEdit->setText(Strg);
                       debug("scaledit->settext(%s)",Strg);
                       sprintf(Strg,"%0.1f", DP->Zero);
                       ZeroEdit->setText(Strg);
                       StrLenLab->hide();
                       StrLenSpin->hide();
                       //StrLenSpin->setValue(DP->Scale);
   }
}

void NewDlg::Update(DataPtr DP) {
// Die Daten aus den Eingabefeldern in das Array an den Eintrag Pos speichern
QListViewItem *QL;
QColor C;
int Lauf;
bool ok;
double X=0,Y=0,S=0,Z=0;
QString Strg;

   if (DP)
     debug("Update-Start Curr=%s  %s  %d",DP->Name, DP->Einheit, DP->Times[0]);

   if (!DP) return;
debug("Update Type=%ld Name=%s",DP->Type,DP->Name);
   
   // Alle Felder prfen, die einen Fehler enthalten knnen
   switch (DP->Type) {
      case TYP_GROUP :  ok=FALSE;
                        Strg=XEdit->text();
                        X=Strg.toDouble(&ok);
                        if (!ok) {
                           QMessageBox::warning(this, i18n("Invalid Float Value"),
                                                      i18n(Strg+" ist not a number"),
                                                      i18n("Ok"));
                        }
                        ok=FALSE;
                        Strg=YEdit->text();
                        Y=Strg.toDouble(&ok);
                        if (!ok) {
                           QMessageBox::warning(this, i18n("Invalid Float Value"),
                                                      i18n(Strg+" ist not a number"),
                                                      i18n("Ok"));
                        }
                        break;
      case TYP_WEATHER:
      case TYP_WIND:    
      case TYP_TEXT:    
                        break;
      default:          ok=FALSE;
                        Strg=ScaleEdit->text();
                        S=Strg.toDouble(&ok);
                        if (!ok) {
                           QMessageBox::warning(this, i18n("Invalid Float Value"),
                                                      i18n(Strg+" ist not a number"),
                                                      i18n("Ok"));
                        }
                        
                        ok=FALSE;
                        Strg=ZeroEdit->text();
                        Z=Strg.toDouble(&ok);
                        if (!ok) {
                           QMessageBox::warning(this, i18n("Invalid Float Value"),
                                                      i18n(Strg+" ist not a number"),
                                                      i18n("Ok"));
                        }
                        break;
   }
   
   strcpy(DP->Name, NameEdit->text());
   strcpy(DP->Description, DescEdit->text());

   switch(DP->Type) {
      case TYP_GROUP : DP->Scale=X;
                       DP->Zero=Y;
                       break;
      default :        if (DP->Type==TYP_TEXT)
                          DP->Scale=StrLenSpin->getValue();
                       else
                          DP->Scale=S;
                       DP->Zero=Z;
                       if (OwnScaleChk->isChecked())
                         DP->Flags1 = DP->Flags1 | FLG_OWNSCALING;
                       else
                         DP->Flags1  = DP->Flags1 & (~FLG_OWNSCALING);
                       DP->Type = TypCombo->currentItem()+1;
                       strncpy(DP->Einheit, EinheitCombo->currentText(), 9);
                       DP->Einheit[9]=0;
                       C = ColorRect->backgroundColor();
                       DP->Farbe = qRgb(C.red(), C.green(), C.blue());
                       DP->Count = CountSpin->getValue();
                       for (Lauf=0; Lauf<MAXCOUNT; Lauf++)
                          DP->Times[Lauf] = Zeiten[Lauf];
                       DP->CalcAvg=AvgCheck->isChecked();
   }
   QL = Lst->firstChild();
   while (QL) {
     Strg=QL->text(1);
     debug("%s",Strg.data());
     if (DP==(DataPtr)(Strg.toULong())) {
       QL->setPixmap(0, IconArr[DP->Type]);
       QL->setText(2, DP->Name);
debug("SETLIST");        
       break;
     }
//     QL = QL->nextSibling();
     QL = QL->itemBelow();
   }
   Lst->update();
   if (DP)
     debug("Update-Ende Curr=%s  %s  %d",DP->Name, DP->Einheit, DP->Times[0]);
}

void NewDlg::ListSelectionChanged(QListViewItem *Itm) {
QString Strg;
   //debug("ListHighlight Item %d, Current=%d",Item,Current);
   debug("ListSelectionChanged");
   
   Update(CurrItem);
   Strg=Itm->text(1);
   CurrItem = (DataPtr)(Strg.toULong());
debug("Strg=>%s<  Ptr=%p",Strg.data(),CurrItem);
   SetUnits(CurrItem->Type);  // Einheitencombo - Liste anpassen
   Refresh(CurrItem);
}

void NewDlg::ColorBtnClick() {
   KColorDialog ColDlg(this,i18n("Select Color"),TRUE);
   
   ColDlg.setColor(ColorRect->backgroundColor());
   if (ColDlg.exec()) {
      ColorRect->setBackgroundColor(ColDlg.color());
   }   
}

void NewDlg::OkBtnClick() {
DataFile DF(DateiEdit->text());
DataArrType DataArr;
QListViewItem *QL;
int Count;
QString Strg;
DataPtr DP;

   debug("OkBtnClick");
   ApplyBtnClick();   // evtl. ausstehende nderungen speichern
   if (strlen(DateiEdit->text())==0) {
      QMessageBox::information(this, i18n("No File"), i18n("No filename given!"),
                   i18n("OK"),0,0,   0,0);
      return;
   }
   
   // alle Groupitems 'ffen', sonst werden die Daten nicht erfasst
   QL=Lst->firstChild();
   while (QL) {
     QL->setOpen(TRUE);
     QL=QL->nextSibling();
   }
   
   memset(DataArr,0,sizeof(DataArr));
   Count=0;
   QL = Lst->firstChild();
   while (QL) {
     Strg = QL->text(1);
     DP = (DataPtr)(Strg.toULong());
debug("Name=%s",DP->Name);     
     DataArr[Count]=DP;
     Count++;
     //QL = QL->nextSibling();
     QL = QL->itemBelow();
   }
debug("Count=%d",Count);   

   if (DataArr[0]==NULL) {
      QMessageBox::information(this, i18n("No Data"), i18n("No datasets defiened!"),
                   i18n("OK"),0,0,   0,0);
      return;
   }


   //if (DF.CreateNewFile(&DataArr, MonatCombo->currentItem()+1, JahrSpin->getValue()))
   if (DF.CreateNewFile(&DataArr,MonatCombo->currentItem()+1,JahrSpin->getValue(), &GridDefaults)) {
debug("Newdlg-Creaatefile-vor accept");
     accept();
debug("Newdlg-Creaatefile-nach accept");
   } else
debug("Newdlg-Creaatefile-cancel");
}

void NewDlg::CancelBtnClick() {
QListViewItem *QL;
DataPtr DP;
QString Strg;

  // Datenzeiger lschen
  QL = Lst->firstChild();
  while (QL) {
    Strg = QL->text(1);
    DP = (DataPtr)(Strg.toULong());
    free(DP);
    
    QL = QL->nextSibling();
  }
  reject();
}

void NewDlg::TimeBtnClick(int i) {
TimeSetDlg TDLG(this, "SetTime");

   debug("TimeBtnClick  i=%d",i);
   TDLG.SetTime(Zeiten[i]);
   debug("%d",Zeiten[i]);
   if (TDLG.exec()) {
      Zeiten[i] = TDLG.GetTime();
      ShowTimeButtons(CountSpin->getValue());
   }
   debug("%d",Zeiten[i]);
}

void NewDlg::CountSpinChange() {
int i=TypCombo->currentItem()+1;

   debug("CountSpinChange  Value=%d",CountSpin->getValue());
   if (i==TYP_TEXT)
      ShowTimeButtons(0);
   else
      ShowTimeButtons(CountSpin->getValue());
}

void NewDlg::ShowTimeButtons(int Cnt) {
int Lauf;
char Strg[10];

   for (Lauf=0; Lauf<MAXCOUNT; Lauf++) {
      sprintf(Strg, "%02d:%02d", Zeiten[Lauf]/60, Zeiten[Lauf]%60);
      ZeitenBtn[Lauf]->setText(Strg);
      if (Lauf<Cnt)
         ZeitenBtn[Lauf]->show();
      else
         ZeitenBtn[Lauf]->hide();
   }
}

void NewDlg::TypComboChange(int Itm) {
int i;
char S[20];

   debug("TypComboChange Item=%d",Itm);
   EinheitCombo->clear();
   Einheit2Combo->clear();
   switch (Itm+1) {
      //case TYP_GROUP :    debug("ChangeItem: GROUP");
      //                    break;
      case TYP_LINE :     debug("ChangeItem: LINE");
                          for (i=0; i<CNT_TEMPUNITS; i++)
                            EinheitCombo->insertItem(TempUnits[i]);
                          EinheitCombo->setEditText(GridDefaults.LineUnits);
                          sprintf(S,"%0.1f",GridDefaults.LineGrids);
                          ScaleEdit->setText(S);
                          sprintf(S,"%0.1f",GridDefaults.LineZero);
                          ZeroEdit->setText(S);
                          break;
      case TYP_PRESSURE : debug("ChangeItem: PRESSURE");
                          for (i=0; i<CNT_PRSUNITS; i++)
                            EinheitCombo->insertItem(PrsUnits[i]);
                          EinheitCombo->setEditText(GridDefaults.PrsUnits);
                          sprintf(S,"%0.1f",GridDefaults.PrsGrids);
                          ScaleEdit->setText(S);
                          sprintf(S,"%0.1f",GridDefaults.PrsZero);
                          ZeroEdit->setText(S);
                          break;
      case TYP_LEVEL :    debug("ChangeItem: LEVEL %s",GridDefaults.LevelUnits);
                          for (i=0; i<CNT_LEVELUNITS; i++)
                            EinheitCombo->insertItem(LevelUnits[i]);
                          EinheitCombo->setEditText(GridDefaults.LevelUnits);
                          sprintf(S,"%0.1f",GridDefaults.LevelGrids);
                          ScaleEdit->setText(S);
                          sprintf(S,"%0.1f",GridDefaults.LevelZero);
                          ZeroEdit->setText(S);
                          break;
      case TYP_WEATHER :  debug("ChangeItem: WEATHER");
                          break;
      case TYP_WIND :     debug("ChangeItem: WIND");
                          for (i=0; i<CNT_WINDDIRUNITS; i++)
                            EinheitCombo->insertItem(WindDirUnits[i]);
                          EinheitCombo->setEditText(GridDefaults.WindDirUnits);
                          for (i=0; i<CNT_WINDSTRENGTHUNITS; i++)
                            Einheit2Combo->insertItem(WindStrengthUnits[i]);
                          Einheit2Combo->setEditText(GridDefaults.WindStrengthUnits);
                          break;
      case TYP_TEXT :     debug("ChangeItem: TEXT");
                          break;
      case TYP_MINMAX :   debug("ChangeItem: MINMAX");
                          for (i=0; i<CNT_TEMPUNITS; i++)
                            EinheitCombo->insertItem(TempUnits[i]);
                          sprintf(S,"%0.1f",GridDefaults.LineGrids);
                          ScaleEdit->setText(S);
                          sprintf(S,"%0.1f",GridDefaults.LineZero);
                          ZeroEdit->setText(S);
                          break;
      case TYP_DIV :      debug("ChangeItem: DIV");
                          break;
   }
   ShowFields(Itm+1);
}

void NewDlg::SetUnits(int Type) {
// Einheiten in der Einheitencombo abh. vom Typ setzen
int i;

   EinheitCombo->clear();
   Einheit2Combo->clear();
   switch (Type) {
      case TYP_GROUP :
                          break;
      case TYP_LINE :
                          for (i=0; i<CNT_TEMPUNITS; i++)
                            EinheitCombo->insertItem(TempUnits[i]);
                          break;
      case TYP_PRESSURE :
                          for (i=0; i<CNT_PRSUNITS; i++)
                            EinheitCombo->insertItem(PrsUnits[i]);
                          break;
      case TYP_LEVEL :
                          for (i=0; i<CNT_LEVELUNITS; i++)
                            EinheitCombo->insertItem(LevelUnits[i]);
                          break;
      case TYP_WEATHER :
                          break;
      case TYP_WIND :
                          for (i=0; i<CNT_WINDDIRUNITS; i++)
                            EinheitCombo->insertItem(WindDirUnits[i]);
                          for (i=0; i<CNT_WINDSTRENGTHUNITS; i++)
                            Einheit2Combo->insertItem(WindStrengthUnits[i]);
                          break;
      case TYP_TEXT :
                          break;
      case TYP_MINMAX :
                          for (i=0; i<CNT_TEMPUNITS; i++)
                            EinheitCombo->insertItem(TempUnits[i]);
                          break;
      case TYP_DIV :
                          break;
   }
}

void NewDlg::EinheitComboChange(const char *c) {
// Gridskalierungsfelder Units/Grid und Zero anhngig von der gewlten Einteit
// und dem gerade aktiven Typ setzen
debug("EinheitComboChange - Typ=%d",TypCombo->currentItem());
  switch(TypCombo->currentItem()+1) {
    case TYP_LINE :     SetTempScales(c, ScaleEdit,ZeroEdit);
                        break;
    case TYP_PRESSURE : SetPrsScales(c, ScaleEdit,ZeroEdit);
                        break;
    case TYP_LEVEL :    SetLevelScales(c, ScaleEdit,ZeroEdit);
                        break;
  }
}


TimeSetDlg::TimeSetDlg(QWidget* parent=0, const char* name=0):
     QDialog (parent, name, WStyle_DialogBorder)
{
QLabel* SliderLabs[5];
char Strg[10];
int Lauf;

   setFixedSize(500,130);
   setCaption(i18n("Set Time"));
   CurrTime=0;
   SliderBypass=FALSE;
   
                         // 15 min Schritte
   TimeSlider = new KSlider(0,24*4, 1,0, KSlider::Horizontal, this, "TimeSlider");
   TimeSlider->setGeometry(10,20,480,25);
   TimeSlider->setTickInterval(50);
   connect(TimeSlider, SIGNAL(valueChanged(int)), SLOT(TimeSliderValueChange(int)));

   QFont f("Helvetica", 24, QFont::Bold);
   TimeLab = new QLabel("", this, "TimeLab");
   TimeLab->setGeometry(50,70,80,30);
   TimeLab->setFont( f );
   HIncBtn = new QPushButton("++", this, "HIncBtn");
   HIncBtn->setGeometry(130,70,15,15);
   MIncBtn = new QPushButton("+", this, "MIncBtn");
   MIncBtn->setGeometry(145,70,15,15);
   HDecBtn = new QPushButton("--", this, "HDecBtn");
   HDecBtn->setGeometry(130,85,15,15);
   MDecBtn = new QPushButton("-", this, "MDecBtn");
   MDecBtn->setGeometry(145,85,15,15);
   HIncBtn->setAutoRepeat(TRUE);
   MIncBtn->setAutoRepeat(TRUE);
   HDecBtn->setAutoRepeat(TRUE);
   MDecBtn->setAutoRepeat(TRUE);
   connect(HIncBtn, SIGNAL(clicked()), SLOT(HIncBtnClick()));
   connect(MIncBtn, SIGNAL(clicked()), SLOT(MIncBtnClick()));
   connect(HDecBtn, SIGNAL(clicked()), SLOT(HDecBtnClick()));
   connect(MDecBtn, SIGNAL(clicked()), SLOT(MDecBtnClick()));
   
   for (Lauf=0; Lauf<=4; Lauf++) {
      sprintf(Strg,"%d", Lauf*6);
      SliderLabs[Lauf] = new QLabel(Strg, this, "");
      SliderLabs[Lauf]->setGeometry(12+Lauf*470/4, 45, 20,10);
   }
   
   OkBtn = new QPushButton(i18n("OK"), this, "OkBtn");
   OkBtn->setGeometry(300,90,80,30);
   OkBtn->setDefault(TRUE);
   connect(OkBtn, SIGNAL(clicked()), SLOT(accept()));
   CancelBtn = new QPushButton(i18n("Cancel"), this, "CancelBtn");
   CancelBtn->setGeometry(400,90,80,30);
   connect(CancelBtn, SIGNAL(clicked()), SLOT(reject()));

   ShowTime();
}

void TimeSetDlg::TimeSliderValueChange(int NewVal) {

   if (!SliderBypass) {
      CurrTime = NewVal*15;
      ShowTime();
   }
   SliderBypass=FALSE;
}

void TimeSetDlg::HIncBtnClick() {

   SliderBypass=TRUE;
   CurrTime += 60;
   if (CurrTime>1440)
      CurrTime=1440;
   TimeSlider->setValue(CurrTime/15);
   ShowTime();
}

void TimeSetDlg::MIncBtnClick() {

   SliderBypass=TRUE;
   CurrTime += 1;
   if (CurrTime>1440)
      CurrTime=1440;
   TimeSlider->setValue(CurrTime/15);
   ShowTime();
}

void TimeSetDlg::HDecBtnClick() {

   SliderBypass=TRUE;
   CurrTime -= 60;
   if (CurrTime<0)
      CurrTime=0;
   TimeSlider->setValue(CurrTime/15);
   ShowTime();
}

void TimeSetDlg::MDecBtnClick() {

   SliderBypass=TRUE;
   CurrTime -= 1;
   if (CurrTime<0)
      CurrTime=0;
   TimeSlider->setValue(CurrTime/15);
   ShowTime();
}

void TimeSetDlg::ShowTime(void) {
char Strg[10];

   sprintf(Strg, "%02d:%02d", CurrTime/60, CurrTime%60);
   TimeLab->setText(Strg);
}

void TimeSetDlg::SetTime(int T) {
   if (T>0 && T<=1440)
      CurrTime = T;
   else
      CurrTime=0;
   ShowTime();
   TimeSlider->setValue(CurrTime/15);
   debug("Currtime %d",CurrTime);
}

int TimeSetDlg::GetTime(void) {
   return CurrTime;
}
