/***************************************************************************
                          data.h  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    kweather - a program for recording weather events
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    
#ifndef _DATA_H_
#define _DATA_H_

#include "globals.h"

// Datentypen
#define TYP_GROUP 0    // Groupheader, dann gilt:MinVal,MaxMal = Koordinaten
#define TYP_LINE 1
#define TYP_PRESSURE 2
#define TYP_LEVEL 3
#define TYP_WEATHER 4
#define TYP_WIND 5
#define TYP_TEXT 6
#define TYP_MINMAX 7
#define TYP_DIV 8           // undefiniert, mu immer den grten Wert haben!

#define MAXDATA 512         // Max. Datenstze (Group + Item)
#define MAXCOUNT 8          // Max. Zeiten

// Dateiendungen Header und Data
// #define EXT_HEADER ".kwh"
#define EXT_DATA   ".kwd"

//Fehlerkonstanten bei Dateioperationen
#define DTA_OK 0            // kein Fehler
#define DTA_ERROR -1        // irgendein Fehler
#define DTA_FILENOTFOUND -2 // angegebene Datei gibt es nicht
#define DTA_OPENERROR -3    // Fehler beim ffnen
#define DTA_CREATEERROR -4  // Fehler beim Anlegen einer Datei
#define DTA_INVALIDFILE -5  // Ungltige Datei / keine KWeather Datei
#define DTA_FILENOTOPEN -6  // "Operation bei geschloener Datenmenge nicht ausfhrbar!"

#define KENNDATA "KWeather/FIK"   // Erkennungsstring fr KWeather-Dateien

// Masken fr Dlagfelder
#define FLG_OWNSCALING 1    // Item verwendet eigene Skalierung
// #define FLG_NODISPLAY  2    // Item wird nicht dargestellt

// Flags fpr die Displaybits
// #define FLG_DISP_NODISPLAY 1 // keine Anzeige im Grid

#include <stdio.h>
#include <qstring.h>

// Datenstruktur fr die Darstellungsbits
struct DisplayBitFieldType1 {
  long Display : 1;    // Anzeigen Ja/Nein
  long Nr : 8;         // Bitfeld der anzuzeigenden Items (bei Wetter/Wind)
  long Rest : 23;      // restliche (noch) ungenutzte Bits
};
typedef long int DisplayBitFieldType2;  // reserved for future use
typedef struct _IType {
  DisplayBitFieldType1 BF1;
  DisplayBitFieldType2 BF2;
};
typedef _IType IType[1];
typedef IType *IPtr;


// Struktur mit den Kenndaten der Headerdatei
struct HeaderDef {
   char Kennung[12];         // Kennstring
   short Count;              // Anzahl der Datenstze im Header
   GridSettingsType GS;      // allgemeine Grideinstellungen
};

struct DataDef {
   char Name[30];            // Name des Items
   char Description[128];    // Beschreibung
   long Type;                // Datentyp (Linie, Pegel...)
   char Einheit[10];         // Einheit des Mewertes
   char Einheit2[10];        // Einheit des 2. Mewertes (nur bei Wind)
   long int Farbe;           // Farbe (bei Linien)
   float Scale;              // Darstellungsskalierung (gridbezogen, Werte pro Kstchen)
   float Zero;               // Wert, bei der die Nullline im Grid ist
   unsigned short Count;     // Wiederholungsanzahl Zeiten / Stringlnge bei Texttyp
   unsigned short Times[MAXCOUNT];  // Zeitpunkt(e)
   short CalcAvg;            // Mittelwert berechnen, wenn mehr als ein Wert
   long Flags1,Flags2,Flags3,Flags4; // Flags zu diesem Datenwert
   long dummy1,dummy2,dummy3,dummy4; // for future use....
};
typedef DataDef *DataPtr;    // Zeiger auf Datenblock
typedef DataPtr DataArrType[MAXDATA];

struct MonatHeaderType {
   short Monat,Jahr;
};
typedef float FloatDataType[31];   // Datenarray fr FLOAT-Daten
typedef short ShortDataType[31];   // Datenarray fr SHORT-Daten
typedef long  LongDataType[31];    //      "      "   LONG-  "
typedef long int ValidDataType[4]; // Gltigkeitsbits
typedef char *PChar; //Strg64[64];
typedef PChar CharDataType[31];    // Textfeld
typedef void* DataType[MAXCOUNT][MAXDATA];         // Zeigerarray auf die Daten
typedef ValidDataType ValidType[MAXCOUNT][MAXDATA];// Gltigkeitsbits

// Dateneintrge ohne Header lckenlose Folge
typedef int   ZAType[MAXDATA];
// Headerverweise zu dem entspr. Dateneintrag
typedef int   ZHType[MAXDATA];

class DataFile {
public:
   DataFile(const char* Name);
   ~DataFile(void);
   int CreateNewFile(DataArrType* DA, short Mon, short Jahr, struct GridSettingsType* GS);
   int Open(struct GridSettingsType* GS);
   int Close(void);
   int RecCount(void) { return RecordCount;}; // Anzahl der Datenstze
   int Seek(short M,short J);// Datensatz mit Monat, Jahr vorwhlen
   int Seek(int RecNo);      // Datensatz mit Nummer vorwhlen
   int Read(void);           // Datensatz lesen
   int Write(void);          //      "    speichern
   int Clear(void);          // Datensatz mit Nullwerten Initialisieren
   int GetFirstMon(void) {return Monat;};  // Datum des 1. Eintrages (Monat)
   int GetFirstYear(void) {return Jahr;};  // Datum des 1. Eintrages (Jahr)
   int GetCurrentMon(void);  // Datum des aktuellen Eintrages (Monat)
   int GetCurrentYear(void); // Datum des aktuellen Eintrages (Jahr)
   //int GetLastMon(void);     // Datum des letzten Eintrages (Monat)
   //int GetLastYear(void);    // Datum des letzten Eintrages (Jahr)
   int GetValid(long int Vld, int Bit); // Valid-Bit prfen
   void SetValid(long int * Vld, int Bit, int Set); // Valid-Bit ndern
   void ValidTestAus(long int v);

   // DisplayBits
   void SetVisible(int Nr, int Dsp);  // Display-Bit gezielt setzen/zurcksetzen
   int  IsVisible(int Nr);            // Display-Bit abfragen
   int  LoadVisibleBits(void);        // visiblebits aus Datei lesen
   int  SaveVisibleBits(void);        // visiblebits in Datei speichern

   DataArrType DataArr;      // Array mit den Headerinformationen
   DataType DPTR;            // Zeiger auf die Daten
   ValidType VDTA;           // Gltigkeitsdaten
   ZAType ZA;                // lckenlose Datas
   ZHType ZH;                // Headerverweise der Datas
   // int Tag,Item,Count;       // aktueller Eintrag (Item auf ZA bezogen)
   int /*TageCount,*/ItemCount;  // Anzahl Tage / Items mit Daten
private:
   void ClearDataArr(void);  // Speicher fr Datenarray freigeben
   FILE *DF;                 // Handles zu den Datendateien
   int Active;               // Status der Datei (geffnet oder nicht)
   QString DN;               // Dateiname
   unsigned long Offset;     // 'Lnge' der Headerdaten
   unsigned long DataSize;   // Gre eines Datenblocks
   short Monat,Jahr;         // Erstes Datum in der Datei
   long FilePos;             // aktueller Datensatz (-nummer)
   long RecordCount;         // Anzahl der Datenstze
   IPtr DisplayBits;
};
#endif
