/*
 *   kvideolist - a database for home-movie collections
 *   Copyright (C) 1998  Holger Hetterich
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or           *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
                                       
#include <stdio.h>
#include <qfiledlg.h>
#include "mlist.h"
#include "export.moc"
#include <kfiledialog.h>


Export::Export(QWidget *parent, const char *name):QDialog(parent,name,TRUE) {
	this->setCaption(klocale->translate("Export"));
	this->resize(580,300);

	QLabel *From = new QLabel(this,klocale->translate("Select format:"),this);
	From->resize(160,30);
	From->move(20,10);
	Version=new QComboBox(FALSE,this,"version");
	Version->insertItem(klocale->translate("CSD - for KDE Database Viewer (kdb - version 0.1.1)"),0);
	Version->insertItem(klocale->translate("ASCII - simple text file"),1);

	Version->adjustSize();
	Version->move(183,20);
	
	QPushButton *Filechange = new QPushButton(klocale->translate("Filename..."),this);
	Filechange->resize(214,20);Filechange->move(31,135);
	Filename = new QLineEdit(this,"filename");
	Filename->resize(214,25);Filename->move(31,154);
	QLabel *TargetL = new QLabel(this,klocale->translate("Target filename..."),this);
	TargetL->resize(214,20);
	TargetL->move(260,135);
	
	Target = new QLineEdit(this,"target");
	Target->resize(214,25);Target->move(260,154);
	
	QPushButton *OK = new QPushButton(klocale->translate("Ok"),this);
	QPushButton *Cancel = new QPushButton(klocale->translate("Cancel"),this);
	OK->move(20,255);
	Cancel->move(300,255);

	connect(OK,SIGNAL(clicked()),SLOT(slotOKPressed()));
	connect(Cancel,SIGNAL(clicked()),SLOT(slotCancelPressed()));
	connect(Filechange,SIGNAL(clicked()),SLOT(slotFileChange()));
	connect(Filename,SIGNAL(textChanged(const char *)),SLOT(slotTextChanged()));
};

void Export::slotFileChange() {
	QString s=QFileDialog::getOpenFileName(0,"*.kvl",this);
	Filename->setText(s);
	};
void Export::slotTextChanged() {
	char Dummy[255];
	strcpy(Dummy,"NEW");
	
	if (Version->currentItem()==0) { strcpy(Dummy,"exported.csd");};
	if (Version->currentItem()==1) { strcpy(Dummy,"exported.txt");};

	
	Target->setText(Dummy);
	};
void Export::slotOKPressed() {
	  FILE *Test;
                if ((Test=fopen(Filename->text(),"rb"))==NULL) { QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("The file You selected does not exist."));return;};     	
	if (strlen(Filename->text())==0) {QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("No filename given."));return;};
	if (strcmp(Filename->text(),Target->text()) == 0) { QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("Choose an other target."));return;};

QApplication::setOverrideCursor(waitCursor);


	char File[255];
	char TargetC[255];
	strcpy(File,Filename->text());
	strcpy(TargetC,Target->text());


	if (Version->currentItem()==0) { kvl2csd(File,TargetC); };
	if (Version->currentItem()==1) { kvl2asc(File,TargetC); };





QApplication::restoreOverrideCursor();
QMessageBox::information(this,klocale->translate("Status"),klocale->translate("File export complete."));
 	
	accept();
	};
void Export::slotCancelPressed() {
	reject();
	};


	
