#include <ctype.h>

#include <qfile.h>
#include <qlistview.h>
#include <qstring.h>
#include <qregexp.h>

#include "parseprintcap.h"

void perhapsAddPrinter( QListView * printers, const char * name,
                               const char * host, const char * comment )
{
    const QListViewItem * i = printers->firstChild();
    while( i && qstrcmp( i->text( 0 ), name ) )
        i = i->nextSibling();
    if ( !i )
        (void)new QListViewItem( printers, name,
                                 host ? host : "locally connected",
                                 comment ? comment : "" );
}

void parsePrintcap( QListView * printers )
{
    QFile printcap( "/etc/printcap" );
    if ( !printcap.open( IO_ReadOnly ) )
        return;

    char * line = new char[1025];
    line[1024] = '\0';

    QString printerDesc;
    int lineLength = 0;

    while( !printcap.atEnd() &&
           (lineLength=printcap.readLine( line, 1024 )) > 0 ) {
        if ( *line == '#' ) {
            *line = '\0';
            lineLength = 0;
        }
        if ( lineLength >= 2 && line[lineLength-2] == '\\' ) {
            line[lineLength-2] = '\0';
            printerDesc += line;
        } else {
            printerDesc += line;
            printerDesc = printerDesc.simplifyWhiteSpace();
            int i = printerDesc.find( ':' );
            QString printerName, printerComment, printerHost;
            if ( i >= 0 ) {
                // have : want |
                int j = printerDesc.findRev( '|', i-1 );
                printerName = printerDesc.mid( j+1, i-j-1 );
                if ( j > 0 ) {
                    // try extracting a comment from the aliases...
                    printerComment = "Aliases: ";
                    printerComment += printerDesc.mid( 0, j );
                    for( j=printerComment.length(); j>-1; j-- )
                        if ( printerComment[j] == '|' )
                            printerComment[j] = ',';
                }
                // then look for a real comment
                j = i+1;
                while( printerDesc[j] && isspace(printerDesc[j]) )
                    j++;
                if ( printerDesc[j] != ':' ) {
                    printerComment = printerDesc.mid( i, j-i );
                    printerComment.simplifyWhiteSpace();
                }
                // look for signs of this being a remote printer
                i = printerDesc.find( QRegExp( ": *rm *=" ) );
                if ( i >= 0 ) {
                    // point k at the end of remote host name
                    while( printerDesc[i] != '=' )
                        i++;
                    while( printerDesc[i] == '=' || isspace( printerDesc[i] ) )
                        i++;
                    j = i;
                    while( printerDesc[j] != ':' && printerDesc[j] )
                        j++;

                    // and stuff that into the string
                    printerHost = printerDesc.mid( i, j-i );
                }
            }
            if ( printerName.length() )
                perhapsAddPrinter( printers, printerName, printerHost,
                                   printerComment );
            // chop away the line, for processing the next one
            printerDesc = 0;
        }
    }
    delete[] line;
}

