#include "hilfsrout.h"

#ifndef BSTAR
#define BSTAR

class BStarNode
{
 public:
  BStarNode();
  ~BStarNode();

  bool  isLeaf;
  bool  current;
  int      keyCount;
  int      movieCount;
  
  BStarNode    *sons[MAX_PTRS+1];
  QString       key[MAX_PTRS];
  Movie        *movieList[MAX_MOVIES+1];

  BStarNode    *nextLeaf;
  BStarNode    *prevLeaf;

  void  sortMovieList();
  void  sortKeyList();
};


class BStarTree
{
 public:
  BStarTree();
  
  void bOverflow(BStarNode *);
  void bUnderflow(BStarNode *);
  void bStarUnderflow(BStarNode *, BStarNode *);
  
  void  sort(int);
  int   insert(Movie *);
  int   remove(Movie *);
  void  query(int, char *);
  int   export(char *,char *);
  void  print();
  

  Movie *firstMovie();
  Movie *nextMovie();
  Movie *currentMovie(QString);
 private:
  BStarNode *root;

  void bStarAusgleichen(BStarNode *, BStarNode *,bool);
  void bStarMischen(BStarNode *, BStarNode *,bool);
  void bAusgleichen(BStarNode *, BStarNode *,bool);
  void bMischen(BStarNode *, BStarNode *,bool);
};

#endif
