    /*

    tspgda.h  for ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#ifndef __TSPGDA__
#define __TSPGDA__

#include <kapp.h>

#include "globals.h"
#include "gda.h"
#include "tspio.h"
#include "point.h"




class TspGda : public Gda
  {
  Q_OBJECT

  public:
    enum { LOAD_TSP, GENERATE_TSP, RESUME_TSP };
    TspGda();
    ~TspGda();
    Point *getPoints( int id );
    int numberOfPoints ();
    int numberOfNeighbours();
    bool saveTsp( QString name, int which );

  signals:
    // All signals are for the GUI to chatch up on the progress
    // of the optimization.
    void progressNeighbours( int number );
    void currentRun( int run );
    void bestRun( int bestRun );
    void bestQuality( double bestQuality );
    void currentQuality( double quality );
    void newRun();
    void tspReady( int bestRun );
    void statusChanged( int id );
    void pointsNumber( int number );
    void neighboursNumber( int number );
    void coursesReady();
    void noCoursesReady();

  public slots:
    // Both slots start a TSP optimization. The first one loads a
    // provided TSP and optimizes it while the second one generates
    // a TSP and optimizes it (mostly for testing purposes.)
    void startTsp( QString name, int iterations, int mode = LOAD_TSP );
    void startTsp( int iterations );
    void resumeTsp( QString orig, QString best,
                    int iterations, int performedIterations,
                    double bestQuality );
    void setNumberOfPoints( int number );
    void setNumberOfNeighbours( int number );

  protected:
    // Calculates the difference in quality of the current course
    // and of a small change of it (oldQuality - newQuality) and returns
    // difference.
    virtual DBL nextAction();
    // Changes the course according to nextAction().
    virtual void acceptAction();
    // Calculates the quality of the current course.
    virtual DBL calcQuality();

  private:
    // The original course, either generated or loaded.
    Point *points;
    // The copy of points we are working on.
    Point *actualPoints;
    // The so far best course.
    Point *bestPoints;
    // An internal data structure which determines in which
    // sequence the points of a course are accessed.
    int *_access;
    // The number of points of the TSP we are working on.
    int _numberOfPoints;
    // and the same for configuration
    int _confNumberOfPoints;
    // The number of neighbours of each point we take into
    // account when changing the course.
    int _numberOfNeighbours;
    // and the same for configuration
    int _confNumberOfNeighbours;
    // Only needed for calculating the the neighbours.
    int *_indeces;
    // Dito.
    DBL *_distances;
    // A class that performs all IO operations.
    TspIO *io;
    // Some data needed bei nextAction() and
    // acceptAction().
    int actPoint;
    int oldPoint;
    int actNeighbour;
    int oldNeighbour;
    int itStart;
    QString resumedBestName;
    // The so far best course.
    int _bestRun;
    // A class that provides us with random numbers needed
    // for finding a random starting point for each run.
    Random *rand;
    // The so far best quality.
    DBL _bestQuality;
    DBL resumedBestQuality;
    // The scale factor needed for startGda().
    DBL scaleFactor;

    // Rather uninteresting internal functions which prepare
    // a TSP for being optimized.
    void calcNeighbours();
    void sortNeighbours( int index );
    void calcScale();
    void copyPoints( Point *target, Point *source );
    void checkOldTsp();
  };





#endif   // __TSPGDA__
