    /*

    tspdialog.h  for  ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#ifndef __TSPDIALOG__
#define __TSPDIALOG__


#include <qdialog.h>
#include <qlabel.h>
#include <qslider.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlayout.h>

#include "globals.h"



class TspDialog : public QDialog
  {
  Q_OBJECT

  public:
    TspDialog( int numberOfPoints,
               int numberOfPointsDefault,
               int numberOfRuns,
               int numberOfRunsDefault,
               int numberOfNeighbours,
               int numberOfNeighboursDefault,
               int rainspeedValue,
               int rainspeedValueDefault,
               QWidget *parent = 0,
               const char *name = 0 );
    ~TspDialog();

  signals:
    void pointsChanged( int number );
    void runsChanged( int number );
    void neighboursChanged( int number );
    void rainspeedChanged( int number );

  private slots:
    void slotOK();
    void slotDefaults();
    void slotCheckNeighbours( int number );
    void slotCheckPoints( int number );
    void slotCheckRuns( int number );
    void slotCheckRain( int number );

  private:
    QLabel *pointsNum;
    QSlider *pointsSlider;
    QLabel *runsNum;
    QSlider *runsSlider;
    QLabel *neighboursNum;
    QSlider *neighboursSlider;
    QLabel *rainspeedNum;
    QSlider *rainspeedSlider;

    int points;
    int pointsDefault;
    int runs;
    int runsDefault;
    int neighbours;
    int neighboursDefault;
    int rainspeed;
    int rainspeedDefault;
  };




#endif   // __TSPDIALOG__
