    /*

    graph.C  for  KTsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */



#include <iostream.h>
#include <qpen.h>
#include <qpainter.h>
#include <kapp.h>

#include "graph.h"



Graph::Graph( QWidget *parent, const char *name )
          : QWidget( parent, name )
  {
  vScale = 0.0;
  hScale = 0;
  receivedValues = 0;
  values.setAutoDelete( true );
  setBackgroundColor( black );
  setMinimumSize( 200, 100 );
  }


Graph::~Graph()
  {
  values.clear();
  }


QSize Graph::sizeHint() const
  {
  return minimumSize();
  }


void Graph::clear()
  {
  erase();
  values.clear();
  receivedValues = 0;
  }


void Graph::setVScale( double v )
  {
  vScale = v;
  }


void Graph::setHScale( int h )
  {
  hScale = h;
  }


int Graph::numberOfValues()
  {
  return receivedValues;
  }


double Graph::firstValue()
  {
  return *values.first();
  }


double Graph::nextValue()
  {
  return *values.next();
  }


void Graph::slotNextValue( double value )
  {
  if ( receivedValues >= hScale )
    {
    setHScale( hScale * 2 );
    update();
    }
  QPainter *painter = new QPainter( this );
  CHECK_PTR( painter );
  painter->setWindow( 0, 0, hScale, vScale );
  painter->setPen( red );
  if ( receivedValues == 0 )
    {
    painter->drawPoint( 0, vScale - value );
    }
  else
    {
    painter->drawLine( receivedValues - 1, vScale - *values.getLast(),
                       receivedValues, vScale - value );
    }
  delete painter;
  double *tmp = new double;
  CHECK_PTR( tmp );
  *tmp = value;
  values.append( tmp );
  receivedValues++;
  }


void Graph::paintEvent( QPaintEvent * )
  {
  if ( receivedValues != 0 )
    {
    QPainter *painter = new QPainter( this );
    CHECK_PTR( painter );
    painter->setWindow( 0, 0, hScale, vScale );
    painter->setPen( red );
    double *tmp;
    double last;
    tmp = values.first();
    if ( tmp != 0 )
      {
      painter->drawPoint( 0, vScale - *tmp );
      last = *tmp;
      }
    tmp = values.next();
    for ( int i = 1; tmp != 0; tmp = values.next(), i++ )
      {
      painter->drawLine( i - 1, vScale - last,
                         i, vScale - *tmp );
      last = *tmp;
      }
    delete painter;
    }
  }


