    /*

    canvas.C  for  ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#include <iostream.h>
#include <qpainter.h>

#include "canvas.h"
#include "graphicdialog.h"



Canvas::Canvas( QWidget *parent, const char *name )
          : QWidget( parent, name )
  {
  points = 0;
  pixmap = 0;
  _pointsShape = GraphicDialog::Circle;
  _pointsColour = red;
  _pointsSize = GraphicDialog::Small;
  _linesStyle = DashDotDotLine;
  _linesColour = blue;
  _linesWidth = GraphicDialog::Small;
  }


Canvas::~Canvas()
  {
  if ( pixmap != 0 ) delete pixmap;
  }


void Canvas::setPoints( Point * tsp )
  {
  points = tsp;
  }


void Canvas::setParameters( DBL w, DBL h, DBL mx, DBL my )
  {
  _width = w;
  _height = h;
  _marginX = mx;
  _marginY = my;
  }


void Canvas::setGraphicParameters( int pointsShape,
                                   int pointsColour,
                                   int pointsSize,
                                   int linesStyle,
                                   int linesColour,
                                   int linesWidth )
  {
  _pointsShape = pointsShape;
  switch ( pointsColour )
    {
    case GraphicDialog::Red:
      _pointsColour = red;
      break;
    case GraphicDialog::Green:
      _pointsColour = green;
      break;
    case GraphicDialog::Blue:
      _pointsColour = blue;
      break;
    case GraphicDialog::Black:
      _pointsColour = black;
      break;
    default:
      // Oops! Must not happen!
      _pointsColour = magenta;
      break;
    }
  _pointsSize = 2 + pointsSize;
  switch ( linesStyle )
    {
    case GraphicDialog::Solid:
      _linesStyle = SolidLine;
      break;
    case GraphicDialog::Dash:
      _linesStyle = DashLine;
      break;
    case GraphicDialog::Dotted:
      _linesStyle = DotLine;
      break;
    case GraphicDialog::Dashdot:
      _linesStyle = DashDotLine;
    default:
      // Oops! Must not happen.
      _linesStyle = DashDotDotLine;
    }
  switch ( linesColour )
    {
    case GraphicDialog::Red:
      _linesColour = red;
      break;
    case GraphicDialog::Green:
      _linesColour = green;
      break;
    case GraphicDialog::Blue:
      _linesColour = blue;
      break;
    case GraphicDialog::Black:
      _linesColour = black;
      break;
    default:
      // Oops! Must not happen!
      _linesColour = magenta;
      break;
    }
  _linesWidth = linesWidth;
  }


void Canvas::paintEvent( QPaintEvent * )
  {
  if ( points != 0 )
    {
    QRect r = rect();
    if ( pixmap == 0 )
      {
      QPen pointsPen( _pointsColour, 0, SolidLine );
      QPen linesPen( _linesColour, _linesWidth + 1, _linesStyle );
      pixmap = new QPixmap( r.size() );
      pixmap->fill( this, r.topLeft() );
      Point *p = points;
      QPainter *painter = new QPainter( pixmap );
      CHECK_PTR( painter );
      painter->setWindow( _marginX, _marginY, _width, _height );
      painter->setViewport( 10, 10, width() - 20, height() - 20 );
      do
        {
        painter->setPen( pointsPen );
        switch ( _pointsShape )
          {
          case GraphicDialog::Circle:
            painter->drawArc( p->x() - _pointsSize, p->y() - _pointsSize,
                              2 * _pointsSize , 2 * _pointsSize,
                              0, 16*360 );
            break;
          case GraphicDialog::Square:
            painter->drawRect( p->x() - _pointsSize, p->y() - _pointsSize,
                               2 * _pointsSize + 1, 2 * _pointsSize + 1 );
            break;
          default:
            // Oops! Must not happen
            break;
          }
        painter->setPen( linesPen );
        painter->drawLine( p->x(), p->y(),
                           p->nextPointer()->x(), p->nextPointer()->y() );
        p = p->nextPointer();
        } while( p != points );
      delete painter;
      bitBlt( this, r.topLeft(), pixmap );
      }
    else
      {
      bitBlt( this, r.topLeft(), pixmap );
      }
    }
  }
