/* -*- C++ -*- */

/**********************************************************************/
/*   TimeMon (c)  1994  Helmut Maierhofer			      */
/*   KDE-ified M. Maierhofer 1998                                     */
/**********************************************************************/

/*
 * timemon.h
 *
 * Definitions for the timemon widget.
 */

#ifndef TIMEMON_H
#define TIMEMON_H

#include <qcolor.h>
#include <qwidget.h>
#include <qpopmenu.h>
#include <qtimer.h>
#include <qtooltip.h>

// -- global constants ---------------------------------------------------

const int MAX_MOUSE_ACTIONS = 3; // event handlers for the three buttons only

#include "../config.h"
#include "confdlg.h"

// -- global variables ---------------------------------------------------
extern KApplication *app;	// both defined in timemon.cc
extern KConfig *conf;

// -- forward declaration ------------------------------------------------
class KSample;
class KConfDialog;
class QPaintEvent;
class QMouseEvent;
class QPainter;
class KProcess;
class KShellProcess;

// -- KTimeMonWidget declaration -----------------------------------------

/*
 * KTimeMonWidget
 *
 * This class is responsible for drawing the bar graph. It gets its data
 * from the associated KSample object (if any), and may delegate mouse
 * events to the `delegate' set in the constructor (e.g. used to generate
 * the pop-up menu).
 */
class KTimeMonWidget : public QWidget {
  Q_OBJECT
public:
  KTimeMonWidget(KTimeMonWidget *delegate = 0, bool mode = false, 
		 bool vertical = true, QWidget *w = 0);
  ~KTimeMonWidget() {}

  void setSample(KSample *s) { sample = s; }
  void showTip();

protected:
  virtual void updateConfig(KConfDialog *d);
  virtual void paintEvent(QPaintEvent *event);
  virtual void mousePressEvent(QMouseEvent *event);
  void switchMode();

private:

  /*
   * KTimeMonWidget::ToolTip
   *
   * Simple interface to the Qt tooltip mechanism; the "hard work" is handled
   * by KTimeMonWidget itself.
   */
  class ToolTip: public QToolTip {
  public:
    ToolTip(KTimeMonWidget *p) : QToolTip(p), timemon(p) {}

    void doTip(const QRect &r, const char *t) { tip(r, t); }

  protected:
    virtual void maybeTip(const QPoint &) { timemon->showTip(); }

  public:
    KTimeMonWidget *timemon;
  };

  inline void paintRect(int x, int y, int w, int h, QColor c, QPainter *p);

  KTimeMonWidget *delegate;
  ToolTip tip;
  KSample *sample;
  QColor kernelColour, userColour, niceColour;
  QColor cachedColour, usedColour, buffersColour;
  QColor swapColour, bgColour;
  bool mode, vertical, tooltip;

friend class KTimeMon;
friend class KConfDialog;
};

// -- KTimeMon declaration -----------------------------------------------

/*
 * KTimeMon
 *
 * This is the main widget of the application. It handles the configuration
 * dialog and may have an associated KTimeMonWidget in the panel (in which
 * case it hides itself).
 */
class KTimeMon : public KTimeMonWidget {
  Q_OBJECT
public:
  enum MouseAction { NOTHING, SWITCH, MENU, COMMAND };

  KTimeMon();
  virtual ~KTimeMon();

  void stop() { timer.stop(); }	// stop the timer event
  void cont() { timer.start(interval); } // restart the timer
  void writeConfiguration();	// write back the configuration data

public slots:
  void timeout();		// timer expired
  void save();			// session management callback
  void apply();			// apply configuration information

protected:
  virtual void mousePressEvent(QMouseEvent *event);

private slots:			// called from the menu
  void quit() { app->exit(0); }	// terminate the application
  void panelise();		// switch between panel/normal window mode
  void configure();		// show the configuration dialog
  void orientation();		// switch vertical/horizontal orientation
  void commandStderr(KProcess *proc, char *buffer, int length);

private:
  void runCommand(int index);

  bool panelised;
  KSample *sample;
  unsigned interval;
  bool autoScale;
  unsigned pageScale, swapScale, ctxScale;
  QPopupMenu menu;
  KTimeMonWidget *panelWidget;
  QTimer timer;
  KConfDialog *configDialog;
  MouseAction mouseAction[MAX_MOUSE_ACTIONS];
  QString mouseActionCommand[MAX_MOUSE_ACTIONS];
  KShellProcess *bgProcess;

friend class KConfDialog;
};

#endif // TIMEMON_H
