/* -*- C++ -*- */

/**********************************************************************/
/*   TimeMon (c)  1994  Helmut Maierhofer			      */
/*   KDE-ified M. Maierhofer 1998                                     */
/**********************************************************************/

/*
 * confdlg.h
 *
 * Definitions for the timemon configuration dialog.
 */

#ifndef CONFDLG_H
#define CONFDLG_H

#include <qcolor.h>
#include <qchkbox.h>
#include <qtabdlg.h>
#include <kintegerline.h>
#include <kcolorbtn.h>
#include <klined.h>
#include <kcombo.h>

#include "../config.h"
#include "timemon.h"

// -- forward declaration ------------------------------------------------
class KTimeMon;
class KTimeMonWidget;
class QLineEdit;
class QSlider;
class KColorButton;

// -- KIntEdit declaration -----------------------------------------------

/*
 * KIntEdit
 *
 * A simple edit field for integer input only. The reason for deriving
 * it from KIntegerLine is that we need a slot with the specified
 * signature (integer).
 */
class KIntEdit : public KIntegerLine {
  Q_OBJECT
public:
  KIntEdit(QWidget *p = 0, const char *n = 0) : KIntegerLine(p, n) {}

public slots:
  void setIntValue(int value) { setValue(value); }
};

// -- KConfDialog declaration --------------------------------------------

/*
 * KConfDialog
 */
class KConfDialog : public QTabDialog {
  Q_OBJECT
public:
  KConfDialog(KTimeMon *timemon);
  ~KConfDialog() {}

  void update();		// get values from timemon

  unsigned getInterval() const { return intervalEdit->value(); }
  QColor getKernelColour() const { return kernelCB->color(); }
  QColor getUserColour() const { return userCB->color(); }
  QColor getNiceColour() const { return niceCB->color(); }
  QColor getCachedColour() const { return cachedCB->color(); }
  QColor getUsedColour() const { return usedCB->color(); }
  QColor getBuffersColour() const { return buffersCB->color(); }
  QColor getSwapColour() const { return swapCB->color(); }
  QColor getBgColour() const { return bgCB->color(); }

  bool getAutoScale() const { return autoScaleBox->isChecked(); }
  bool getToolTip() const { return toolTipBox->isChecked(); }
  unsigned getPageScale() const { return pageScaleEdit->value(); }
  unsigned getSwapScale() const { return swapScaleEdit->value(); }
  unsigned getCtxScale() const { return ctxScaleEdit->value(); }

  unsigned getMouseAction(int i) const { return mouseC[i]->currentItem(); }
  const char *getMouseActionCommand(int i) const { return mouseLE[i]->text(); }

private slots:
  void updateSampleWidget(const QColor &); // update colours in configuration
  void toggle(bool state);	// enable/disable scales
  void mouseInteraction(int);	// check mouse interaction

private:
  KTimeMon *timemon;
  KIntEdit *intervalEdit, *swapScaleEdit, *pageScaleEdit, *ctxScaleEdit;
  QLineEdit *procFileEdit;
  QCheckBox *autoScaleBox, *toolTipBox;
  QSlider *swapSlider, *pageSlider, *ctxSlider;
  KColorButton *kernelCB, *userCB, *niceCB;
  KColorButton *buffersCB, *usedCB, *cachedCB;
  KColorButton *swapCB, *bgCB;
  KLined *mouseLE[MAX_MOUSE_ACTIONS];
  KCombo *mouseC[MAX_MOUSE_ACTIONS];
  KTimeMonWidget *sample;
  bool haveWarned;

friend class KTimeMon;
};

#endif // CONFDLG_H
